/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.PingResponseType;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ping.PingRequest;
import io.github.qsy7.shell.api.model.ping.PingResponse;
import io.github.qsy7.shell.api.service.PingService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.PingTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;

public class DefaultPingService
extends AbstractSingleShellCommandService<PingRequest>
implements PingService {
    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultPingService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=PingTimeout.class) int n) {
        void pingTimeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultPingService defaultPingService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellCommandBuilder2, (ShellExecutionService)shellExecutionService2, (int)pingTimeout);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCommandLine(PingRequest pingRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getCommandLine", (Object[])new Object[]{pingRequest});
        DefaultPingService defaultPingService = this;
        PingRequest pingRequest2 = pingRequest;
        Object object = defaultPingService;
        PingRequest pingRequest3 = pingRequest2;
        try {
            void pingRequest4;
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("ping");
            if (pingRequest4.getCount() > 0) {
                arguments.add("-c");
                arguments.add(Integer.toString(pingRequest4.getCount()));
            } else {
                arguments.add("-c");
                arguments.add("1");
            }
            if (pingRequest4.getInterval() > 0) {
                arguments.add("-i");
                arguments.add(Integer.toString(pingRequest4.getInterval()));
            }
            if (pingRequest4.getTimeout() > 0) {
                arguments.add("-W");
                arguments.add(Integer.toString(pingRequest4.getTimeout()));
            }
            arguments.add(pingRequest4.getNetworkDiagnosticTest().getFqdn());
            object = String.join((CharSequence)" ", arguments);
            return object;
        }
        finally {
            pingRequest3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(PingRequest pingRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"doAfter", (Object[])new Object[]{pingRequest});
        DefaultPingService defaultPingService = this;
        PingRequest pingRequest2 = pingRequest;
        DefaultPingService defaultPingService2 = defaultPingService;
        PingRequest pingRequest3 = pingRequest2;
        try {
            block10: {
                void pingRequest4;
                if (pingRequest4.getShellCommand().getReturnCode() == 0) {
                    for (CommandOutput commandOutput : pingRequest4.getShellCommand().getOutputs()) {
                        if (!commandOutput.getOutput().contains("ping statistics")) continue;
                        IPAddress ipAddress = defaultPingService2.getIPAddress(pingRequest4.getShellCommand());
                        pingRequest4.setIpAddress(ipAddress);
                        pingRequest4.setPingResponseType(PingResponseType.Good);
                        pingRequest4.getPingResponses().addAll(DefaultPingService.getPingStatistics((PingRequest)pingRequest4, pingRequest4.getShellCommand()));
                        break block10;
                    }
                    throw new RuntimeException("Unexpected output, did NOT find ping statistics header");
                }
                if (pingRequest4.getShellCommand().getReturnCode() == 2) {
                    pingRequest4.setPingResponseType(PingResponseType.UnknownHost);
                } else if (pingRequest4.getShellCommand().getReturnCode() == 1) {
                    pingRequest4.setPingResponseType(PingResponseType.NoResponse);
                } else {
                    defaultPingService2.handleOther((PingRequest)pingRequest4);
                }
            }
            defaultPingService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultPingService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"doAfter", (Object[])new Object[]{pingRequest2}, (Throwable)((Object)defaultPingService2));
        }
        if (defaultPingService2 != null) {
            throw defaultPingService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"doAfter", (Object[])new Object[]{pingRequest}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleOther(PingRequest pingRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"handleOther", (Object[])new Object[]{pingRequest});
        DefaultPingService defaultPingService = this;
        PingRequest pingRequest2 = pingRequest;
        DefaultPingService defaultPingService2 = defaultPingService;
        PingRequest pingRequest3 = pingRequest2;
        try {
            void pingRequest4;
            pingRequest4.setPingResponseType(PingResponseType.Other);
            defaultPingService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultPingService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"handleOther", (Object[])new Object[]{pingRequest2}, (Throwable)((Object)defaultPingService2));
        }
        if (defaultPingService2 != null) {
            throw defaultPingService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"handleOther", (Object[])new Object[]{pingRequest}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected IPAddress getIPAddress(ShellCommand shellCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddress", (Object[])new Object[]{shellCommand});
        DefaultPingService defaultPingService = this;
        ShellCommand shellCommand2 = shellCommand;
        DefaultPingService defaultPingService2 = defaultPingService;
        ShellCommand shellCommand3 = shellCommand2;
        try {
            void shellCommand4;
            defaultPingService2 = new IPAddress(DefaultPingService.getIPAddressFromPingOutput((ShellCommand)shellCommand4));
            return defaultPingService2;
        }
        finally {
            shellCommand3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getIPAddressFromPingOutput(ShellCommand shellCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddressFromPingOutput", (Object[])new Object[]{shellCommand});
        ShellCommand shellCommand2 = shellCommand;
        Object object = shellCommand2;
        try {
            void shellCommand3;
            object = ((CommandOutput)shellCommand3.getOutputs().get(0)).getOutput().split(" ")[2].replace("(", "").replace(")", "");
            return object;
        }
        finally {
            Object var5_4 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PingResponse> getPingStatistics(PingRequest pingRequest, ShellCommand shellCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getPingStatistics", (Object[])new Object[]{pingRequest, shellCommand});
        PingRequest pingRequest2 = pingRequest;
        ShellCommand shellCommand2 = shellCommand;
        Object object = pingRequest2;
        ShellCommand shellCommand3 = shellCommand2;
        try {
            void shellCommand4;
            ArrayList<PingResponse> pingResponses = new ArrayList<PingResponse>();
            for (int i = 1; i < shellCommand4.getOutputs().size() && !((CommandOutput)shellCommand4.getOutputs().get(i)).getOutput().contains("ping statistics") && ((CommandOutput)shellCommand4.getOutputs().get(i)).getOutput() != null && !((CommandOutput)shellCommand4.getOutputs().get(i)).getOutput().trim().isEmpty(); ++i) {
                void pingRequest3;
                String[] splitLine = ((CommandOutput)shellCommand4.getOutputs().get(i)).getOutput().split(" ");
                int ttl = Integer.valueOf(splitLine[6].replace("ttl=", ""));
                double time = Double.valueOf(splitLine[7].replace("time=", ""));
                pingResponses.add(new PingResponse((PingRequest)pingRequest3, i - 1, ttl, time));
            }
            object = pingResponses;
            return object;
        }
        finally {
            shellCommand3 = null;
        }
    }
}

