/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.ssh.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.ssh.api.SSHCommandService;
import io.github.qsy7.ssh.api.SSHPublicKeyPath;
import io.github.qsy7.ssh.api.model.command.SSHCommand;
import io.github.qsy7.ssh.api.model.command.SSHExpectCommand;
import io.github.qsy7.ssh.executor.DefaultSSHCommandExecutor;
import io.github.qsy7.ssh.executor.ExpectSSHCommandExecutor;
import io.github.qsy7.ssh.property.InterruptGracePeriodUnits;
import io.github.qsy7.ssh.property.InterruptGracePeriodValue;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;

public class DefaultSSHCommandService
implements SSHCommandService,
AutoCloseable {
    protected final String sshPublicKeyPath;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;
    protected boolean shutdown;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultSSHCommandService(@Property(value=SSHPublicKeyPath.class) String string, @Property(value=InterruptGracePeriodUnits.class) ChronoUnit chronoUnit, @Property(value=InterruptGracePeriodValue.class) long l) {
        void interruptGracePeriodValue;
        AutoCloseable autoCloseable = this;
        String string2 = string;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l2 = l;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"<init>", (Object[])new Object[]{string2, chronoUnit2, l2});
        DefaultSSHCommandService defaultSSHCommandService = autoCloseable;
        String string3 = string2;
        ChronoUnit chronoUnit3 = chronoUnit2;
        long l4 = l2;
        interruptGracePeriodValue.shutdown = false;
        interruptGracePeriodValue.sshPublicKeyPath = string3;
        interruptGracePeriodValue.interruptGracePeriodUnits = chronoUnit3;
        interruptGracePeriodValue.interruptGracePeriodValue = l4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"<init>", (Object[])new Object[]{string2, chronoUnit2, l2}, null, (long)l3);
        autoCloseable = this;
        CloseableUtil.addAutoCloseable((AutoCloseable)autoCloseable);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(SSHCommand ... sSHCommandArray) throws Exception {
        SSHCommand[] sSHCommandArray2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommandArray});
        DefaultSSHCommandService defaultSSHCommandService = this;
        for (SSHCommand sSHCommand : sSHCommandArray2 = sSHCommandArray) {
            void commands;
            commands.execute(sSHCommand);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommandArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(SSHCommand sSHCommand) throws Exception {
        void command;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommand});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHCommand sSHCommand2 = sSHCommand;
        command.checkIfShutdown();
        new DefaultSSHCommandExecutor(command.sshPublicKeyPath, sSHCommand2, command.interruptGracePeriodUnits, command.interruptGracePeriodValue).execute();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(SSHExpectCommand ... sSHExpectCommandArray) throws Exception {
        SSHExpectCommand[] sSHExpectCommandArray2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommandArray});
        DefaultSSHCommandService defaultSSHCommandService = this;
        for (SSHExpectCommand sSHExpectCommand : sSHExpectCommandArray2 = sSHExpectCommandArray) {
            void commands;
            commands.execute(sSHExpectCommand);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommandArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(SSHExpectCommand sSHExpectCommand) throws Exception {
        void command;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommand});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHExpectCommand sSHExpectCommand2 = sSHExpectCommand;
        command.checkIfShutdown();
        new ExpectSSHCommandExecutor(command.sshPublicKeyPath, sSHExpectCommand2).execute();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommand}, null, (long)l);
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultSSHCommandService defaultSSHCommandService = this;
        if (defaultSSHCommandService.shutdown) {
            throw new IllegalStateException("Unable to run new commands as the system is shutting down.");
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"close", (Object[])new Object[0]);
        DefaultSSHCommandService defaultSSHCommandService = this;
        defaultSSHCommandService.shutdown = true;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"close", (Object[])new Object[0], null, (long)l);
    }
}

