/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.custom;

import io.queryanalyzer.core.analyzer.StackTraceFilter;
import io.queryanalyzer.core.detector.QueryDetector;
import io.queryanalyzer.core.model.IssueType;
import io.queryanalyzer.core.model.QueryInfo;
import io.queryanalyzer.core.model.QueryIssue;
import io.queryanalyzer.core.model.Severity;
import io.queryanalyzer.core.tracker.QueryTracker;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DuplicateQueryDetector
implements QueryDetector {
    private static final int DUPLICATE_THRESHOLD = 2;

    public String getName() {
        return "duplicate-query";
    }

    public List<QueryIssue> detect(List<QueryInfo> queries) {
        if (queries == null || queries.isEmpty()) {
            return List.of();
        }
        Map<String, Long> queryCounts = queries.stream().collect(Collectors.groupingBy(QueryInfo::getSql, Collectors.counting()));
        ArrayList<QueryIssue> issues = new ArrayList<QueryIssue>();
        queryCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() >= 2L).forEach(entry -> {
            String sql = (String)entry.getKey();
            long count = (Long)entry.getValue();
            List<QueryInfo> duplicates = queries.stream().filter(q -> q.getSql().equals(sql)).collect(Collectors.toList());
            String location = this.findApplicationCode(duplicates);
            String endpoint = QueryTracker.getEndpoint();
            QueryIssue issue = QueryIssue.builder().type(IssueType.N_PLUS_ONE).severity(this.determineSeverity(count)).description(String.format("Exact duplicate query executed %d times", count)).location(location).endpoint(endpoint).sampleQuery(sql).detectedAt(Instant.now()).suggestions(List.of("Consider caching the query result", "Check if the logic can be refactored to execute once", "Use a request-scoped cache for this data")).build();
            issues.add(issue);
        });
        return issues;
    }

    private Severity determineSeverity(long count) {
        if (count >= 10L) {
            return Severity.ERROR;
        }
        if (count >= 5L) {
            return Severity.WARNING;
        }
        return Severity.INFO;
    }

    private String findApplicationCode(List<QueryInfo> queries) {
        String endpoint;
        if (queries == null || queries.isEmpty()) {
            return "unknown";
        }
        QueryInfo firstQuery = queries.get(0);
        Object location = StackTraceFilter.findApplicationCode((StackTraceElement[])firstQuery.getStackTrace());
        if ("unknown".equals(location) && (endpoint = QueryTracker.getEndpoint()) != null && !endpoint.isEmpty()) {
            location = "Endpoint: " + endpoint;
        }
        return location;
    }
}

