/*
 * Decompiled with CFR 0.152.
 */
package io.github.schorcher.stringInterpolator.expression;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import io.github.schorcher.stringInterpolator.StringInterpolation;
import io.github.schorcher.stringInterpolator.expression.ExpUtil;
import io.github.schorcher.stringInterpolator.expression.Expression;
import io.github.schorcher.stringInterpolator.expression.ExpressionParser;
import java.util.List;
import java.util.function.Supplier;

public class AstTranslator
extends TreeTranslator {
    private final TreeMaker treeMaker;
    private final ExpUtil expUtil;
    private final ExpressionParser expressionParser;
    private boolean interpolate;

    public AstTranslator(Context context) {
        this.treeMaker = TreeMaker.instance(context);
        this.expUtil = new ExpUtil();
        this.expressionParser = new ExpressionParser(Names.instance(context));
    }

    @Override
    public <T extends JCTree> T translate(T t) {
        return super.translate(t);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.doWithInterpolateResolving(() -> this.isAnnotatedByInterpolate(jcClassDecl.getModifiers()) || this.interpolate, () -> super.visitClassDef(jcClassDecl));
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jcAnnotation) {
        this.doWithInterpolateResolving(() -> false, () -> super.visitAnnotation(jcAnnotation));
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
        this.doWithInterpolateResolving(() -> this.isAnnotatedByInterpolate(jcMethodDecl.getModifiers()) || this.interpolate, () -> super.visitMethodDef(jcMethodDecl));
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jcVariableDecl) {
        this.doWithInterpolateResolving(() -> this.isAnnotatedByInterpolate(jcVariableDecl.getModifiers()) || this.interpolate, () -> super.visitVarDef(jcVariableDecl));
    }

    private boolean isAnnotatedByInterpolate(JCTree.JCModifiers modifiers) {
        for (JCTree.JCAnnotation annotation : modifiers.getAnnotations()) {
            if (annotation.getAnnotationType() == null || annotation.type == null || !annotation.type.toString().equals(StringInterpolation.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private void doWithInterpolateResolving(Supplier<Boolean> interpolateResolver, Runnable run) {
        boolean interpolateBefore = this.interpolate;
        this.interpolate = interpolateResolver.get();
        run.run();
        this.interpolate = interpolateBefore;
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jcLiteral) {
        super.visitLiteral(jcLiteral);
        if (!this.interpolate) {
            return;
        }
        if (jcLiteral.getValue() instanceof String) {
            List<Expression> expressions = this.expUtil.split(jcLiteral);
            if (expressions.isEmpty()) {
                return;
            }
            if (expressions.size() == 1) {
                this.result = this.convertToExpression(expressions.get(0));
                return;
            }
            JCTree.JCExpression exprLeft = this.convertToExpression(expressions.get(0));
            for (int i = 1; i < expressions.size(); ++i) {
                JCTree.JCExpression exprRight = this.convertToExpression(expressions.get(i));
                exprLeft = this.treeMaker.Binary(JCTree.Tag.PLUS, exprLeft, exprRight);
                exprLeft.setPos(expressions.get(0).getOffset());
            }
            this.result = exprLeft;
        }
    }

    private JCTree.JCExpression convertToExpression(Expression expression) {
        switch (expression.getExpType()) {
            case EXPRESSION: {
                return this.expressionParser.parse(expression);
            }
            case STRING_LITERAL: {
                JCTree.JCLiteral literal = this.treeMaker.Literal(expression.getValue());
                literal.setPos(expression.getOffset());
                return literal;
            }
        }
        throw new RuntimeException("Unexpected token type: " + (Object)((Object)expression.getExpType()));
    }
}

