/*
 * Decompiled with CFR 0.152.
 */
package io.github.schorcher.stringInterpolator.expression;

import com.sun.tools.javac.tree.JCTree;
import io.github.schorcher.stringInterpolator.expression.ExpType;
import io.github.schorcher.stringInterpolator.expression.Expression;
import java.util.ArrayList;
import java.util.List;

public class ExpUtil {
    private final String START = "${";
    private final String END = "}";

    public List<Expression> split(JCTree.JCLiteral jcLiteral) {
        String literalValue = (String)jcLiteral.getValue();
        int originalOffset = jcLiteral.getPreferredPosition();
        return this.split(literalValue, originalOffset);
    }

    public List<Expression> split(String literalValue, int originalOffset) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int startIndex = 0;
        while (startIndex < literalValue.length()) {
            String variable;
            int headIndex = literalValue.indexOf("${", startIndex);
            int offset = originalOffset + headIndex + "${".length() + 1;
            if (headIndex < 0) {
                expressions.add(new Expression(literalValue.substring(startIndex), ExpType.STRING_LITERAL, offset));
                break;
            }
            int endIndex = literalValue.indexOf("}", headIndex);
            if (endIndex < 0) {
                throw new RuntimeException();
            }
            String prefix = literalValue.substring(startIndex, headIndex);
            if (!prefix.equals("")) {
                expressions.add(new Expression(prefix, ExpType.STRING_LITERAL, offset));
            }
            if (!(variable = literalValue.substring(headIndex + "${".length(), endIndex)).equals("")) {
                expressions.add(new Expression(variable, ExpType.EXPRESSION, offset));
            }
            startIndex = endIndex + "}".length();
        }
        return expressions;
    }
}

