/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.proxy.ToolsMainFactory;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;
import scouter.lang.pack.StackPack;
import scouter.lang.step.DumpStep;

public class MakeStack {
    static Configure conf = Configure.getInstance();
    public long lastStackTime;
    public static long pstack_requested;
    long lastStackTraceGenTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Counter
    public void make(CounterBasket pw) {
        if (!this.isPStackEnabled()) {
            ToolsMainFactory.activeStack = false;
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.lastStackTime + this.getSFAInterval()) {
            return;
        }
        this.lastStackTime = now;
        StringWriter sw = new StringWriter();
        try (PrintWriter out = new PrintWriter(sw);){
            ToolsMainFactory.threadDump(out);
        }
        String stack = sw.getBuffer().toString();
        StackPack p = new StackPack();
        p.time = System.currentTimeMillis();
        p.objHash = conf.getObjHash();
        p.setStack(stack);
        DataProxy.sendDirect(p);
        long elapsed = System.currentTimeMillis() - now;
        Logger.trace("[SFA Counter Elasped]" + elapsed);
    }

    private boolean isPStackEnabled() {
        return MakeStack.conf.sfa_dump_enabled || System.currentTimeMillis() < pstack_requested;
    }

    private long getSFAInterval() {
        return MakeStack.conf.sfa_dump_interval_ms;
    }

    @Counter
    public void stackTraceStepGenerator(CounterBasket pw) {
        if (!MakeStack.conf._psts_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.lastStackTraceGenTime + (long)MakeStack.conf._psts_dump_interval_ms) {
            return;
        }
        this.lastStackTraceGenTime = now;
        ThreadMXBean tmxBean = ManagementFactory.getThreadMXBean();
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        while (en.hasMoreElements()) {
            ThreadInfo tInfo;
            TraceContext ctx = en.nextElement();
            if (ctx == null || ctx.threadId <= 0L || (tInfo = tmxBean.getThreadInfo(ctx.threadId, 50)) == null) continue;
            StackTraceElement[] elements = tInfo.getStackTrace();
            int length = elements.length;
            int[] stacks = new int[length];
            for (int i = 0; i < length; ++i) {
                stacks[i] = DataProxy.sendStackElement(elements[i]);
            }
            DumpStep dumpStep = new DumpStep();
            dumpStep.start_time = (int)(System.currentTimeMillis() - ctx.startTime);
            dumpStep.stacks = stacks;
            dumpStep.threadId = ctx.threadId;
            dumpStep.threadName = tInfo.getThreadName();
            dumpStep.threadState = tInfo.getThreadState().toString();
            dumpStep.lockOwnerId = tInfo.getLockOwnerId();
            dumpStep.lockName = tInfo.getLockName();
            dumpStep.lockOwnerName = tInfo.getLockOwnerName();
            ctx.temporaryDumpSteps.offer(dumpStep);
            ctx.hasDumpStack = true;
        }
        long elapsed = System.currentTimeMillis() - now;
        Logger.trace("[ASTS Elasped]" + elapsed);
    }
}

