/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AugustDeviceMetadata {
    private final String lockId;
    private final String lockName;
    private final String houseName;
    private final Optional<String> houseId;
    private final boolean hasKeypad;
    private final Optional<String> model;
    private final Optional<String> keypadBatteryLevel;
    private final Map<String, Object> additionalProperties;

    private AugustDeviceMetadata(String lockId, String lockName, String houseName, Optional<String> houseId, boolean hasKeypad, Optional<String> model, Optional<String> keypadBatteryLevel, Map<String, Object> additionalProperties) {
        this.lockId = lockId;
        this.lockName = lockName;
        this.houseName = houseName;
        this.houseId = houseId;
        this.hasKeypad = hasKeypad;
        this.model = model;
        this.keypadBatteryLevel = keypadBatteryLevel;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="lock_id")
    public String getLockId() {
        return this.lockId;
    }

    @JsonProperty(value="lock_name")
    public String getLockName() {
        return this.lockName;
    }

    @JsonProperty(value="house_name")
    public String getHouseName() {
        return this.houseName;
    }

    @JsonProperty(value="house_id")
    public Optional<String> getHouseId() {
        return this.houseId;
    }

    @JsonProperty(value="has_keypad")
    public boolean getHasKeypad() {
        return this.hasKeypad;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="keypad_battery_level")
    public Optional<String> getKeypadBatteryLevel() {
        return this.keypadBatteryLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AugustDeviceMetadata && this.equalTo((AugustDeviceMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AugustDeviceMetadata other) {
        return this.lockId.equals(other.lockId) && this.lockName.equals(other.lockName) && this.houseName.equals(other.houseName) && this.houseId.equals(other.houseId) && this.hasKeypad == other.hasKeypad && this.model.equals(other.model) && this.keypadBatteryLevel.equals(other.keypadBatteryLevel);
    }

    public int hashCode() {
        return Objects.hash(this.lockId, this.lockName, this.houseName, this.houseId, this.hasKeypad, this.model, this.keypadBatteryLevel);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LockIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LockIdStage,
    LockNameStage,
    HouseNameStage,
    HasKeypadStage,
    _FinalStage {
        private String lockId;
        private String lockName;
        private String houseName;
        private boolean hasKeypad;
        private Optional<String> keypadBatteryLevel = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<String> houseId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AugustDeviceMetadata other) {
            this.lockId(other.getLockId());
            this.lockName(other.getLockName());
            this.houseName(other.getHouseName());
            this.houseId(other.getHouseId());
            this.hasKeypad(other.getHasKeypad());
            this.model(other.getModel());
            this.keypadBatteryLevel(other.getKeypadBatteryLevel());
            return this;
        }

        @Override
        @JsonSetter(value="lock_id")
        public LockNameStage lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        @Override
        @JsonSetter(value="lock_name")
        public HouseNameStage lockName(String lockName) {
            this.lockName = lockName;
            return this;
        }

        @Override
        @JsonSetter(value="house_name")
        public HasKeypadStage houseName(String houseName) {
            this.houseName = houseName;
            return this;
        }

        @Override
        @JsonSetter(value="has_keypad")
        public _FinalStage hasKeypad(boolean hasKeypad) {
            this.hasKeypad = hasKeypad;
            return this;
        }

        @Override
        public _FinalStage keypadBatteryLevel(String keypadBatteryLevel) {
            this.keypadBatteryLevel = Optional.of(keypadBatteryLevel);
            return this;
        }

        @Override
        @JsonSetter(value="keypad_battery_level", nulls=Nulls.SKIP)
        public _FinalStage keypadBatteryLevel(Optional<String> keypadBatteryLevel) {
            this.keypadBatteryLevel = keypadBatteryLevel;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage houseId(String houseId) {
            this.houseId = Optional.of(houseId);
            return this;
        }

        @Override
        @JsonSetter(value="house_id", nulls=Nulls.SKIP)
        public _FinalStage houseId(Optional<String> houseId) {
            this.houseId = houseId;
            return this;
        }

        @Override
        public AugustDeviceMetadata build() {
            return new AugustDeviceMetadata(this.lockId, this.lockName, this.houseName, this.houseId, this.hasKeypad, this.model, this.keypadBatteryLevel, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AugustDeviceMetadata build();

        public _FinalStage houseId(Optional<String> var1);

        public _FinalStage houseId(String var1);

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage keypadBatteryLevel(Optional<String> var1);

        public _FinalStage keypadBatteryLevel(String var1);
    }

    public static interface HasKeypadStage {
        public _FinalStage hasKeypad(boolean var1);
    }

    public static interface HouseNameStage {
        public HasKeypadStage houseName(String var1);
    }

    public static interface LockNameStage {
        public HouseNameStage lockName(String var1);
    }

    public static interface LockIdStage {
        public LockNameStage lockId(String var1);

        public Builder from(AugustDeviceMetadata var1);
    }
}

