/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClientSession {
    private final String clientSessionId;
    private final Optional<String> userIdentifierKey;
    private final OffsetDateTime createdAt;
    private final String token;
    private final double deviceCount;
    private final List<String> connectedAccountIds;
    private final List<String> connectWebviewIds;
    private final String workspaceId;
    private final Map<String, Object> additionalProperties;

    private ClientSession(String clientSessionId, Optional<String> userIdentifierKey, OffsetDateTime createdAt, String token, double deviceCount, List<String> connectedAccountIds, List<String> connectWebviewIds, String workspaceId, Map<String, Object> additionalProperties) {
        this.clientSessionId = clientSessionId;
        this.userIdentifierKey = userIdentifierKey;
        this.createdAt = createdAt;
        this.token = token;
        this.deviceCount = deviceCount;
        this.connectedAccountIds = connectedAccountIds;
        this.connectWebviewIds = connectWebviewIds;
        this.workspaceId = workspaceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="client_session_id")
    public String getClientSessionId() {
        return this.clientSessionId;
    }

    @JsonProperty(value="user_identifier_key")
    public Optional<String> getUserIdentifierKey() {
        return this.userIdentifierKey;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="device_count")
    public double getDeviceCount() {
        return this.deviceCount;
    }

    @JsonProperty(value="connected_account_ids")
    public List<String> getConnectedAccountIds() {
        return this.connectedAccountIds;
    }

    @JsonProperty(value="connect_webview_ids")
    public List<String> getConnectWebviewIds() {
        return this.connectWebviewIds;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClientSession && this.equalTo((ClientSession)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClientSession other) {
        return this.clientSessionId.equals(other.clientSessionId) && this.userIdentifierKey.equals(other.userIdentifierKey) && this.createdAt.equals(other.createdAt) && this.token.equals(other.token) && this.deviceCount == other.deviceCount && this.connectedAccountIds.equals(other.connectedAccountIds) && this.connectWebviewIds.equals(other.connectWebviewIds) && this.workspaceId.equals(other.workspaceId);
    }

    public int hashCode() {
        return Objects.hash(this.clientSessionId, this.userIdentifierKey, this.createdAt, this.token, this.deviceCount, this.connectedAccountIds, this.connectWebviewIds, this.workspaceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ClientSessionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ClientSessionIdStage,
    CreatedAtStage,
    TokenStage,
    DeviceCountStage,
    WorkspaceIdStage,
    _FinalStage {
        private String clientSessionId;
        private OffsetDateTime createdAt;
        private String token;
        private double deviceCount;
        private String workspaceId;
        private List<String> connectWebviewIds = new ArrayList<String>();
        private List<String> connectedAccountIds = new ArrayList<String>();
        private Optional<String> userIdentifierKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ClientSession other) {
            this.clientSessionId(other.getClientSessionId());
            this.userIdentifierKey(other.getUserIdentifierKey());
            this.createdAt(other.getCreatedAt());
            this.token(other.getToken());
            this.deviceCount(other.getDeviceCount());
            this.connectedAccountIds(other.getConnectedAccountIds());
            this.connectWebviewIds(other.getConnectWebviewIds());
            this.workspaceId(other.getWorkspaceId());
            return this;
        }

        @Override
        @JsonSetter(value="client_session_id")
        public CreatedAtStage clientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public TokenStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="token")
        public DeviceCountStage token(String token) {
            this.token = token;
            return this;
        }

        @Override
        @JsonSetter(value="device_count")
        public WorkspaceIdStage deviceCount(double deviceCount) {
            this.deviceCount = deviceCount;
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public _FinalStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public _FinalStage addAllConnectWebviewIds(List<String> connectWebviewIds) {
            this.connectWebviewIds.addAll(connectWebviewIds);
            return this;
        }

        @Override
        public _FinalStage addConnectWebviewIds(String connectWebviewIds) {
            this.connectWebviewIds.add(connectWebviewIds);
            return this;
        }

        @Override
        @JsonSetter(value="connect_webview_ids", nulls=Nulls.SKIP)
        public _FinalStage connectWebviewIds(List<String> connectWebviewIds) {
            this.connectWebviewIds.clear();
            this.connectWebviewIds.addAll(connectWebviewIds);
            return this;
        }

        @Override
        public _FinalStage addAllConnectedAccountIds(List<String> connectedAccountIds) {
            this.connectedAccountIds.addAll(connectedAccountIds);
            return this;
        }

        @Override
        public _FinalStage addConnectedAccountIds(String connectedAccountIds) {
            this.connectedAccountIds.add(connectedAccountIds);
            return this;
        }

        @Override
        @JsonSetter(value="connected_account_ids", nulls=Nulls.SKIP)
        public _FinalStage connectedAccountIds(List<String> connectedAccountIds) {
            this.connectedAccountIds.clear();
            this.connectedAccountIds.addAll(connectedAccountIds);
            return this;
        }

        @Override
        public _FinalStage userIdentifierKey(String userIdentifierKey) {
            this.userIdentifierKey = Optional.of(userIdentifierKey);
            return this;
        }

        @Override
        @JsonSetter(value="user_identifier_key", nulls=Nulls.SKIP)
        public _FinalStage userIdentifierKey(Optional<String> userIdentifierKey) {
            this.userIdentifierKey = userIdentifierKey;
            return this;
        }

        @Override
        public ClientSession build() {
            return new ClientSession(this.clientSessionId, this.userIdentifierKey, this.createdAt, this.token, this.deviceCount, this.connectedAccountIds, this.connectWebviewIds, this.workspaceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ClientSession build();

        public _FinalStage userIdentifierKey(Optional<String> var1);

        public _FinalStage userIdentifierKey(String var1);

        public _FinalStage connectedAccountIds(List<String> var1);

        public _FinalStage addConnectedAccountIds(String var1);

        public _FinalStage addAllConnectedAccountIds(List<String> var1);

        public _FinalStage connectWebviewIds(List<String> var1);

        public _FinalStage addConnectWebviewIds(String var1);

        public _FinalStage addAllConnectWebviewIds(List<String> var1);
    }

    public static interface WorkspaceIdStage {
        public _FinalStage workspaceId(String var1);
    }

    public static interface DeviceCountStage {
        public WorkspaceIdStage deviceCount(double var1);
    }

    public static interface TokenStage {
        public DeviceCountStage token(String var1);
    }

    public static interface CreatedAtStage {
        public TokenStage createdAt(OffsetDateTime var1);
    }

    public static interface ClientSessionIdStage {
        public CreatedAtStage clientSessionId(String var1);

        public Builder from(ClientSession var1);
    }
}

