/*
 * Decompiled with CFR 0.152.
 */
package io.github.sercasti.tracing.core;

import java.time.Duration;
import java.time.ZonedDateTime;

public class Metric {
    private final String name;
    private final String description;
    private final ZonedDateTime startTime;
    private Duration duration;

    public Metric(String name, String description) {
        this.name = name;
        this.description = description;
        this.startTime = ZonedDateTime.now();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public void stop() {
        if (this.duration != null) {
            throw new IllegalStateException("Metric '" + this.name + "' was already stopped!");
        }
        this.duration = Duration.between(this.startTime, ZonedDateTime.now());
    }
}

