/*
 * Decompiled with CFR 0.152.
 */
package io.github.sercasti.tracing.interceptor;

import io.github.sercasti.tracing.Traceable;
import io.github.sercasti.tracing.core.Metric;
import io.github.sercasti.tracing.core.Tracing;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class TracingInterceptor {
    private final Tracing tracing;

    @Autowired
    public TracingInterceptor(Tracing tracing) {
        this.tracing = tracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(io.github.sercasti.tracing.Traceable)")
    public Object trace(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Traceable traceable = signature.getMethod().getAnnotation(Traceable.class);
        String traceName = StringUtils.isEmpty((Object)traceable.name()) ? signature.getName() : traceable.name();
        String traceDescription = StringUtils.isEmpty((Object)traceable.description()) ? null : traceable.description();
        Metric metric = this.tracing.start(traceName, traceDescription);
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            metric.stop();
        }
    }
}

