/*
 * Decompiled with CFR 0.152.
 */
package com.obermuhlner.scriptengine.java;

import com.obermuhlner.scriptengine.java.Isolation;
import com.obermuhlner.scriptengine.java.JavaCompiledScript;
import com.obermuhlner.scriptengine.java.JavaScriptEngineFactory;
import com.obermuhlner.scriptengine.java.MemoryFileManager;
import com.obermuhlner.scriptengine.java.bindings.BindingStrategy;
import com.obermuhlner.scriptengine.java.compilation.CompilationStrategy;
import com.obermuhlner.scriptengine.java.compilation.DefaultCompilationStrategy;
import com.obermuhlner.scriptengine.java.compilation.NoInterceptorStrategy;
import com.obermuhlner.scriptengine.java.compilation.ScriptInterceptorStrategy;
import com.obermuhlner.scriptengine.java.constructor.ConstructorStrategy;
import com.obermuhlner.scriptengine.java.constructor.DefaultConstructorStrategy;
import com.obermuhlner.scriptengine.java.execution.DefaultExecutionStrategy;
import com.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import com.obermuhlner.scriptengine.java.execution.ExecutionStrategyFactory;
import com.obermuhlner.scriptengine.java.name.DefaultNameStrategy;
import com.obermuhlner.scriptengine.java.name.NameStrategy;
import com.obermuhlner.scriptengine.java.packagelisting.PackageResourceListingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavaScriptEngine
implements ScriptEngine,
Compilable {
    private NameStrategy nameStrategy = new DefaultNameStrategy();
    private ConstructorStrategy constructorStrategy = DefaultConstructorStrategy.byDefaultConstructor();
    private ExecutionStrategyFactory executionStrategyFactory = clazz -> new DefaultExecutionStrategy(clazz);
    private Isolation isolation = Isolation.CallerClassLoader;
    private List<String> compilationOptions = null;
    private PackageResourceListingStrategy packageResourceListingStrategy = null;
    private BindingStrategy bindingStrategy = null;
    private CompilationStrategy compilationStrategy = new DefaultCompilationStrategy();
    private ScriptInterceptorStrategy scriptInterceptorStrategy = new NoInterceptorStrategy();
    private ScriptContext context = new SimpleScriptContext();
    private ClassLoader executionClassLoader = this.getClass().getClassLoader();

    public void setNameStrategy(NameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    public void setConstructorStrategy(ConstructorStrategy constructorStrategy) {
        this.constructorStrategy = constructorStrategy;
    }

    public void setPackageResourceListingStrategy(PackageResourceListingStrategy packageResourceListingStrategy) {
        this.packageResourceListingStrategy = packageResourceListingStrategy;
    }

    public void setBindingStrategy(BindingStrategy bindingStrategy) {
        this.bindingStrategy = bindingStrategy;
    }

    public void setCompilationStrategy(CompilationStrategy compilationStrategy) {
        this.compilationStrategy = compilationStrategy;
    }

    public void setScriptInterceptorStrategy(ScriptInterceptorStrategy scriptInterceptorStrategy) {
        this.scriptInterceptorStrategy = scriptInterceptorStrategy;
    }

    public void setExecutionStrategyFactory(ExecutionStrategyFactory executionStrategyFactory) {
        this.executionStrategyFactory = executionStrategyFactory;
    }

    public void setExecutionClassLoader(ClassLoader executionClassLoader) {
        this.executionClassLoader = executionClassLoader;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setCompilationOptions(List<String> compilationOptions) {
        this.compilationOptions = compilationOptions;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(this.readScript(reader));
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readScript(reader), context);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(script, context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(this.readScript(reader), bindings);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        JavaCompiledScript compile = this.compile(script);
        return compile.eval(bindings);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readScript(reader));
    }

    @Override
    public JavaCompiledScript compile(String originalScript) throws ScriptException {
        String script = this.scriptInterceptorStrategy.intercept(originalScript);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        ClassLoader parentClassLoader = this.isolation == Isolation.CallerClassLoader ? this.executionClassLoader : null;
        MemoryFileManager memoryFileManager = new MemoryFileManager(standardFileManager, parentClassLoader);
        memoryFileManager.setPackageResourceListingStrategy(this.packageResourceListingStrategy);
        String fullClassName = this.nameStrategy.getFullName(script);
        String simpleClassName = NameStrategy.extractSimpleName(fullClassName);
        List<JavaFileObject> toCompile = this.compilationStrategy.getJavaFileObjectsToCompile(simpleClassName, script);
        JavaCompiler.CompilationTask task = compiler.getTask(null, memoryFileManager, diagnostics, this.compilationOptions, null, toCompile);
        if (!task.call().booleanValue()) {
            String message = diagnostics.getDiagnostics().stream().map(d -> d.toString()).collect(Collectors.joining("\n"));
            throw new ScriptException(message);
        }
        ClassLoader classLoader = memoryFileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        try {
            Class<?> clazz = classLoader.loadClass(fullClassName);
            this.compilationStrategy.compilationResult(clazz);
            Object instance = this.constructorStrategy.construct(clazz);
            ExecutionStrategy executionStrategy = this.executionStrategyFactory.create(clazz);
            return new JavaCompiledScript(this, clazz, instance, executionStrategy, this.bindingStrategy);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new JavaScriptEngineFactory();
    }

    private String readScript(Reader reader) throws ScriptException {
        try {
            String line;
            StringBuilder s = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                s.append(line);
                s.append("\n");
            }
            return s.toString();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }
}

