/*
 * Decompiled with CFR 0.152.
 */
package io.github.simplexdevelopment.cl;

import io.github.simplexdevelopment.cl.Permissible;
import io.github.simplexdevelopment.cl.api.ICommand;
import io.github.simplexdevelopment.cl.api.SubCommand;
import io.github.simplexdevelopment.msgutils.AdvancedColors;
import io.github.simplexdevelopment.msgutils.BasicColors;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandBase
extends Permissible
implements ICommand {
    public CommandBase(@NotNull String permission, String permissionMessage, boolean allowConsole) {
        super(permission, permissionMessage, allowConsole);
    }

    public CommandBase(@NotNull String permission, String permissionMessage) {
        this(permission, permissionMessage, true);
    }

    public CommandBase(@NotNull String permission, boolean allowConsole) {
        this(permission, "You do not have permission to use this command!", allowConsole);
    }

    public CommandBase(@NotNull String permission) {
        this(permission, "You do not have permission to use this command!", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String lbl, String[] args) {
        if (!this.hasPermission(sender)) {
            sender.sendMessage((Component)this.msg(this.getPermissionMessage(), BasicColors.RED));
            return true;
        }
        if (!(sender instanceof Player) && !this.allowConsole()) {
            sender.sendMessage((Component)this.msg("This command can only be run in game."));
        }
        this.execute(sender, args);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    @NotNull
    public TextComponent msg(@NotNull String text) {
        return Component.empty().content(text);
    }

    @NotNull
    public TextComponent msg(@NotNull String text, @NotNull BasicColors color) {
        return (TextComponent)Component.empty().content(text).color(color.getColor());
    }

    @NotNull
    public TextComponent msg(@NotNull String text, @NotNull AdvancedColors color) {
        return (TextComponent)Component.empty().content(text).color(color.getColor());
    }

    public boolean subCommand(@NotNull String name, @NotNull CommandSender sender, @NotNull String permission, String @NotNull [] args, @NotNull SubCommand command) {
        if (!sender.hasPermission(permission)) {
            sender.sendMessage((Component)this.msg(this.getPermissionMessage()));
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String[] tieredCmd = name.split(" ");
        if (args.length == 1 && tieredCmd.length == 1 && args[0].equalsIgnoreCase(name)) {
            command.execute();
            return true;
        }
        if (args.length == 2 && tieredCmd.length == 2 && args[0].equalsIgnoreCase(tieredCmd[0]) && args[1].equalsIgnoreCase(tieredCmd[1])) {
            command.execute();
            return true;
        }
        if (args.length == 3 && tieredCmd.length == 3 && args[0].equalsIgnoreCase(tieredCmd[0]) && args[1].equalsIgnoreCase(tieredCmd[1]) && args[2].equalsIgnoreCase(tieredCmd[2])) {
            command.execute();
            return true;
        }
        if (args.length == 4 && tieredCmd.length == 4 && args[0].equalsIgnoreCase(tieredCmd[0]) && args[1].equalsIgnoreCase(tieredCmd[1]) && args[2].equalsIgnoreCase(tieredCmd[2]) && args[3].equalsIgnoreCase(tieredCmd[3])) {
            command.execute();
            return true;
        }
        return false;
    }

    @Nullable
    public Player getPlayer(@NotNull String name) {
        return Bukkit.getServer().getPlayer(name);
    }

    @Nullable
    public Player getPlayer(@NotNull UUID uuid) {
        return Bukkit.getServer().getPlayer(uuid);
    }

    public List<? extends Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().toList();
    }

    public void broadcast(String text) {
        Bukkit.getServer().broadcast((Component)this.msg(text));
    }

    public void broadcast(String text, BasicColors color) {
        Bukkit.getServer().broadcast((Component)this.msg(text, color));
    }

    public void broadcast(String text, AdvancedColors color) {
        Bukkit.getServer().broadcast((Component)this.msg(text, color));
    }

    public void enablePlugin(Plugin plugin) {
        Bukkit.getServer().getPluginManager().enablePlugin(plugin);
    }

    public void disablePlugin(Plugin plugin) {
        Bukkit.getServer().getPluginManager().disablePlugin(plugin);
    }
}

