/*
 * Decompiled with CFR 0.152.
 */
package io.github.simplexdevelopment.cl;

import io.github.simplexdevelopment.cl.CommandBase;
import io.github.simplexdevelopment.cl.DummyCommand;
import io.github.simplexdevelopment.cl.api.annotations.Info;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;

public class CommandLoader {
    private final Plugin plugin;
    private final List<DummyCommand> commandList = new ArrayList<DummyCommand>();
    private final String FALLBACK_PREFIX;

    public CommandLoader(Plugin plugin, String fallbackPrefix) {
        this.FALLBACK_PREFIX = fallbackPrefix;
        this.plugin = plugin;
    }

    public void register(CommandBase command) {
        Class<?> cmd = command.getClass();
        if (cmd.getDeclaredAnnotation(Info.class) == null) {
            throw new RuntimeException("Missing a required annotation! Unable to load the command.");
        }
        Info info = cmd.getDeclaredAnnotation(Info.class);
        DummyCommand dummy = new DummyCommand(this.plugin, command, info.name(), info.description(), info.usage(), Arrays.asList(info.aliases().split(",")));
        this.commandList.add(dummy);
    }

    public void register(CommandBase ... commands) {
        Arrays.stream(commands).forEachOrdered(this::register);
    }

    public void load() {
        this.commandList.forEach(cmd -> Bukkit.getCommandMap().register(cmd.getName(), this.FALLBACK_PREFIX, (Command)cmd));
    }

    public void registerAndLoad(CommandBase ... commands) {
        this.register(commands);
        this.load();
    }
}

