/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid_kiss.peppyrus_api.client;

import io.github.solid_kiss.peppyrus_api.client.PeppyrusClientConfig;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusEnv;
import io.github.solid_kiss.peppyrus_api.client.services.PeppyrusMessageClient;
import io.github.solid_kiss.peppyrus_api.client.services.PeppyrusOrganizationClient;
import io.github.solid_kiss.peppyrus_api.client.services.PeppyrusPeppolClient;

public class PeppyrusClient {
    private final PeppyrusMessageClient messageClient;
    private final PeppyrusOrganizationClient organizationClient;
    private final PeppyrusPeppolClient peppolClient;

    private PeppyrusClient(PeppyrusClientConfig config) {
        this.messageClient = new PeppyrusMessageClient(config);
        this.organizationClient = new PeppyrusOrganizationClient(config);
        this.peppolClient = new PeppyrusPeppolClient(config);
    }

    private static PeppyrusClient create(PeppyrusClientConfig config) {
        return new PeppyrusClient(config);
    }

    public static PeppyrusClient create(String apiKey, PeppyrusEnv env) {
        PeppyrusClientConfig config = PeppyrusClientConfig.builder().apiKey(apiKey).withEnv(env).build();
        return new PeppyrusClient(config);
    }

    public PeppyrusMessageClient messages() {
        return this.messageClient;
    }

    public PeppyrusOrganizationClient organization() {
        return this.organizationClient;
    }

    public PeppyrusPeppolClient peppol() {
        return this.peppolClient;
    }
}

