/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid_kiss.peppyrus_api.client;

import io.github.solid_kiss.peppyrus_api.client.PeppyrusEnv;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;

public class PeppyrusClientConfig {
    private final String apiKey;
    private final URI baseUri;
    private final HttpClient httpClient;
    public static final URI TEST_URI = URI.create("https://api.test.peppyrus.be/v1");
    public static final URI PROD_URI = URI.create("https://api.peppyrus.be/v1");

    private PeppyrusClientConfig(Builder builder) {
        this.apiKey = builder.apiKey;
        this.baseUri = builder.baseUri;
        this.httpClient = builder.httpClient != null ? builder.httpClient : this.createDefaultHttpClient();
    }

    private HttpClient createDefaultHttpClient() {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(30L)).build();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private URI baseUri;
        private HttpClient httpClient;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder baseUri(String baseUri) {
            this.baseUri = URI.create(baseUri);
            return this;
        }

        public Builder baseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withEnv(PeppyrusEnv peppyrusEnv) {
            this.baseUri = peppyrusEnv.equals((Object)PeppyrusEnv.TEST) ? TEST_URI : PROD_URI;
            return this;
        }

        public PeppyrusClientConfig build() {
            if (this.apiKey == null || this.apiKey.isBlank()) {
                throw new IllegalStateException("API key is required");
            }
            if (this.baseUri == null) {
                throw new IllegalStateException("Base URI is required");
            }
            return new PeppyrusClientConfig(this);
        }
    }
}

