/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid_kiss.peppyrus_api.client.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusApiException;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusBaseClient;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusClientConfig;
import io.github.solid_kiss.peppyrus_api.model.BusinessCard;
import io.github.solid_kiss.peppyrus_api.model.Participant;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PeppyrusPeppolClient
extends PeppyrusBaseClient {
    public PeppyrusPeppolClient(PeppyrusClientConfig config) {
        super(config);
    }

    public Participant getBestMatch(String vatNumber, String countryCode) throws PeppyrusApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vatNumber", vatNumber);
        params.put("countryCode", countryCode);
        String path = "/peppol/bestMatch" + this.buildQueryString(params);
        return this.sendGet(path, Participant.class);
    }

    public Participant lookup(String participantId) throws PeppyrusApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("participantId", participantId);
        String path = "/peppol/lookup" + this.buildQueryString(params);
        return this.sendGet(path, Participant.class);
    }

    public List<BusinessCard> search(PeppolSearchParams params) throws PeppyrusApiException {
        String path = "/peppol/search" + this.buildQueryString(params.toMap());
        try {
            String response = this.sendGetRaw(path);
            return (List)this.objectMapper.readValue(response, (TypeReference)new TypeReference<List<BusinessCard>>(){});
        }
        catch (IOException e) {
            throw new PeppyrusApiException("Failed to parse search results", e);
        }
    }

    public List<BusinessCard> search(String query) throws PeppyrusApiException {
        return this.search(new PeppolSearchParams().query(query));
    }

    private String sendGetRaw(String path) throws PeppyrusApiException {
        HttpRequest request = this.createRequestBuilder(path).GET().build();
        try {
            HttpResponse<String> response = this.config.getHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                return response.body();
            }
            throw new PeppyrusApiException("API error: " + response.body(), response.statusCode());
        }
        catch (IOException e) {
            throw new PeppyrusApiException("Network error during API call", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PeppyrusApiException("Request was interrupted", e);
        }
    }

    private String buildQueryString(Map<String, String> params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("?");
        params.forEach((key, value) -> {
            if (value != null && !value.isBlank()) {
                if (sb.length() > 1) {
                    sb.append("&");
                }
                sb.append((String)key).append("=").append(this.encode((String)value));
            }
        });
        return sb.length() > 1 ? sb.toString() : "";
    }

    private String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static class PeppolSearchParams {
        private String query;
        private String participantId;
        private String name;
        private String country;
        private String geoInfo;
        private String contact;
        private String identifierScheme;
        private String identifierValue;

        public PeppolSearchParams query(String query) {
            this.query = query;
            return this;
        }

        public PeppolSearchParams participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public PeppolSearchParams name(String name) {
            this.name = name;
            return this;
        }

        public PeppolSearchParams country(String country) {
            this.country = country;
            return this;
        }

        public PeppolSearchParams geoInfo(String geoInfo) {
            this.geoInfo = geoInfo;
            return this;
        }

        public PeppolSearchParams contact(String contact) {
            this.contact = contact;
            return this;
        }

        public PeppolSearchParams identifierScheme(String identifierScheme) {
            this.identifierScheme = identifierScheme;
            return this;
        }

        public PeppolSearchParams identifierValue(String identifierValue) {
            this.identifierValue = identifierValue;
            return this;
        }

        Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.query != null) {
                map.put("query", this.query);
            }
            if (this.participantId != null) {
                map.put("participantId", this.participantId);
            }
            if (this.name != null) {
                map.put("name", this.name);
            }
            if (this.country != null) {
                map.put("country", this.country);
            }
            if (this.geoInfo != null) {
                map.put("geoInfo", this.geoInfo);
            }
            if (this.contact != null) {
                map.put("contact", this.contact);
            }
            if (this.identifierScheme != null) {
                map.put("identifierScheme", this.identifierScheme);
            }
            if (this.identifierValue != null) {
                map.put("identifierValue", this.identifierValue);
            }
            return map;
        }
    }
}

