/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid_kiss.peppyrus_api.client.services;

import io.github.solid_kiss.peppyrus_api.client.PeppyrusApiException;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusBaseClient;
import io.github.solid_kiss.peppyrus_api.client.PeppyrusClientConfig;
import io.github.solid_kiss.peppyrus_api.model.Message;
import io.github.solid_kiss.peppyrus_api.model.MessageBody;
import io.github.solid_kiss.peppyrus_api.model.MessageList;
import io.github.solid_kiss.peppyrus_api.model.MessageReport;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class PeppyrusMessageClient
extends PeppyrusBaseClient {
    public PeppyrusMessageClient(PeppyrusClientConfig config) {
        super(config);
    }

    public Message postMessage(MessageBody messageBody) throws PeppyrusApiException {
        return this.sendPost("message", messageBody, Message.class);
    }

    public MessageList listMessages(MessageListParams params) throws PeppyrusApiException {
        String path = "message/list" + this.buildQueryString(params);
        return this.sendGet(path, MessageList.class);
    }

    public MessageList listMessages() throws PeppyrusApiException {
        return this.listMessages(new MessageListParams());
    }

    public Message getMessage(String messageId) throws PeppyrusApiException {
        return this.sendGet("message/" + messageId, Message.class);
    }

    public void deleteMessage(String messageId) throws PeppyrusApiException {
        this.sendDelete("message/" + messageId);
    }

    public Boolean confirmMessage(String messageId) throws PeppyrusApiException {
        return this.sendPatch("message/" + messageId + "/confirm", Boolean.class);
    }

    public MessageReport getMessageReport(String messageId) throws PeppyrusApiException {
        return this.sendGet("message/" + messageId + "/report", MessageReport.class);
    }

    private String buildQueryString(MessageListParams params) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (params.getFolder() != null) {
            queryParams.put("folder", params.getFolder());
        }
        if (params.getSender() != null) {
            queryParams.put("sender", params.getSender());
        }
        if (params.getReceiver() != null) {
            queryParams.put("receiver", params.getReceiver());
        }
        if (params.getConfirmed() != null) {
            queryParams.put("confirmed", params.getConfirmed().toString());
        }
        if (params.getPage() != null) {
            queryParams.put("page", params.getPage().toString());
        }
        if (params.getPerPage() != null) {
            queryParams.put("perPage", params.getPerPage().toString());
        }
        if (queryParams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("?");
        queryParams.forEach((key, value) -> {
            if (sb.length() > 1) {
                sb.append("&");
            }
            sb.append((String)key).append("=").append(this.encode((String)value));
        });
        return sb.toString();
    }

    private String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static class MessageListParams {
        private String folder;
        private String sender;
        private String receiver;
        private Boolean confirmed;
        private Integer page;
        private Integer perPage;

        public MessageListParams folder(String folder) {
            this.folder = folder;
            return this;
        }

        public MessageListParams sender(String sender) {
            this.sender = sender;
            return this;
        }

        public MessageListParams receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        public MessageListParams confirmed(Boolean confirmed) {
            this.confirmed = confirmed;
            return this;
        }

        public MessageListParams page(Integer page) {
            this.page = page;
            return this;
        }

        public MessageListParams perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSender() {
            return this.sender;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public Boolean getConfirmed() {
            return this.confirmed;
        }

        public Integer getPage() {
            return this.page;
        }

        public Integer getPerPage() {
            return this.perPage;
        }
    }
}

