package io.github.solid.resourcepack.material

import kotlin.Lazy
import net.kyori.adventure.key.Key

public enum class SolidBlockMaterialParent(
  public val key: Lazy<Key>,
) {
  BUTTON(lazy { Key.key("minecraft:block/button") }),
  TEMPLATE_FENCE_GATE(lazy { Key.key("minecraft:block/template_fence_gate") }),
  LEAVES(lazy { Key.key("minecraft:block/leaves") }),
  CUBE_COLUMN(lazy { Key.key("minecraft:block/cube_column") }),
  CUBE_ALL(lazy { Key.key("minecraft:block/cube_all") }),
  PRESSURE_PLATE_UP(lazy { Key.key("minecraft:block/pressure_plate_up") }),
  CROSS(lazy { Key.key("minecraft:block/cross") }),
  SLAB(lazy { Key.key("minecraft:block/slab") }),
  STAIRS(lazy { Key.key("minecraft:block/stairs") }),
  RAIL_FLAT(lazy { Key.key("minecraft:block/rail_flat") }),
  TEMPLATE_ANVIL(lazy { Key.key("minecraft:block/template_anvil") }),
  STEM_FRUIT(lazy { Key.key("minecraft:block/stem_fruit") }),
  TEMPLATE_AZALEA(lazy { Key.key("minecraft:block/template_azalea") }),
  TEMPLATE_CUSTOM_FENCE_GATE(lazy { Key.key("minecraft:block/template_custom_fence_gate") }),
  TINTED_CROSS(lazy { Key.key("minecraft:block/tinted_cross") }),
  CUBE_BOTTOM_TOP(lazy { Key.key("minecraft:block/cube_bottom_top") }),
  BLOCK(lazy { Key.key("minecraft:block/block") }),
  ORIENTABLE_WITH_BOTTOM(lazy { Key.key("minecraft:block/orientable_with_bottom") }),
  TEMPLATE_CAKE_WITH_CANDLE(lazy { Key.key("minecraft:block/template_cake_with_candle") }),
  CARPET(lazy { Key.key("minecraft:block/carpet") }),
  TEMPLATE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/template_glazed_terracotta") }),
  ORIENTABLE(lazy { Key.key("minecraft:block/orientable") }),
  CORAL_FAN(lazy { Key.key("minecraft:block/coral_fan") }),
  CORAL_WALL_FAN(lazy { Key.key("minecraft:block/coral_wall_fan") }),
  TEMPLATE_SINGLE_FACE(lazy { Key.key("minecraft:block/template_single_face") }),
  TEMPLATE_CAMPFIRE(lazy { Key.key("minecraft:block/template_campfire") }),
  CUBE(lazy { Key.key("minecraft:block/cube") }),
  TEMPLATE_COMMAND_BLOCK(lazy { Key.key("minecraft:block/template_command_block") }),
  TEMPLATE_CHORUS_FLOWER(lazy { Key.key("minecraft:block/template_chorus_flower") }),
  TEMPLATE_DAYLIGHT_DETECTOR(lazy { Key.key("minecraft:block/template_daylight_detector") }),
  TEMPLATE_FARMLAND(lazy { Key.key("minecraft:block/template_farmland") }),
  TEMPLATE_ITEM_FRAME(lazy { Key.key("minecraft:block/template_item_frame") }),
  CUBE_DIRECTIONAL(lazy { Key.key("minecraft:block/cube_directional") }),
  CUBE_TOP(lazy { Key.key("minecraft:block/cube_top") }),
  TEMPLATE_LANTERN(lazy { Key.key("minecraft:block/template_lantern") }),
  TEMPLATE_CAULDRON_FULL(lazy { Key.key("minecraft:block/template_cauldron_full") }),
  TEMPLATE_PISTON(lazy { Key.key("minecraft:block/template_piston") }),
  TEMPLATE_PISTON_HEAD(lazy { Key.key("minecraft:block/template_piston_head") }),
  FLOWER_POT_CROSS(lazy { Key.key("minecraft:block/flower_pot_cross") }),
  TEMPLATE_POTTED_AZALEA_BUSH(lazy { Key.key("minecraft:block/template_potted_azalea_bush") }),
  TINTED_FLOWER_POT_CROSS(lazy { Key.key("minecraft:block/tinted_flower_pot_cross") }),
  TEMPLATE_TORCH(lazy { Key.key("minecraft:block/template_torch") }),
  TEMPLATE_TORCH_WALL(lazy { Key.key("minecraft:block/template_torch_wall") }),
  TEMPLATE_SCULK_SHRIEKER(lazy { Key.key("minecraft:block/template_sculk_shrieker") }),
  TEMPLATE_SEAGRASS(lazy { Key.key("minecraft:block/template_seagrass") }),
  CUBE_ALL_INNER_FACES(lazy { Key.key("minecraft:block/cube_all_inner_faces") }),
  CUBE_BOTTOM_TOP_INNER_FACES(lazy { Key.key("minecraft:block/cube_bottom_top_inner_faces") }),
  TEMPLATE_TURTLE_EGG(lazy { Key.key("minecraft:block/template_turtle_egg") }),
  TEMPLATE_VAULT(lazy { Key.key("minecraft:block/template_vault") }),
  ACACIA_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/acacia_button_inventory") }),
  ACACIA_FENCE_INVENTORY(lazy { Key.key("minecraft:block/acacia_fence_inventory") }),
  ACACIA_FENCE_GATE(lazy { Key.key("minecraft:block/acacia_fence_gate") }),
  ACACIA_LEAVES(lazy { Key.key("minecraft:block/acacia_leaves") }),
  ACACIA_LOG(lazy { Key.key("minecraft:block/acacia_log") }),
  ACACIA_PLANKS(lazy { Key.key("minecraft:block/acacia_planks") }),
  ACACIA_PRESSURE_PLATE(lazy { Key.key("minecraft:block/acacia_pressure_plate") }),
  ACACIA_SLAB(lazy { Key.key("minecraft:block/acacia_slab") }),
  ACACIA_STAIRS(lazy { Key.key("minecraft:block/acacia_stairs") }),
  ACACIA_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/acacia_trapdoor_bottom") }),
  ACACIA_WOOD(lazy { Key.key("minecraft:block/acacia_wood") }),
  AMETHYST_BLOCK(lazy { Key.key("minecraft:block/amethyst_block") }),
  ANCIENT_DEBRIS(lazy { Key.key("minecraft:block/ancient_debris") }),
  ANDESITE(lazy { Key.key("minecraft:block/andesite") }),
  ANDESITE_SLAB(lazy { Key.key("minecraft:block/andesite_slab") }),
  ANDESITE_STAIRS(lazy { Key.key("minecraft:block/andesite_stairs") }),
  ANDESITE_WALL_INVENTORY(lazy { Key.key("minecraft:block/andesite_wall_inventory") }),
  ANVIL(lazy { Key.key("minecraft:block/anvil") }),
  AZALEA(lazy { Key.key("minecraft:block/azalea") }),
  AZALEA_LEAVES(lazy { Key.key("minecraft:block/azalea_leaves") }),
  BAMBOO_BLOCK(lazy { Key.key("minecraft:block/bamboo_block") }),
  BAMBOO_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/bamboo_button_inventory") }),
  BAMBOO_FENCE_INVENTORY(lazy { Key.key("minecraft:block/bamboo_fence_inventory") }),
  BAMBOO_FENCE_GATE(lazy { Key.key("minecraft:block/bamboo_fence_gate") }),
  BAMBOO_MOSAIC(lazy { Key.key("minecraft:block/bamboo_mosaic") }),
  BAMBOO_MOSAIC_SLAB(lazy { Key.key("minecraft:block/bamboo_mosaic_slab") }),
  BAMBOO_MOSAIC_STAIRS(lazy { Key.key("minecraft:block/bamboo_mosaic_stairs") }),
  BAMBOO_PLANKS(lazy { Key.key("minecraft:block/bamboo_planks") }),
  BAMBOO_PRESSURE_PLATE(lazy { Key.key("minecraft:block/bamboo_pressure_plate") }),
  BAMBOO_SLAB(lazy { Key.key("minecraft:block/bamboo_slab") }),
  BAMBOO_STAIRS(lazy { Key.key("minecraft:block/bamboo_stairs") }),
  BAMBOO_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/bamboo_trapdoor_bottom") }),
  BARREL(lazy { Key.key("minecraft:block/barrel") }),
  BASALT(lazy { Key.key("minecraft:block/basalt") }),
  BEACON(lazy { Key.key("minecraft:block/beacon") }),
  BEDROCK(lazy { Key.key("minecraft:block/bedrock") }),
  BEEHIVE(lazy { Key.key("minecraft:block/beehive") }),
  BEE_NEST(lazy { Key.key("minecraft:block/bee_nest") }),
  BIG_DRIPLEAF(lazy { Key.key("minecraft:block/big_dripleaf") }),
  BIRCH_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/birch_button_inventory") }),
  BIRCH_FENCE_INVENTORY(lazy { Key.key("minecraft:block/birch_fence_inventory") }),
  BIRCH_FENCE_GATE(lazy { Key.key("minecraft:block/birch_fence_gate") }),
  BIRCH_LEAVES(lazy { Key.key("minecraft:block/birch_leaves") }),
  BIRCH_LOG(lazy { Key.key("minecraft:block/birch_log") }),
  BIRCH_PLANKS(lazy { Key.key("minecraft:block/birch_planks") }),
  BIRCH_PRESSURE_PLATE(lazy { Key.key("minecraft:block/birch_pressure_plate") }),
  BIRCH_SLAB(lazy { Key.key("minecraft:block/birch_slab") }),
  BIRCH_STAIRS(lazy { Key.key("minecraft:block/birch_stairs") }),
  BIRCH_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/birch_trapdoor_bottom") }),
  BIRCH_WOOD(lazy { Key.key("minecraft:block/birch_wood") }),
  BLACKSTONE(lazy { Key.key("minecraft:block/blackstone") }),
  BLACKSTONE_SLAB(lazy { Key.key("minecraft:block/blackstone_slab") }),
  BLACKSTONE_STAIRS(lazy { Key.key("minecraft:block/blackstone_stairs") }),
  BLACKSTONE_WALL_INVENTORY(lazy { Key.key("minecraft:block/blackstone_wall_inventory") }),
  BLACK_CARPET(lazy { Key.key("minecraft:block/black_carpet") }),
  BLACK_CONCRETE(lazy { Key.key("minecraft:block/black_concrete") }),
  BLACK_CONCRETE_POWDER(lazy { Key.key("minecraft:block/black_concrete_powder") }),
  BLACK_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/black_glazed_terracotta") }),
  BLACK_STAINED_GLASS(lazy { Key.key("minecraft:block/black_stained_glass") }),
  BLACK_TERRACOTTA(lazy { Key.key("minecraft:block/black_terracotta") }),
  BLACK_WOOL(lazy { Key.key("minecraft:block/black_wool") }),
  BLAST_FURNACE(lazy { Key.key("minecraft:block/blast_furnace") }),
  BLUE_CARPET(lazy { Key.key("minecraft:block/blue_carpet") }),
  BLUE_CONCRETE(lazy { Key.key("minecraft:block/blue_concrete") }),
  BLUE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/blue_concrete_powder") }),
  BLUE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/blue_glazed_terracotta") }),
  BLUE_ICE(lazy { Key.key("minecraft:block/blue_ice") }),
  BLUE_STAINED_GLASS(lazy { Key.key("minecraft:block/blue_stained_glass") }),
  BLUE_TERRACOTTA(lazy { Key.key("minecraft:block/blue_terracotta") }),
  BLUE_WOOL(lazy { Key.key("minecraft:block/blue_wool") }),
  BONE_BLOCK(lazy { Key.key("minecraft:block/bone_block") }),
  BOOKSHELF(lazy { Key.key("minecraft:block/bookshelf") }),
  BRAIN_CORAL_BLOCK(lazy { Key.key("minecraft:block/brain_coral_block") }),
  BRICKS(lazy { Key.key("minecraft:block/bricks") }),
  BRICK_SLAB(lazy { Key.key("minecraft:block/brick_slab") }),
  BRICK_STAIRS(lazy { Key.key("minecraft:block/brick_stairs") }),
  BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/brick_wall_inventory") }),
  BROWN_CARPET(lazy { Key.key("minecraft:block/brown_carpet") }),
  BROWN_CONCRETE(lazy { Key.key("minecraft:block/brown_concrete") }),
  BROWN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/brown_concrete_powder") }),
  BROWN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/brown_glazed_terracotta") }),
  BROWN_MUSHROOM_BLOCK_INVENTORY(lazy { Key.key("minecraft:block/brown_mushroom_block_inventory")
      }),
  BROWN_STAINED_GLASS(lazy { Key.key("minecraft:block/brown_stained_glass") }),
  BROWN_TERRACOTTA(lazy { Key.key("minecraft:block/brown_terracotta") }),
  BROWN_WOOL(lazy { Key.key("minecraft:block/brown_wool") }),
  BUBBLE_CORAL_BLOCK(lazy { Key.key("minecraft:block/bubble_coral_block") }),
  BUDDING_AMETHYST(lazy { Key.key("minecraft:block/budding_amethyst") }),
  CACTUS(lazy { Key.key("minecraft:block/cactus") }),
  CALCITE(lazy { Key.key("minecraft:block/calcite") }),
  CALIBRATED_SCULK_SENSOR_INACTIVE(lazy {
      Key.key("minecraft:block/calibrated_sculk_sensor_inactive") }),
  CARTOGRAPHY_TABLE(lazy { Key.key("minecraft:block/cartography_table") }),
  CARVED_PUMPKIN(lazy { Key.key("minecraft:block/carved_pumpkin") }),
  CHAIN_COMMAND_BLOCK(lazy { Key.key("minecraft:block/chain_command_block") }),
  CHERRY_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/cherry_button_inventory") }),
  CHERRY_FENCE_INVENTORY(lazy { Key.key("minecraft:block/cherry_fence_inventory") }),
  CHERRY_FENCE_GATE(lazy { Key.key("minecraft:block/cherry_fence_gate") }),
  CHERRY_LEAVES(lazy { Key.key("minecraft:block/cherry_leaves") }),
  CHERRY_LOG(lazy { Key.key("minecraft:block/cherry_log") }),
  CHERRY_PLANKS(lazy { Key.key("minecraft:block/cherry_planks") }),
  CHERRY_PRESSURE_PLATE(lazy { Key.key("minecraft:block/cherry_pressure_plate") }),
  CHERRY_SLAB(lazy { Key.key("minecraft:block/cherry_slab") }),
  CHERRY_STAIRS(lazy { Key.key("minecraft:block/cherry_stairs") }),
  CHERRY_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/cherry_trapdoor_bottom") }),
  CHERRY_WOOD(lazy { Key.key("minecraft:block/cherry_wood") }),
  CHIPPED_ANVIL(lazy { Key.key("minecraft:block/chipped_anvil") }),
  CHISELED_BOOKSHELF_INVENTORY(lazy { Key.key("minecraft:block/chiseled_bookshelf_inventory") }),
  CHISELED_COPPER(lazy { Key.key("minecraft:block/chiseled_copper") }),
  CHISELED_DEEPSLATE(lazy { Key.key("minecraft:block/chiseled_deepslate") }),
  CHISELED_NETHER_BRICKS(lazy { Key.key("minecraft:block/chiseled_nether_bricks") }),
  CHISELED_POLISHED_BLACKSTONE(lazy { Key.key("minecraft:block/chiseled_polished_blackstone") }),
  CHISELED_QUARTZ_BLOCK(lazy { Key.key("minecraft:block/chiseled_quartz_block") }),
  CHISELED_RED_SANDSTONE(lazy { Key.key("minecraft:block/chiseled_red_sandstone") }),
  CHISELED_SANDSTONE(lazy { Key.key("minecraft:block/chiseled_sandstone") }),
  CHISELED_STONE_BRICKS(lazy { Key.key("minecraft:block/chiseled_stone_bricks") }),
  CHISELED_TUFF(lazy { Key.key("minecraft:block/chiseled_tuff") }),
  CHISELED_TUFF_BRICKS(lazy { Key.key("minecraft:block/chiseled_tuff_bricks") }),
  CHORUS_FLOWER(lazy { Key.key("minecraft:block/chorus_flower") }),
  CHORUS_PLANT(lazy { Key.key("minecraft:block/chorus_plant") }),
  CLAY(lazy { Key.key("minecraft:block/clay") }),
  COAL_BLOCK(lazy { Key.key("minecraft:block/coal_block") }),
  COAL_ORE(lazy { Key.key("minecraft:block/coal_ore") }),
  COARSE_DIRT(lazy { Key.key("minecraft:block/coarse_dirt") }),
  COBBLED_DEEPSLATE(lazy { Key.key("minecraft:block/cobbled_deepslate") }),
  COBBLED_DEEPSLATE_SLAB(lazy { Key.key("minecraft:block/cobbled_deepslate_slab") }),
  COBBLED_DEEPSLATE_STAIRS(lazy { Key.key("minecraft:block/cobbled_deepslate_stairs") }),
  COBBLED_DEEPSLATE_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/cobbled_deepslate_wall_inventory") }),
  COBBLESTONE(lazy { Key.key("minecraft:block/cobblestone") }),
  COBBLESTONE_SLAB(lazy { Key.key("minecraft:block/cobblestone_slab") }),
  COBBLESTONE_STAIRS(lazy { Key.key("minecraft:block/cobblestone_stairs") }),
  COBBLESTONE_WALL_INVENTORY(lazy { Key.key("minecraft:block/cobblestone_wall_inventory") }),
  COMMAND_BLOCK(lazy { Key.key("minecraft:block/command_block") }),
  COMPOSTER(lazy { Key.key("minecraft:block/composter") }),
  COPPER_BLOCK(lazy { Key.key("minecraft:block/copper_block") }),
  COPPER_BULB(lazy { Key.key("minecraft:block/copper_bulb") }),
  COPPER_GRATE(lazy { Key.key("minecraft:block/copper_grate") }),
  COPPER_ORE(lazy { Key.key("minecraft:block/copper_ore") }),
  COPPER_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/copper_trapdoor_bottom") }),
  CRACKED_DEEPSLATE_BRICKS(lazy { Key.key("minecraft:block/cracked_deepslate_bricks") }),
  CRACKED_DEEPSLATE_TILES(lazy { Key.key("minecraft:block/cracked_deepslate_tiles") }),
  CRACKED_NETHER_BRICKS(lazy { Key.key("minecraft:block/cracked_nether_bricks") }),
  CRACKED_POLISHED_BLACKSTONE_BRICKS(lazy {
      Key.key("minecraft:block/cracked_polished_blackstone_bricks") }),
  CRACKED_STONE_BRICKS(lazy { Key.key("minecraft:block/cracked_stone_bricks") }),
  CRAFTER(lazy { Key.key("minecraft:block/crafter") }),
  CRAFTING_TABLE(lazy { Key.key("minecraft:block/crafting_table") }),
  CRIMSON_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/crimson_button_inventory") }),
  CRIMSON_FENCE_INVENTORY(lazy { Key.key("minecraft:block/crimson_fence_inventory") }),
  CRIMSON_FENCE_GATE(lazy { Key.key("minecraft:block/crimson_fence_gate") }),
  CRIMSON_HYPHAE(lazy { Key.key("minecraft:block/crimson_hyphae") }),
  CRIMSON_NYLIUM(lazy { Key.key("minecraft:block/crimson_nylium") }),
  CRIMSON_PLANKS(lazy { Key.key("minecraft:block/crimson_planks") }),
  CRIMSON_PRESSURE_PLATE(lazy { Key.key("minecraft:block/crimson_pressure_plate") }),
  CRIMSON_SLAB(lazy { Key.key("minecraft:block/crimson_slab") }),
  CRIMSON_STAIRS(lazy { Key.key("minecraft:block/crimson_stairs") }),
  CRIMSON_STEM(lazy { Key.key("minecraft:block/crimson_stem") }),
  CRIMSON_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/crimson_trapdoor_bottom") }),
  CRYING_OBSIDIAN(lazy { Key.key("minecraft:block/crying_obsidian") }),
  CUT_COPPER(lazy { Key.key("minecraft:block/cut_copper") }),
  CUT_COPPER_SLAB(lazy { Key.key("minecraft:block/cut_copper_slab") }),
  CUT_COPPER_STAIRS(lazy { Key.key("minecraft:block/cut_copper_stairs") }),
  CUT_RED_SANDSTONE(lazy { Key.key("minecraft:block/cut_red_sandstone") }),
  CUT_RED_SANDSTONE_SLAB(lazy { Key.key("minecraft:block/cut_red_sandstone_slab") }),
  CUT_SANDSTONE(lazy { Key.key("minecraft:block/cut_sandstone") }),
  CUT_SANDSTONE_SLAB(lazy { Key.key("minecraft:block/cut_sandstone_slab") }),
  CYAN_CARPET(lazy { Key.key("minecraft:block/cyan_carpet") }),
  CYAN_CONCRETE(lazy { Key.key("minecraft:block/cyan_concrete") }),
  CYAN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/cyan_concrete_powder") }),
  CYAN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/cyan_glazed_terracotta") }),
  CYAN_STAINED_GLASS(lazy { Key.key("minecraft:block/cyan_stained_glass") }),
  CYAN_TERRACOTTA(lazy { Key.key("minecraft:block/cyan_terracotta") }),
  CYAN_WOOL(lazy { Key.key("minecraft:block/cyan_wool") }),
  DAMAGED_ANVIL(lazy { Key.key("minecraft:block/damaged_anvil") }),
  DARK_OAK_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/dark_oak_button_inventory") }),
  DARK_OAK_FENCE_INVENTORY(lazy { Key.key("minecraft:block/dark_oak_fence_inventory") }),
  DARK_OAK_FENCE_GATE(lazy { Key.key("minecraft:block/dark_oak_fence_gate") }),
  DARK_OAK_LEAVES(lazy { Key.key("minecraft:block/dark_oak_leaves") }),
  DARK_OAK_LOG(lazy { Key.key("minecraft:block/dark_oak_log") }),
  DARK_OAK_PLANKS(lazy { Key.key("minecraft:block/dark_oak_planks") }),
  DARK_OAK_PRESSURE_PLATE(lazy { Key.key("minecraft:block/dark_oak_pressure_plate") }),
  DARK_OAK_SLAB(lazy { Key.key("minecraft:block/dark_oak_slab") }),
  DARK_OAK_STAIRS(lazy { Key.key("minecraft:block/dark_oak_stairs") }),
  DARK_OAK_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/dark_oak_trapdoor_bottom") }),
  DARK_OAK_WOOD(lazy { Key.key("minecraft:block/dark_oak_wood") }),
  DARK_PRISMARINE(lazy { Key.key("minecraft:block/dark_prismarine") }),
  DARK_PRISMARINE_SLAB(lazy { Key.key("minecraft:block/dark_prismarine_slab") }),
  DARK_PRISMARINE_STAIRS(lazy { Key.key("minecraft:block/dark_prismarine_stairs") }),
  DAYLIGHT_DETECTOR(lazy { Key.key("minecraft:block/daylight_detector") }),
  DEAD_BRAIN_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_brain_coral_block") }),
  DEAD_BUBBLE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_bubble_coral_block") }),
  DEAD_FIRE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_fire_coral_block") }),
  DEAD_HORN_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_horn_coral_block") }),
  DEAD_TUBE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_tube_coral_block") }),
  DEEPSLATE(lazy { Key.key("minecraft:block/deepslate") }),
  DEEPSLATE_BRICKS(lazy { Key.key("minecraft:block/deepslate_bricks") }),
  DEEPSLATE_BRICK_SLAB(lazy { Key.key("minecraft:block/deepslate_brick_slab") }),
  DEEPSLATE_BRICK_STAIRS(lazy { Key.key("minecraft:block/deepslate_brick_stairs") }),
  DEEPSLATE_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/deepslate_brick_wall_inventory")
      }),
  DEEPSLATE_COAL_ORE(lazy { Key.key("minecraft:block/deepslate_coal_ore") }),
  DEEPSLATE_COPPER_ORE(lazy { Key.key("minecraft:block/deepslate_copper_ore") }),
  DEEPSLATE_DIAMOND_ORE(lazy { Key.key("minecraft:block/deepslate_diamond_ore") }),
  DEEPSLATE_EMERALD_ORE(lazy { Key.key("minecraft:block/deepslate_emerald_ore") }),
  DEEPSLATE_GOLD_ORE(lazy { Key.key("minecraft:block/deepslate_gold_ore") }),
  DEEPSLATE_IRON_ORE(lazy { Key.key("minecraft:block/deepslate_iron_ore") }),
  DEEPSLATE_LAPIS_ORE(lazy { Key.key("minecraft:block/deepslate_lapis_ore") }),
  DEEPSLATE_REDSTONE_ORE(lazy { Key.key("minecraft:block/deepslate_redstone_ore") }),
  DEEPSLATE_TILES(lazy { Key.key("minecraft:block/deepslate_tiles") }),
  DEEPSLATE_TILE_SLAB(lazy { Key.key("minecraft:block/deepslate_tile_slab") }),
  DEEPSLATE_TILE_STAIRS(lazy { Key.key("minecraft:block/deepslate_tile_stairs") }),
  DEEPSLATE_TILE_WALL_INVENTORY(lazy { Key.key("minecraft:block/deepslate_tile_wall_inventory") }),
  DIAMOND_BLOCK(lazy { Key.key("minecraft:block/diamond_block") }),
  DIAMOND_ORE(lazy { Key.key("minecraft:block/diamond_ore") }),
  DIORITE(lazy { Key.key("minecraft:block/diorite") }),
  DIORITE_SLAB(lazy { Key.key("minecraft:block/diorite_slab") }),
  DIORITE_STAIRS(lazy { Key.key("minecraft:block/diorite_stairs") }),
  DIORITE_WALL_INVENTORY(lazy { Key.key("minecraft:block/diorite_wall_inventory") }),
  DIRT(lazy { Key.key("minecraft:block/dirt") }),
  DIRT_PATH(lazy { Key.key("minecraft:block/dirt_path") }),
  DISPENSER(lazy { Key.key("minecraft:block/dispenser") }),
  DRAGON_EGG(lazy { Key.key("minecraft:block/dragon_egg") }),
  DRIED_KELP_BLOCK(lazy { Key.key("minecraft:block/dried_kelp_block") }),
  DRIPSTONE_BLOCK(lazy { Key.key("minecraft:block/dripstone_block") }),
  DROPPER(lazy { Key.key("minecraft:block/dropper") }),
  EMERALD_BLOCK(lazy { Key.key("minecraft:block/emerald_block") }),
  EMERALD_ORE(lazy { Key.key("minecraft:block/emerald_ore") }),
  ENCHANTING_TABLE(lazy { Key.key("minecraft:block/enchanting_table") }),
  END_PORTAL_FRAME(lazy { Key.key("minecraft:block/end_portal_frame") }),
  END_ROD(lazy { Key.key("minecraft:block/end_rod") }),
  END_STONE(lazy { Key.key("minecraft:block/end_stone") }),
  END_STONE_BRICKS(lazy { Key.key("minecraft:block/end_stone_bricks") }),
  END_STONE_BRICK_SLAB(lazy { Key.key("minecraft:block/end_stone_brick_slab") }),
  END_STONE_BRICK_STAIRS(lazy { Key.key("minecraft:block/end_stone_brick_stairs") }),
  END_STONE_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/end_stone_brick_wall_inventory")
      }),
  EXPOSED_CHISELED_COPPER(lazy { Key.key("minecraft:block/exposed_chiseled_copper") }),
  EXPOSED_COPPER(lazy { Key.key("minecraft:block/exposed_copper") }),
  EXPOSED_COPPER_BULB(lazy { Key.key("minecraft:block/exposed_copper_bulb") }),
  EXPOSED_COPPER_GRATE(lazy { Key.key("minecraft:block/exposed_copper_grate") }),
  EXPOSED_COPPER_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/exposed_copper_trapdoor_bottom")
      }),
  EXPOSED_CUT_COPPER(lazy { Key.key("minecraft:block/exposed_cut_copper") }),
  EXPOSED_CUT_COPPER_SLAB(lazy { Key.key("minecraft:block/exposed_cut_copper_slab") }),
  EXPOSED_CUT_COPPER_STAIRS(lazy { Key.key("minecraft:block/exposed_cut_copper_stairs") }),
  FARMLAND(lazy { Key.key("minecraft:block/farmland") }),
  FIRE_CORAL_BLOCK(lazy { Key.key("minecraft:block/fire_coral_block") }),
  FLETCHING_TABLE(lazy { Key.key("minecraft:block/fletching_table") }),
  FLOWERING_AZALEA(lazy { Key.key("minecraft:block/flowering_azalea") }),
  FLOWERING_AZALEA_LEAVES(lazy { Key.key("minecraft:block/flowering_azalea_leaves") }),
  FURNACE(lazy { Key.key("minecraft:block/furnace") }),
  GILDED_BLACKSTONE(lazy { Key.key("minecraft:block/gilded_blackstone") }),
  GLASS(lazy { Key.key("minecraft:block/glass") }),
  GLOWSTONE(lazy { Key.key("minecraft:block/glowstone") }),
  GOLD_BLOCK(lazy { Key.key("minecraft:block/gold_block") }),
  GOLD_ORE(lazy { Key.key("minecraft:block/gold_ore") }),
  GRANITE(lazy { Key.key("minecraft:block/granite") }),
  GRANITE_SLAB(lazy { Key.key("minecraft:block/granite_slab") }),
  GRANITE_STAIRS(lazy { Key.key("minecraft:block/granite_stairs") }),
  GRANITE_WALL_INVENTORY(lazy { Key.key("minecraft:block/granite_wall_inventory") }),
  GRASS_BLOCK(lazy { Key.key("minecraft:block/grass_block") }),
  GRAVEL(lazy { Key.key("minecraft:block/gravel") }),
  GRAY_CARPET(lazy { Key.key("minecraft:block/gray_carpet") }),
  GRAY_CONCRETE(lazy { Key.key("minecraft:block/gray_concrete") }),
  GRAY_CONCRETE_POWDER(lazy { Key.key("minecraft:block/gray_concrete_powder") }),
  GRAY_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/gray_glazed_terracotta") }),
  GRAY_STAINED_GLASS(lazy { Key.key("minecraft:block/gray_stained_glass") }),
  GRAY_TERRACOTTA(lazy { Key.key("minecraft:block/gray_terracotta") }),
  GRAY_WOOL(lazy { Key.key("minecraft:block/gray_wool") }),
  GREEN_CARPET(lazy { Key.key("minecraft:block/green_carpet") }),
  GREEN_CONCRETE(lazy { Key.key("minecraft:block/green_concrete") }),
  GREEN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/green_concrete_powder") }),
  GREEN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/green_glazed_terracotta") }),
  GREEN_STAINED_GLASS(lazy { Key.key("minecraft:block/green_stained_glass") }),
  GREEN_TERRACOTTA(lazy { Key.key("minecraft:block/green_terracotta") }),
  GREEN_WOOL(lazy { Key.key("minecraft:block/green_wool") }),
  GRINDSTONE(lazy { Key.key("minecraft:block/grindstone") }),
  HAY_BLOCK(lazy { Key.key("minecraft:block/hay_block") }),
  HEAVY_CORE(lazy { Key.key("minecraft:block/heavy_core") }),
  HEAVY_WEIGHTED_PRESSURE_PLATE(lazy { Key.key("minecraft:block/heavy_weighted_pressure_plate") }),
  HONEYCOMB_BLOCK(lazy { Key.key("minecraft:block/honeycomb_block") }),
  HONEY_BLOCK(lazy { Key.key("minecraft:block/honey_block") }),
  HORN_CORAL_BLOCK(lazy { Key.key("minecraft:block/horn_coral_block") }),
  ICE(lazy { Key.key("minecraft:block/ice") }),
  MOSSY_STONE_BRICKS(lazy { Key.key("minecraft:block/mossy_stone_bricks") }),
  STONE(lazy { Key.key("minecraft:block/stone") }),
  STONE_BRICKS(lazy { Key.key("minecraft:block/stone_bricks") }),
  IRON_BLOCK(lazy { Key.key("minecraft:block/iron_block") }),
  IRON_ORE(lazy { Key.key("minecraft:block/iron_ore") }),
  IRON_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/iron_trapdoor_bottom") }),
  JACK_O_LANTERN(lazy { Key.key("minecraft:block/jack_o_lantern") }),
  JIGSAW(lazy { Key.key("minecraft:block/jigsaw") }),
  JUKEBOX(lazy { Key.key("minecraft:block/jukebox") }),
  JUNGLE_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/jungle_button_inventory") }),
  JUNGLE_FENCE_INVENTORY(lazy { Key.key("minecraft:block/jungle_fence_inventory") }),
  JUNGLE_FENCE_GATE(lazy { Key.key("minecraft:block/jungle_fence_gate") }),
  JUNGLE_LEAVES(lazy { Key.key("minecraft:block/jungle_leaves") }),
  JUNGLE_LOG(lazy { Key.key("minecraft:block/jungle_log") }),
  JUNGLE_PLANKS(lazy { Key.key("minecraft:block/jungle_planks") }),
  JUNGLE_PRESSURE_PLATE(lazy { Key.key("minecraft:block/jungle_pressure_plate") }),
  JUNGLE_SLAB(lazy { Key.key("minecraft:block/jungle_slab") }),
  JUNGLE_STAIRS(lazy { Key.key("minecraft:block/jungle_stairs") }),
  JUNGLE_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/jungle_trapdoor_bottom") }),
  JUNGLE_WOOD(lazy { Key.key("minecraft:block/jungle_wood") }),
  LAPIS_BLOCK(lazy { Key.key("minecraft:block/lapis_block") }),
  LAPIS_ORE(lazy { Key.key("minecraft:block/lapis_ore") }),
  LECTERN(lazy { Key.key("minecraft:block/lectern") }),
  LIGHTNING_ROD(lazy { Key.key("minecraft:block/lightning_rod") }),
  LIGHT_BLUE_CARPET(lazy { Key.key("minecraft:block/light_blue_carpet") }),
  LIGHT_BLUE_CONCRETE(lazy { Key.key("minecraft:block/light_blue_concrete") }),
  LIGHT_BLUE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/light_blue_concrete_powder") }),
  LIGHT_BLUE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/light_blue_glazed_terracotta") }),
  LIGHT_BLUE_STAINED_GLASS(lazy { Key.key("minecraft:block/light_blue_stained_glass") }),
  LIGHT_BLUE_TERRACOTTA(lazy { Key.key("minecraft:block/light_blue_terracotta") }),
  LIGHT_BLUE_WOOL(lazy { Key.key("minecraft:block/light_blue_wool") }),
  LIGHT_GRAY_CARPET(lazy { Key.key("minecraft:block/light_gray_carpet") }),
  LIGHT_GRAY_CONCRETE(lazy { Key.key("minecraft:block/light_gray_concrete") }),
  LIGHT_GRAY_CONCRETE_POWDER(lazy { Key.key("minecraft:block/light_gray_concrete_powder") }),
  LIGHT_GRAY_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/light_gray_glazed_terracotta") }),
  LIGHT_GRAY_STAINED_GLASS(lazy { Key.key("minecraft:block/light_gray_stained_glass") }),
  LIGHT_GRAY_TERRACOTTA(lazy { Key.key("minecraft:block/light_gray_terracotta") }),
  LIGHT_GRAY_WOOL(lazy { Key.key("minecraft:block/light_gray_wool") }),
  LIGHT_WEIGHTED_PRESSURE_PLATE(lazy { Key.key("minecraft:block/light_weighted_pressure_plate") }),
  LIME_CARPET(lazy { Key.key("minecraft:block/lime_carpet") }),
  LIME_CONCRETE(lazy { Key.key("minecraft:block/lime_concrete") }),
  LIME_CONCRETE_POWDER(lazy { Key.key("minecraft:block/lime_concrete_powder") }),
  LIME_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/lime_glazed_terracotta") }),
  LIME_STAINED_GLASS(lazy { Key.key("minecraft:block/lime_stained_glass") }),
  LIME_TERRACOTTA(lazy { Key.key("minecraft:block/lime_terracotta") }),
  LIME_WOOL(lazy { Key.key("minecraft:block/lime_wool") }),
  LODESTONE(lazy { Key.key("minecraft:block/lodestone") }),
  LOOM(lazy { Key.key("minecraft:block/loom") }),
  MAGENTA_CARPET(lazy { Key.key("minecraft:block/magenta_carpet") }),
  MAGENTA_CONCRETE(lazy { Key.key("minecraft:block/magenta_concrete") }),
  MAGENTA_CONCRETE_POWDER(lazy { Key.key("minecraft:block/magenta_concrete_powder") }),
  MAGENTA_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/magenta_glazed_terracotta") }),
  MAGENTA_STAINED_GLASS(lazy { Key.key("minecraft:block/magenta_stained_glass") }),
  MAGENTA_TERRACOTTA(lazy { Key.key("minecraft:block/magenta_terracotta") }),
  MAGENTA_WOOL(lazy { Key.key("minecraft:block/magenta_wool") }),
  MAGMA_BLOCK(lazy { Key.key("minecraft:block/magma_block") }),
  MANGROVE_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/mangrove_button_inventory") }),
  MANGROVE_FENCE_INVENTORY(lazy { Key.key("minecraft:block/mangrove_fence_inventory") }),
  MANGROVE_FENCE_GATE(lazy { Key.key("minecraft:block/mangrove_fence_gate") }),
  MANGROVE_LEAVES(lazy { Key.key("minecraft:block/mangrove_leaves") }),
  MANGROVE_LOG(lazy { Key.key("minecraft:block/mangrove_log") }),
  MANGROVE_PLANKS(lazy { Key.key("minecraft:block/mangrove_planks") }),
  MANGROVE_PRESSURE_PLATE(lazy { Key.key("minecraft:block/mangrove_pressure_plate") }),
  MANGROVE_ROOTS(lazy { Key.key("minecraft:block/mangrove_roots") }),
  MANGROVE_SLAB(lazy { Key.key("minecraft:block/mangrove_slab") }),
  MANGROVE_STAIRS(lazy { Key.key("minecraft:block/mangrove_stairs") }),
  MANGROVE_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/mangrove_trapdoor_bottom") }),
  MANGROVE_WOOD(lazy { Key.key("minecraft:block/mangrove_wood") }),
  MELON(lazy { Key.key("minecraft:block/melon") }),
  MOSSY_COBBLESTONE(lazy { Key.key("minecraft:block/mossy_cobblestone") }),
  MOSSY_COBBLESTONE_SLAB(lazy { Key.key("minecraft:block/mossy_cobblestone_slab") }),
  MOSSY_COBBLESTONE_STAIRS(lazy { Key.key("minecraft:block/mossy_cobblestone_stairs") }),
  MOSSY_COBBLESTONE_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/mossy_cobblestone_wall_inventory") }),
  MOSSY_STONE_BRICK_SLAB(lazy { Key.key("minecraft:block/mossy_stone_brick_slab") }),
  MOSSY_STONE_BRICK_STAIRS(lazy { Key.key("minecraft:block/mossy_stone_brick_stairs") }),
  MOSSY_STONE_BRICK_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/mossy_stone_brick_wall_inventory") }),
  MOSS_BLOCK(lazy { Key.key("minecraft:block/moss_block") }),
  MOSS_CARPET(lazy { Key.key("minecraft:block/moss_carpet") }),
  MUD(lazy { Key.key("minecraft:block/mud") }),
  MUDDY_MANGROVE_ROOTS(lazy { Key.key("minecraft:block/muddy_mangrove_roots") }),
  MUD_BRICKS(lazy { Key.key("minecraft:block/mud_bricks") }),
  MUD_BRICK_SLAB(lazy { Key.key("minecraft:block/mud_brick_slab") }),
  MUD_BRICK_STAIRS(lazy { Key.key("minecraft:block/mud_brick_stairs") }),
  MUD_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/mud_brick_wall_inventory") }),
  MUSHROOM_STEM_INVENTORY(lazy { Key.key("minecraft:block/mushroom_stem_inventory") }),
  MYCELIUM(lazy { Key.key("minecraft:block/mycelium") }),
  NETHERITE_BLOCK(lazy { Key.key("minecraft:block/netherite_block") }),
  NETHERRACK(lazy { Key.key("minecraft:block/netherrack") }),
  NETHER_BRICKS(lazy { Key.key("minecraft:block/nether_bricks") }),
  NETHER_BRICK_FENCE_INVENTORY(lazy { Key.key("minecraft:block/nether_brick_fence_inventory") }),
  NETHER_BRICK_SLAB(lazy { Key.key("minecraft:block/nether_brick_slab") }),
  NETHER_BRICK_STAIRS(lazy { Key.key("minecraft:block/nether_brick_stairs") }),
  NETHER_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/nether_brick_wall_inventory") }),
  NETHER_GOLD_ORE(lazy { Key.key("minecraft:block/nether_gold_ore") }),
  NETHER_QUARTZ_ORE(lazy { Key.key("minecraft:block/nether_quartz_ore") }),
  NETHER_WART_BLOCK(lazy { Key.key("minecraft:block/nether_wart_block") }),
  NOTE_BLOCK(lazy { Key.key("minecraft:block/note_block") }),
  OAK_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/oak_button_inventory") }),
  OAK_FENCE_INVENTORY(lazy { Key.key("minecraft:block/oak_fence_inventory") }),
  OAK_FENCE_GATE(lazy { Key.key("minecraft:block/oak_fence_gate") }),
  OAK_LEAVES(lazy { Key.key("minecraft:block/oak_leaves") }),
  OAK_LOG(lazy { Key.key("minecraft:block/oak_log") }),
  OAK_PLANKS(lazy { Key.key("minecraft:block/oak_planks") }),
  OAK_PRESSURE_PLATE(lazy { Key.key("minecraft:block/oak_pressure_plate") }),
  OAK_SLAB(lazy { Key.key("minecraft:block/oak_slab") }),
  OAK_STAIRS(lazy { Key.key("minecraft:block/oak_stairs") }),
  OAK_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/oak_trapdoor_bottom") }),
  OAK_WOOD(lazy { Key.key("minecraft:block/oak_wood") }),
  OBSERVER(lazy { Key.key("minecraft:block/observer") }),
  OBSIDIAN(lazy { Key.key("minecraft:block/obsidian") }),
  OCHRE_FROGLIGHT(lazy { Key.key("minecraft:block/ochre_froglight") }),
  ORANGE_CARPET(lazy { Key.key("minecraft:block/orange_carpet") }),
  ORANGE_CONCRETE(lazy { Key.key("minecraft:block/orange_concrete") }),
  ORANGE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/orange_concrete_powder") }),
  ORANGE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/orange_glazed_terracotta") }),
  ORANGE_STAINED_GLASS(lazy { Key.key("minecraft:block/orange_stained_glass") }),
  ORANGE_TERRACOTTA(lazy { Key.key("minecraft:block/orange_terracotta") }),
  ORANGE_WOOL(lazy { Key.key("minecraft:block/orange_wool") }),
  OXIDIZED_CHISELED_COPPER(lazy { Key.key("minecraft:block/oxidized_chiseled_copper") }),
  OXIDIZED_COPPER(lazy { Key.key("minecraft:block/oxidized_copper") }),
  OXIDIZED_COPPER_BULB(lazy { Key.key("minecraft:block/oxidized_copper_bulb") }),
  OXIDIZED_COPPER_GRATE(lazy { Key.key("minecraft:block/oxidized_copper_grate") }),
  OXIDIZED_COPPER_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/oxidized_copper_trapdoor_bottom")
      }),
  OXIDIZED_CUT_COPPER(lazy { Key.key("minecraft:block/oxidized_cut_copper") }),
  OXIDIZED_CUT_COPPER_SLAB(lazy { Key.key("minecraft:block/oxidized_cut_copper_slab") }),
  OXIDIZED_CUT_COPPER_STAIRS(lazy { Key.key("minecraft:block/oxidized_cut_copper_stairs") }),
  PACKED_ICE(lazy { Key.key("minecraft:block/packed_ice") }),
  PACKED_MUD(lazy { Key.key("minecraft:block/packed_mud") }),
  PEARLESCENT_FROGLIGHT(lazy { Key.key("minecraft:block/pearlescent_froglight") }),
  PETRIFIED_OAK_SLAB(lazy { Key.key("minecraft:block/petrified_oak_slab") }),
  PINK_CARPET(lazy { Key.key("minecraft:block/pink_carpet") }),
  PINK_CONCRETE(lazy { Key.key("minecraft:block/pink_concrete") }),
  PINK_CONCRETE_POWDER(lazy { Key.key("minecraft:block/pink_concrete_powder") }),
  PINK_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/pink_glazed_terracotta") }),
  PINK_STAINED_GLASS(lazy { Key.key("minecraft:block/pink_stained_glass") }),
  PINK_TERRACOTTA(lazy { Key.key("minecraft:block/pink_terracotta") }),
  PINK_WOOL(lazy { Key.key("minecraft:block/pink_wool") }),
  PISTON_INVENTORY(lazy { Key.key("minecraft:block/piston_inventory") }),
  PODZOL(lazy { Key.key("minecraft:block/podzol") }),
  POLISHED_ANDESITE(lazy { Key.key("minecraft:block/polished_andesite") }),
  POLISHED_ANDESITE_SLAB(lazy { Key.key("minecraft:block/polished_andesite_slab") }),
  POLISHED_ANDESITE_STAIRS(lazy { Key.key("minecraft:block/polished_andesite_stairs") }),
  POLISHED_BASALT(lazy { Key.key("minecraft:block/polished_basalt") }),
  POLISHED_BLACKSTONE(lazy { Key.key("minecraft:block/polished_blackstone") }),
  POLISHED_BLACKSTONE_BRICKS(lazy { Key.key("minecraft:block/polished_blackstone_bricks") }),
  POLISHED_BLACKSTONE_BRICK_SLAB(lazy { Key.key("minecraft:block/polished_blackstone_brick_slab")
      }),
  POLISHED_BLACKSTONE_BRICK_STAIRS(lazy {
      Key.key("minecraft:block/polished_blackstone_brick_stairs") }),
  POLISHED_BLACKSTONE_BRICK_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/polished_blackstone_brick_wall_inventory") }),
  POLISHED_BLACKSTONE_BUTTON_INVENTORY(lazy {
      Key.key("minecraft:block/polished_blackstone_button_inventory") }),
  POLISHED_BLACKSTONE_PRESSURE_PLATE(lazy {
      Key.key("minecraft:block/polished_blackstone_pressure_plate") }),
  POLISHED_BLACKSTONE_SLAB(lazy { Key.key("minecraft:block/polished_blackstone_slab") }),
  POLISHED_BLACKSTONE_STAIRS(lazy { Key.key("minecraft:block/polished_blackstone_stairs") }),
  POLISHED_BLACKSTONE_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/polished_blackstone_wall_inventory") }),
  POLISHED_DEEPSLATE(lazy { Key.key("minecraft:block/polished_deepslate") }),
  POLISHED_DEEPSLATE_SLAB(lazy { Key.key("minecraft:block/polished_deepslate_slab") }),
  POLISHED_DEEPSLATE_STAIRS(lazy { Key.key("minecraft:block/polished_deepslate_stairs") }),
  POLISHED_DEEPSLATE_WALL_INVENTORY(lazy {
      Key.key("minecraft:block/polished_deepslate_wall_inventory") }),
  POLISHED_DIORITE(lazy { Key.key("minecraft:block/polished_diorite") }),
  POLISHED_DIORITE_SLAB(lazy { Key.key("minecraft:block/polished_diorite_slab") }),
  POLISHED_DIORITE_STAIRS(lazy { Key.key("minecraft:block/polished_diorite_stairs") }),
  POLISHED_GRANITE(lazy { Key.key("minecraft:block/polished_granite") }),
  POLISHED_GRANITE_SLAB(lazy { Key.key("minecraft:block/polished_granite_slab") }),
  POLISHED_GRANITE_STAIRS(lazy { Key.key("minecraft:block/polished_granite_stairs") }),
  POLISHED_TUFF(lazy { Key.key("minecraft:block/polished_tuff") }),
  POLISHED_TUFF_SLAB(lazy { Key.key("minecraft:block/polished_tuff_slab") }),
  POLISHED_TUFF_STAIRS(lazy { Key.key("minecraft:block/polished_tuff_stairs") }),
  POLISHED_TUFF_WALL_INVENTORY(lazy { Key.key("minecraft:block/polished_tuff_wall_inventory") }),
  PRISMARINE(lazy { Key.key("minecraft:block/prismarine") }),
  PRISMARINE_BRICKS(lazy { Key.key("minecraft:block/prismarine_bricks") }),
  PRISMARINE_BRICK_SLAB(lazy { Key.key("minecraft:block/prismarine_brick_slab") }),
  PRISMARINE_BRICK_STAIRS(lazy { Key.key("minecraft:block/prismarine_brick_stairs") }),
  PRISMARINE_SLAB(lazy { Key.key("minecraft:block/prismarine_slab") }),
  PRISMARINE_STAIRS(lazy { Key.key("minecraft:block/prismarine_stairs") }),
  PRISMARINE_WALL_INVENTORY(lazy { Key.key("minecraft:block/prismarine_wall_inventory") }),
  PUMPKIN(lazy { Key.key("minecraft:block/pumpkin") }),
  PURPLE_CARPET(lazy { Key.key("minecraft:block/purple_carpet") }),
  PURPLE_CONCRETE(lazy { Key.key("minecraft:block/purple_concrete") }),
  PURPLE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/purple_concrete_powder") }),
  PURPLE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/purple_glazed_terracotta") }),
  PURPLE_STAINED_GLASS(lazy { Key.key("minecraft:block/purple_stained_glass") }),
  PURPLE_TERRACOTTA(lazy { Key.key("minecraft:block/purple_terracotta") }),
  PURPLE_WOOL(lazy { Key.key("minecraft:block/purple_wool") }),
  PURPUR_BLOCK(lazy { Key.key("minecraft:block/purpur_block") }),
  PURPUR_PILLAR(lazy { Key.key("minecraft:block/purpur_pillar") }),
  PURPUR_SLAB(lazy { Key.key("minecraft:block/purpur_slab") }),
  PURPUR_STAIRS(lazy { Key.key("minecraft:block/purpur_stairs") }),
  QUARTZ_BLOCK(lazy { Key.key("minecraft:block/quartz_block") }),
  QUARTZ_BRICKS(lazy { Key.key("minecraft:block/quartz_bricks") }),
  QUARTZ_PILLAR(lazy { Key.key("minecraft:block/quartz_pillar") }),
  QUARTZ_SLAB(lazy { Key.key("minecraft:block/quartz_slab") }),
  QUARTZ_STAIRS(lazy { Key.key("minecraft:block/quartz_stairs") }),
  RAW_COPPER_BLOCK(lazy { Key.key("minecraft:block/raw_copper_block") }),
  RAW_GOLD_BLOCK(lazy { Key.key("minecraft:block/raw_gold_block") }),
  RAW_IRON_BLOCK(lazy { Key.key("minecraft:block/raw_iron_block") }),
  REDSTONE_BLOCK(lazy { Key.key("minecraft:block/redstone_block") }),
  REDSTONE_LAMP(lazy { Key.key("minecraft:block/redstone_lamp") }),
  REDSTONE_ORE(lazy { Key.key("minecraft:block/redstone_ore") }),
  RED_CARPET(lazy { Key.key("minecraft:block/red_carpet") }),
  RED_CONCRETE(lazy { Key.key("minecraft:block/red_concrete") }),
  RED_CONCRETE_POWDER(lazy { Key.key("minecraft:block/red_concrete_powder") }),
  RED_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/red_glazed_terracotta") }),
  RED_MUSHROOM_BLOCK_INVENTORY(lazy { Key.key("minecraft:block/red_mushroom_block_inventory") }),
  RED_NETHER_BRICKS(lazy { Key.key("minecraft:block/red_nether_bricks") }),
  RED_NETHER_BRICK_SLAB(lazy { Key.key("minecraft:block/red_nether_brick_slab") }),
  RED_NETHER_BRICK_STAIRS(lazy { Key.key("minecraft:block/red_nether_brick_stairs") }),
  RED_NETHER_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/red_nether_brick_wall_inventory")
      }),
  RED_SAND(lazy { Key.key("minecraft:block/red_sand") }),
  RED_SANDSTONE(lazy { Key.key("minecraft:block/red_sandstone") }),
  RED_SANDSTONE_SLAB(lazy { Key.key("minecraft:block/red_sandstone_slab") }),
  RED_SANDSTONE_STAIRS(lazy { Key.key("minecraft:block/red_sandstone_stairs") }),
  RED_SANDSTONE_WALL_INVENTORY(lazy { Key.key("minecraft:block/red_sandstone_wall_inventory") }),
  RED_STAINED_GLASS(lazy { Key.key("minecraft:block/red_stained_glass") }),
  RED_TERRACOTTA(lazy { Key.key("minecraft:block/red_terracotta") }),
  RED_WOOL(lazy { Key.key("minecraft:block/red_wool") }),
  REINFORCED_DEEPSLATE(lazy { Key.key("minecraft:block/reinforced_deepslate") }),
  REPEATING_COMMAND_BLOCK(lazy { Key.key("minecraft:block/repeating_command_block") }),
  RESPAWN_ANCHOR_0(lazy { Key.key("minecraft:block/respawn_anchor_0") }),
  ROOTED_DIRT(lazy { Key.key("minecraft:block/rooted_dirt") }),
  SAND(lazy { Key.key("minecraft:block/sand") }),
  SANDSTONE(lazy { Key.key("minecraft:block/sandstone") }),
  SANDSTONE_SLAB(lazy { Key.key("minecraft:block/sandstone_slab") }),
  SANDSTONE_STAIRS(lazy { Key.key("minecraft:block/sandstone_stairs") }),
  SANDSTONE_WALL_INVENTORY(lazy { Key.key("minecraft:block/sandstone_wall_inventory") }),
  SCAFFOLDING_STABLE(lazy { Key.key("minecraft:block/scaffolding_stable") }),
  SCULK(lazy { Key.key("minecraft:block/sculk") }),
  SCULK_CATALYST(lazy { Key.key("minecraft:block/sculk_catalyst") }),
  SCULK_SENSOR_INACTIVE(lazy { Key.key("minecraft:block/sculk_sensor_inactive") }),
  SCULK_SHRIEKER(lazy { Key.key("minecraft:block/sculk_shrieker") }),
  SEA_LANTERN(lazy { Key.key("minecraft:block/sea_lantern") }),
  SHROOMLIGHT(lazy { Key.key("minecraft:block/shroomlight") }),
  SLIME_BLOCK(lazy { Key.key("minecraft:block/slime_block") }),
  SMALL_DRIPLEAF_TOP(lazy { Key.key("minecraft:block/small_dripleaf_top") }),
  SMITHING_TABLE(lazy { Key.key("minecraft:block/smithing_table") }),
  SMOKER(lazy { Key.key("minecraft:block/smoker") }),
  SMOOTH_BASALT(lazy { Key.key("minecraft:block/smooth_basalt") }),
  SMOOTH_QUARTZ(lazy { Key.key("minecraft:block/smooth_quartz") }),
  SMOOTH_QUARTZ_SLAB(lazy { Key.key("minecraft:block/smooth_quartz_slab") }),
  SMOOTH_QUARTZ_STAIRS(lazy { Key.key("minecraft:block/smooth_quartz_stairs") }),
  SMOOTH_RED_SANDSTONE(lazy { Key.key("minecraft:block/smooth_red_sandstone") }),
  SMOOTH_RED_SANDSTONE_SLAB(lazy { Key.key("minecraft:block/smooth_red_sandstone_slab") }),
  SMOOTH_RED_SANDSTONE_STAIRS(lazy { Key.key("minecraft:block/smooth_red_sandstone_stairs") }),
  SMOOTH_SANDSTONE(lazy { Key.key("minecraft:block/smooth_sandstone") }),
  SMOOTH_SANDSTONE_SLAB(lazy { Key.key("minecraft:block/smooth_sandstone_slab") }),
  SMOOTH_SANDSTONE_STAIRS(lazy { Key.key("minecraft:block/smooth_sandstone_stairs") }),
  SMOOTH_STONE(lazy { Key.key("minecraft:block/smooth_stone") }),
  SMOOTH_STONE_SLAB(lazy { Key.key("minecraft:block/smooth_stone_slab") }),
  SNOW_HEIGHT2(lazy { Key.key("minecraft:block/snow_height2") }),
  SNOW_BLOCK(lazy { Key.key("minecraft:block/snow_block") }),
  SOUL_SAND(lazy { Key.key("minecraft:block/soul_sand") }),
  SOUL_SOIL(lazy { Key.key("minecraft:block/soul_soil") }),
  SPAWNER(lazy { Key.key("minecraft:block/spawner") }),
  SPONGE(lazy { Key.key("minecraft:block/sponge") }),
  SPORE_BLOSSOM(lazy { Key.key("minecraft:block/spore_blossom") }),
  SPRUCE_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/spruce_button_inventory") }),
  SPRUCE_FENCE_INVENTORY(lazy { Key.key("minecraft:block/spruce_fence_inventory") }),
  SPRUCE_FENCE_GATE(lazy { Key.key("minecraft:block/spruce_fence_gate") }),
  SPRUCE_LEAVES(lazy { Key.key("minecraft:block/spruce_leaves") }),
  SPRUCE_LOG(lazy { Key.key("minecraft:block/spruce_log") }),
  SPRUCE_PLANKS(lazy { Key.key("minecraft:block/spruce_planks") }),
  SPRUCE_PRESSURE_PLATE(lazy { Key.key("minecraft:block/spruce_pressure_plate") }),
  SPRUCE_SLAB(lazy { Key.key("minecraft:block/spruce_slab") }),
  SPRUCE_STAIRS(lazy { Key.key("minecraft:block/spruce_stairs") }),
  SPRUCE_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/spruce_trapdoor_bottom") }),
  SPRUCE_WOOD(lazy { Key.key("minecraft:block/spruce_wood") }),
  STICKY_PISTON_INVENTORY(lazy { Key.key("minecraft:block/sticky_piston_inventory") }),
  STONECUTTER(lazy { Key.key("minecraft:block/stonecutter") }),
  STONE_BRICK_SLAB(lazy { Key.key("minecraft:block/stone_brick_slab") }),
  STONE_BRICK_STAIRS(lazy { Key.key("minecraft:block/stone_brick_stairs") }),
  STONE_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/stone_brick_wall_inventory") }),
  STONE_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/stone_button_inventory") }),
  STONE_PRESSURE_PLATE(lazy { Key.key("minecraft:block/stone_pressure_plate") }),
  STONE_SLAB(lazy { Key.key("minecraft:block/stone_slab") }),
  STONE_STAIRS(lazy { Key.key("minecraft:block/stone_stairs") }),
  STRIPPED_ACACIA_LOG(lazy { Key.key("minecraft:block/stripped_acacia_log") }),
  STRIPPED_ACACIA_WOOD(lazy { Key.key("minecraft:block/stripped_acacia_wood") }),
  STRIPPED_BAMBOO_BLOCK(lazy { Key.key("minecraft:block/stripped_bamboo_block") }),
  STRIPPED_BIRCH_LOG(lazy { Key.key("minecraft:block/stripped_birch_log") }),
  STRIPPED_BIRCH_WOOD(lazy { Key.key("minecraft:block/stripped_birch_wood") }),
  STRIPPED_CHERRY_LOG(lazy { Key.key("minecraft:block/stripped_cherry_log") }),
  STRIPPED_CHERRY_WOOD(lazy { Key.key("minecraft:block/stripped_cherry_wood") }),
  STRIPPED_CRIMSON_HYPHAE(lazy { Key.key("minecraft:block/stripped_crimson_hyphae") }),
  STRIPPED_CRIMSON_STEM(lazy { Key.key("minecraft:block/stripped_crimson_stem") }),
  STRIPPED_DARK_OAK_LOG(lazy { Key.key("minecraft:block/stripped_dark_oak_log") }),
  STRIPPED_DARK_OAK_WOOD(lazy { Key.key("minecraft:block/stripped_dark_oak_wood") }),
  STRIPPED_JUNGLE_LOG(lazy { Key.key("minecraft:block/stripped_jungle_log") }),
  STRIPPED_JUNGLE_WOOD(lazy { Key.key("minecraft:block/stripped_jungle_wood") }),
  STRIPPED_MANGROVE_LOG(lazy { Key.key("minecraft:block/stripped_mangrove_log") }),
  STRIPPED_MANGROVE_WOOD(lazy { Key.key("minecraft:block/stripped_mangrove_wood") }),
  STRIPPED_OAK_LOG(lazy { Key.key("minecraft:block/stripped_oak_log") }),
  STRIPPED_OAK_WOOD(lazy { Key.key("minecraft:block/stripped_oak_wood") }),
  STRIPPED_SPRUCE_LOG(lazy { Key.key("minecraft:block/stripped_spruce_log") }),
  STRIPPED_SPRUCE_WOOD(lazy { Key.key("minecraft:block/stripped_spruce_wood") }),
  STRIPPED_WARPED_HYPHAE(lazy { Key.key("minecraft:block/stripped_warped_hyphae") }),
  STRIPPED_WARPED_STEM(lazy { Key.key("minecraft:block/stripped_warped_stem") }),
  STRUCTURE_BLOCK(lazy { Key.key("minecraft:block/structure_block") }),
  SUSPICIOUS_GRAVEL_0(lazy { Key.key("minecraft:block/suspicious_gravel_0") }),
  SUSPICIOUS_SAND_0(lazy { Key.key("minecraft:block/suspicious_sand_0") }),
  TARGET(lazy { Key.key("minecraft:block/target") }),
  TERRACOTTA(lazy { Key.key("minecraft:block/terracotta") }),
  TINTED_GLASS(lazy { Key.key("minecraft:block/tinted_glass") }),
  TNT(lazy { Key.key("minecraft:block/tnt") }),
  TRIAL_SPAWNER(lazy { Key.key("minecraft:block/trial_spawner") }),
  TUBE_CORAL_BLOCK(lazy { Key.key("minecraft:block/tube_coral_block") }),
  TUFF(lazy { Key.key("minecraft:block/tuff") }),
  TUFF_BRICKS(lazy { Key.key("minecraft:block/tuff_bricks") }),
  TUFF_BRICK_SLAB(lazy { Key.key("minecraft:block/tuff_brick_slab") }),
  TUFF_BRICK_STAIRS(lazy { Key.key("minecraft:block/tuff_brick_stairs") }),
  TUFF_BRICK_WALL_INVENTORY(lazy { Key.key("minecraft:block/tuff_brick_wall_inventory") }),
  TUFF_SLAB(lazy { Key.key("minecraft:block/tuff_slab") }),
  TUFF_STAIRS(lazy { Key.key("minecraft:block/tuff_stairs") }),
  TUFF_WALL_INVENTORY(lazy { Key.key("minecraft:block/tuff_wall_inventory") }),
  VAULT(lazy { Key.key("minecraft:block/vault") }),
  VERDANT_FROGLIGHT(lazy { Key.key("minecraft:block/verdant_froglight") }),
  WARPED_BUTTON_INVENTORY(lazy { Key.key("minecraft:block/warped_button_inventory") }),
  WARPED_FENCE_INVENTORY(lazy { Key.key("minecraft:block/warped_fence_inventory") }),
  WARPED_FENCE_GATE(lazy { Key.key("minecraft:block/warped_fence_gate") }),
  WARPED_HYPHAE(lazy { Key.key("minecraft:block/warped_hyphae") }),
  WARPED_NYLIUM(lazy { Key.key("minecraft:block/warped_nylium") }),
  WARPED_PLANKS(lazy { Key.key("minecraft:block/warped_planks") }),
  WARPED_PRESSURE_PLATE(lazy { Key.key("minecraft:block/warped_pressure_plate") }),
  WARPED_SLAB(lazy { Key.key("minecraft:block/warped_slab") }),
  WARPED_STAIRS(lazy { Key.key("minecraft:block/warped_stairs") }),
  WARPED_STEM(lazy { Key.key("minecraft:block/warped_stem") }),
  WARPED_TRAPDOOR_BOTTOM(lazy { Key.key("minecraft:block/warped_trapdoor_bottom") }),
  WARPED_WART_BLOCK(lazy { Key.key("minecraft:block/warped_wart_block") }),
  WEATHERED_CHISELED_COPPER(lazy { Key.key("minecraft:block/weathered_chiseled_copper") }),
  WEATHERED_COPPER(lazy { Key.key("minecraft:block/weathered_copper") }),
  WEATHERED_COPPER_GRATE(lazy { Key.key("minecraft:block/weathered_copper_grate") }),
  WEATHERED_CUT_COPPER(lazy { Key.key("minecraft:block/weathered_cut_copper") }),
  WEATHERED_CUT_COPPER_SLAB(lazy { Key.key("minecraft:block/weathered_cut_copper_slab") }),
  WEATHERED_CUT_COPPER_STAIRS(lazy { Key.key("minecraft:block/weathered_cut_copper_stairs") }),
  WEATHERED_COPPER_BULB(lazy { Key.key("minecraft:block/weathered_copper_bulb") }),
  WEATHERED_COPPER_TRAPDOOR_BOTTOM(lazy {
      Key.key("minecraft:block/weathered_copper_trapdoor_bottom") }),
  WET_SPONGE(lazy { Key.key("minecraft:block/wet_sponge") }),
  WHITE_CARPET(lazy { Key.key("minecraft:block/white_carpet") }),
  WHITE_CONCRETE(lazy { Key.key("minecraft:block/white_concrete") }),
  WHITE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/white_concrete_powder") }),
  WHITE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/white_glazed_terracotta") }),
  WHITE_STAINED_GLASS(lazy { Key.key("minecraft:block/white_stained_glass") }),
  WHITE_TERRACOTTA(lazy { Key.key("minecraft:block/white_terracotta") }),
  WHITE_WOOL(lazy { Key.key("minecraft:block/white_wool") }),
  YELLOW_CARPET(lazy { Key.key("minecraft:block/yellow_carpet") }),
  YELLOW_CONCRETE(lazy { Key.key("minecraft:block/yellow_concrete") }),
  YELLOW_CONCRETE_POWDER(lazy { Key.key("minecraft:block/yellow_concrete_powder") }),
  YELLOW_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/yellow_glazed_terracotta") }),
  YELLOW_STAINED_GLASS(lazy { Key.key("minecraft:block/yellow_stained_glass") }),
  YELLOW_TERRACOTTA(lazy { Key.key("minecraft:block/yellow_terracotta") }),
  YELLOW_WOOL(lazy { Key.key("minecraft:block/yellow_wool") }),
  ;

  public fun toGeneric(): SolidMaterialParent = SolidMaterialParent(key.value)
}
