package io.github.solid.resourcepack.material

import kotlin.Lazy
import net.kyori.adventure.key.Key

public enum class SolidBlockMaterialTexture(
  public val key: Lazy<Key>,
) {
  BLAST_FURNACE_FRONT_ON(lazy { Key.key("minecraft:block/blast_furnace_front_on") }),
  CAMPFIRE_FIRE(lazy { Key.key("minecraft:block/campfire_fire") }),
  CAMPFIRE_LOG_LIT(lazy { Key.key("minecraft:block/campfire_log_lit") }),
  CHAIN_COMMAND_BLOCK_BACK(lazy { Key.key("minecraft:block/chain_command_block_back") }),
  CHAIN_COMMAND_BLOCK_CONDITIONAL(lazy { Key.key("minecraft:block/chain_command_block_conditional")
      }),
  CHAIN_COMMAND_BLOCK_FRONT(lazy { Key.key("minecraft:block/chain_command_block_front") }),
  CHAIN_COMMAND_BLOCK_SIDE(lazy { Key.key("minecraft:block/chain_command_block_side") }),
  COMMAND_BLOCK_BACK(lazy { Key.key("minecraft:block/command_block_back") }),
  COMMAND_BLOCK_CONDITIONAL(lazy { Key.key("minecraft:block/command_block_conditional") }),
  COMMAND_BLOCK_FRONT(lazy { Key.key("minecraft:block/command_block_front") }),
  COMMAND_BLOCK_SIDE(lazy { Key.key("minecraft:block/command_block_side") }),
  CRIMSON_STEM(lazy { Key.key("minecraft:block/crimson_stem") }),
  FIRE_0(lazy { Key.key("minecraft:block/fire_0") }),
  FIRE_1(lazy { Key.key("minecraft:block/fire_1") }),
  KELP(lazy { Key.key("minecraft:block/kelp") }),
  KELP_PLANT(lazy { Key.key("minecraft:block/kelp_plant") }),
  LANTERN(lazy { Key.key("minecraft:block/lantern") }),
  LAVA_FLOW(lazy { Key.key("minecraft:block/lava_flow") }),
  LAVA_STILL(lazy { Key.key("minecraft:block/lava_still") }),
  MAGMA(lazy { Key.key("minecraft:block/magma") }),
  NETHER_PORTAL(lazy { Key.key("minecraft:block/nether_portal") }),
  PRISMARINE(lazy { Key.key("minecraft:block/prismarine") }),
  REPEATING_COMMAND_BLOCK_BACK(lazy { Key.key("minecraft:block/repeating_command_block_back") }),
  REPEATING_COMMAND_BLOCK_CONDITIONAL(lazy {
      Key.key("minecraft:block/repeating_command_block_conditional") }),
  REPEATING_COMMAND_BLOCK_FRONT(lazy { Key.key("minecraft:block/repeating_command_block_front") }),
  REPEATING_COMMAND_BLOCK_SIDE(lazy { Key.key("minecraft:block/repeating_command_block_side") }),
  RESPAWN_ANCHOR_TOP(lazy { Key.key("minecraft:block/respawn_anchor_top") }),
  SCULK(lazy { Key.key("minecraft:block/sculk") }),
  SCULK_CATALYST_SIDE_BLOOM(lazy { Key.key("minecraft:block/sculk_catalyst_side_bloom") }),
  SCULK_CATALYST_TOP_BLOOM(lazy { Key.key("minecraft:block/sculk_catalyst_top_bloom") }),
  SCULK_SENSOR_TENDRIL_ACTIVE(lazy { Key.key("minecraft:block/sculk_sensor_tendril_active") }),
  SCULK_SENSOR_TENDRIL_INACTIVE(lazy { Key.key("minecraft:block/sculk_sensor_tendril_inactive") }),
  SCULK_SHRIEKER_CAN_SUMMON_INNER_TOP(lazy {
      Key.key("minecraft:block/sculk_shrieker_can_summon_inner_top") }),
  SCULK_SHRIEKER_INNER_TOP(lazy { Key.key("minecraft:block/sculk_shrieker_inner_top") }),
  SCULK_VEIN(lazy { Key.key("minecraft:block/sculk_vein") }),
  SEAGRASS(lazy { Key.key("minecraft:block/seagrass") }),
  SEA_LANTERN(lazy { Key.key("minecraft:block/sea_lantern") }),
  SMOKER_FRONT_ON(lazy { Key.key("minecraft:block/smoker_front_on") }),
  SOUL_CAMPFIRE_FIRE(lazy { Key.key("minecraft:block/soul_campfire_fire") }),
  SOUL_CAMPFIRE_LOG_LIT(lazy { Key.key("minecraft:block/soul_campfire_log_lit") }),
  SOUL_FIRE_0(lazy { Key.key("minecraft:block/soul_fire_0") }),
  SOUL_FIRE_1(lazy { Key.key("minecraft:block/soul_fire_1") }),
  SOUL_LANTERN(lazy { Key.key("minecraft:block/soul_lantern") }),
  STONECUTTER_SAW(lazy { Key.key("minecraft:block/stonecutter_saw") }),
  TALL_SEAGRASS_BOTTOM(lazy { Key.key("minecraft:block/tall_seagrass_bottom") }),
  TALL_SEAGRASS_TOP(lazy { Key.key("minecraft:block/tall_seagrass_top") }),
  WARPED_STEM(lazy { Key.key("minecraft:block/warped_stem") }),
  WATER_FLOW(lazy { Key.key("minecraft:block/water_flow") }),
  WATER_STILL(lazy { Key.key("minecraft:block/water_still") }),
  ACACIA_DOOR_BOTTOM(lazy { Key.key("minecraft:block/acacia_door_bottom") }),
  ACACIA_DOOR_TOP(lazy { Key.key("minecraft:block/acacia_door_top") }),
  ACACIA_LEAVES(lazy { Key.key("minecraft:block/acacia_leaves") }),
  ACACIA_LOG(lazy { Key.key("minecraft:block/acacia_log") }),
  ACACIA_LOG_TOP(lazy { Key.key("minecraft:block/acacia_log_top") }),
  ACACIA_PLANKS(lazy { Key.key("minecraft:block/acacia_planks") }),
  ACACIA_SAPLING(lazy { Key.key("minecraft:block/acacia_sapling") }),
  ACACIA_TRAPDOOR(lazy { Key.key("minecraft:block/acacia_trapdoor") }),
  ACTIVATOR_RAIL(lazy { Key.key("minecraft:block/activator_rail") }),
  ACTIVATOR_RAIL_ON(lazy { Key.key("minecraft:block/activator_rail_on") }),
  ALLIUM(lazy { Key.key("minecraft:block/allium") }),
  AMETHYST_BLOCK(lazy { Key.key("minecraft:block/amethyst_block") }),
  AMETHYST_CLUSTER(lazy { Key.key("minecraft:block/amethyst_cluster") }),
  ANCIENT_DEBRIS_SIDE(lazy { Key.key("minecraft:block/ancient_debris_side") }),
  ANCIENT_DEBRIS_TOP(lazy { Key.key("minecraft:block/ancient_debris_top") }),
  ANDESITE(lazy { Key.key("minecraft:block/andesite") }),
  ANVIL(lazy { Key.key("minecraft:block/anvil") }),
  ANVIL_TOP(lazy { Key.key("minecraft:block/anvil_top") }),
  ATTACHED_MELON_STEM(lazy { Key.key("minecraft:block/attached_melon_stem") }),
  ATTACHED_PUMPKIN_STEM(lazy { Key.key("minecraft:block/attached_pumpkin_stem") }),
  AZALEA_LEAVES(lazy { Key.key("minecraft:block/azalea_leaves") }),
  AZALEA_PLANT(lazy { Key.key("minecraft:block/azalea_plant") }),
  AZALEA_SIDE(lazy { Key.key("minecraft:block/azalea_side") }),
  AZALEA_TOP(lazy { Key.key("minecraft:block/azalea_top") }),
  AZURE_BLUET(lazy { Key.key("minecraft:block/azure_bluet") }),
  BAMBOO_BLOCK(lazy { Key.key("minecraft:block/bamboo_block") }),
  BAMBOO_BLOCK_TOP(lazy { Key.key("minecraft:block/bamboo_block_top") }),
  BAMBOO_DOOR_BOTTOM(lazy { Key.key("minecraft:block/bamboo_door_bottom") }),
  BAMBOO_DOOR_TOP(lazy { Key.key("minecraft:block/bamboo_door_top") }),
  BAMBOO_FENCE(lazy { Key.key("minecraft:block/bamboo_fence") }),
  BAMBOO_FENCE_GATE(lazy { Key.key("minecraft:block/bamboo_fence_gate") }),
  BAMBOO_FENCE_GATE_PARTICLE(lazy { Key.key("minecraft:block/bamboo_fence_gate_particle") }),
  BAMBOO_FENCE_PARTICLE(lazy { Key.key("minecraft:block/bamboo_fence_particle") }),
  BAMBOO_LARGE_LEAVES(lazy { Key.key("minecraft:block/bamboo_large_leaves") }),
  BAMBOO_MOSAIC(lazy { Key.key("minecraft:block/bamboo_mosaic") }),
  BAMBOO_PLANKS(lazy { Key.key("minecraft:block/bamboo_planks") }),
  BAMBOO_SINGLELEAF(lazy { Key.key("minecraft:block/bamboo_singleleaf") }),
  BAMBOO_SMALL_LEAVES(lazy { Key.key("minecraft:block/bamboo_small_leaves") }),
  BAMBOO_STAGE0(lazy { Key.key("minecraft:block/bamboo_stage0") }),
  BAMBOO_STALK(lazy { Key.key("minecraft:block/bamboo_stalk") }),
  BAMBOO_TRAPDOOR(lazy { Key.key("minecraft:block/bamboo_trapdoor") }),
  BARREL_BOTTOM(lazy { Key.key("minecraft:block/barrel_bottom") }),
  BARREL_SIDE(lazy { Key.key("minecraft:block/barrel_side") }),
  BARREL_TOP(lazy { Key.key("minecraft:block/barrel_top") }),
  BARREL_TOP_OPEN(lazy { Key.key("minecraft:block/barrel_top_open") }),
  BASALT_SIDE(lazy { Key.key("minecraft:block/basalt_side") }),
  BASALT_TOP(lazy { Key.key("minecraft:block/basalt_top") }),
  BEACON(lazy { Key.key("minecraft:block/beacon") }),
  BEDROCK(lazy { Key.key("minecraft:block/bedrock") }),
  BEEHIVE_END(lazy { Key.key("minecraft:block/beehive_end") }),
  BEEHIVE_FRONT(lazy { Key.key("minecraft:block/beehive_front") }),
  BEEHIVE_FRONT_HONEY(lazy { Key.key("minecraft:block/beehive_front_honey") }),
  BEEHIVE_SIDE(lazy { Key.key("minecraft:block/beehive_side") }),
  BEETROOTS_STAGE0(lazy { Key.key("minecraft:block/beetroots_stage0") }),
  BEETROOTS_STAGE1(lazy { Key.key("minecraft:block/beetroots_stage1") }),
  BEETROOTS_STAGE2(lazy { Key.key("minecraft:block/beetroots_stage2") }),
  BEETROOTS_STAGE3(lazy { Key.key("minecraft:block/beetroots_stage3") }),
  BEE_NEST_BOTTOM(lazy { Key.key("minecraft:block/bee_nest_bottom") }),
  BEE_NEST_FRONT(lazy { Key.key("minecraft:block/bee_nest_front") }),
  BEE_NEST_FRONT_HONEY(lazy { Key.key("minecraft:block/bee_nest_front_honey") }),
  BEE_NEST_SIDE(lazy { Key.key("minecraft:block/bee_nest_side") }),
  BEE_NEST_TOP(lazy { Key.key("minecraft:block/bee_nest_top") }),
  BELL_BOTTOM(lazy { Key.key("minecraft:block/bell_bottom") }),
  BELL_SIDE(lazy { Key.key("minecraft:block/bell_side") }),
  BELL_TOP(lazy { Key.key("minecraft:block/bell_top") }),
  BIG_DRIPLEAF_SIDE(lazy { Key.key("minecraft:block/big_dripleaf_side") }),
  BIG_DRIPLEAF_STEM(lazy { Key.key("minecraft:block/big_dripleaf_stem") }),
  BIG_DRIPLEAF_TIP(lazy { Key.key("minecraft:block/big_dripleaf_tip") }),
  BIG_DRIPLEAF_TOP(lazy { Key.key("minecraft:block/big_dripleaf_top") }),
  BIRCH_DOOR_BOTTOM(lazy { Key.key("minecraft:block/birch_door_bottom") }),
  BIRCH_DOOR_TOP(lazy { Key.key("minecraft:block/birch_door_top") }),
  BIRCH_LEAVES(lazy { Key.key("minecraft:block/birch_leaves") }),
  BIRCH_LOG(lazy { Key.key("minecraft:block/birch_log") }),
  BIRCH_LOG_TOP(lazy { Key.key("minecraft:block/birch_log_top") }),
  BIRCH_PLANKS(lazy { Key.key("minecraft:block/birch_planks") }),
  BIRCH_SAPLING(lazy { Key.key("minecraft:block/birch_sapling") }),
  BIRCH_TRAPDOOR(lazy { Key.key("minecraft:block/birch_trapdoor") }),
  BLACKSTONE(lazy { Key.key("minecraft:block/blackstone") }),
  BLACKSTONE_TOP(lazy { Key.key("minecraft:block/blackstone_top") }),
  BLACK_CANDLE(lazy { Key.key("minecraft:block/black_candle") }),
  BLACK_CANDLE_LIT(lazy { Key.key("minecraft:block/black_candle_lit") }),
  BLACK_CONCRETE(lazy { Key.key("minecraft:block/black_concrete") }),
  BLACK_CONCRETE_POWDER(lazy { Key.key("minecraft:block/black_concrete_powder") }),
  BLACK_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/black_glazed_terracotta") }),
  BLACK_SHULKER_BOX(lazy { Key.key("minecraft:block/black_shulker_box") }),
  BLACK_STAINED_GLASS(lazy { Key.key("minecraft:block/black_stained_glass") }),
  BLACK_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/black_stained_glass_pane_top") }),
  BLACK_TERRACOTTA(lazy { Key.key("minecraft:block/black_terracotta") }),
  BLACK_WOOL(lazy { Key.key("minecraft:block/black_wool") }),
  BLAST_FURNACE_FRONT(lazy { Key.key("minecraft:block/blast_furnace_front") }),
  BLAST_FURNACE_SIDE(lazy { Key.key("minecraft:block/blast_furnace_side") }),
  BLAST_FURNACE_TOP(lazy { Key.key("minecraft:block/blast_furnace_top") }),
  BLUE_CANDLE(lazy { Key.key("minecraft:block/blue_candle") }),
  BLUE_CANDLE_LIT(lazy { Key.key("minecraft:block/blue_candle_lit") }),
  BLUE_CONCRETE(lazy { Key.key("minecraft:block/blue_concrete") }),
  BLUE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/blue_concrete_powder") }),
  BLUE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/blue_glazed_terracotta") }),
  BLUE_ICE(lazy { Key.key("minecraft:block/blue_ice") }),
  BLUE_ORCHID(lazy { Key.key("minecraft:block/blue_orchid") }),
  BLUE_SHULKER_BOX(lazy { Key.key("minecraft:block/blue_shulker_box") }),
  BLUE_STAINED_GLASS(lazy { Key.key("minecraft:block/blue_stained_glass") }),
  BLUE_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/blue_stained_glass_pane_top") }),
  BLUE_TERRACOTTA(lazy { Key.key("minecraft:block/blue_terracotta") }),
  BLUE_WOOL(lazy { Key.key("minecraft:block/blue_wool") }),
  BONE_BLOCK_SIDE(lazy { Key.key("minecraft:block/bone_block_side") }),
  BONE_BLOCK_TOP(lazy { Key.key("minecraft:block/bone_block_top") }),
  BOOKSHELF(lazy { Key.key("minecraft:block/bookshelf") }),
  BRAIN_CORAL(lazy { Key.key("minecraft:block/brain_coral") }),
  BRAIN_CORAL_BLOCK(lazy { Key.key("minecraft:block/brain_coral_block") }),
  BRAIN_CORAL_FAN(lazy { Key.key("minecraft:block/brain_coral_fan") }),
  BREWING_STAND(lazy { Key.key("minecraft:block/brewing_stand") }),
  BREWING_STAND_BASE(lazy { Key.key("minecraft:block/brewing_stand_base") }),
  BRICKS(lazy { Key.key("minecraft:block/bricks") }),
  BROWN_CANDLE(lazy { Key.key("minecraft:block/brown_candle") }),
  BROWN_CANDLE_LIT(lazy { Key.key("minecraft:block/brown_candle_lit") }),
  BROWN_CONCRETE(lazy { Key.key("minecraft:block/brown_concrete") }),
  BROWN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/brown_concrete_powder") }),
  BROWN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/brown_glazed_terracotta") }),
  BROWN_MUSHROOM(lazy { Key.key("minecraft:block/brown_mushroom") }),
  BROWN_MUSHROOM_BLOCK(lazy { Key.key("minecraft:block/brown_mushroom_block") }),
  BROWN_SHULKER_BOX(lazy { Key.key("minecraft:block/brown_shulker_box") }),
  BROWN_STAINED_GLASS(lazy { Key.key("minecraft:block/brown_stained_glass") }),
  BROWN_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/brown_stained_glass_pane_top") }),
  BROWN_TERRACOTTA(lazy { Key.key("minecraft:block/brown_terracotta") }),
  BROWN_WOOL(lazy { Key.key("minecraft:block/brown_wool") }),
  BUBBLE_CORAL(lazy { Key.key("minecraft:block/bubble_coral") }),
  BUBBLE_CORAL_BLOCK(lazy { Key.key("minecraft:block/bubble_coral_block") }),
  BUBBLE_CORAL_FAN(lazy { Key.key("minecraft:block/bubble_coral_fan") }),
  BUDDING_AMETHYST(lazy { Key.key("minecraft:block/budding_amethyst") }),
  CACTUS_BOTTOM(lazy { Key.key("minecraft:block/cactus_bottom") }),
  CACTUS_SIDE(lazy { Key.key("minecraft:block/cactus_side") }),
  CACTUS_TOP(lazy { Key.key("minecraft:block/cactus_top") }),
  CAKE_BOTTOM(lazy { Key.key("minecraft:block/cake_bottom") }),
  CAKE_INNER(lazy { Key.key("minecraft:block/cake_inner") }),
  CAKE_SIDE(lazy { Key.key("minecraft:block/cake_side") }),
  CAKE_TOP(lazy { Key.key("minecraft:block/cake_top") }),
  CALCITE(lazy { Key.key("minecraft:block/calcite") }),
  CALIBRATED_SCULK_SENSOR_AMETHYST(lazy {
      Key.key("minecraft:block/calibrated_sculk_sensor_amethyst") }),
  CALIBRATED_SCULK_SENSOR_INPUT_SIDE(lazy {
      Key.key("minecraft:block/calibrated_sculk_sensor_input_side") }),
  CALIBRATED_SCULK_SENSOR_TOP(lazy { Key.key("minecraft:block/calibrated_sculk_sensor_top") }),
  CAMPFIRE_LOG(lazy { Key.key("minecraft:block/campfire_log") }),
  CANDLE(lazy { Key.key("minecraft:block/candle") }),
  CANDLE_LIT(lazy { Key.key("minecraft:block/candle_lit") }),
  CARROTS_STAGE0(lazy { Key.key("minecraft:block/carrots_stage0") }),
  CARROTS_STAGE1(lazy { Key.key("minecraft:block/carrots_stage1") }),
  CARROTS_STAGE2(lazy { Key.key("minecraft:block/carrots_stage2") }),
  CARROTS_STAGE3(lazy { Key.key("minecraft:block/carrots_stage3") }),
  CARTOGRAPHY_TABLE_SIDE1(lazy { Key.key("minecraft:block/cartography_table_side1") }),
  CARTOGRAPHY_TABLE_SIDE2(lazy { Key.key("minecraft:block/cartography_table_side2") }),
  CARTOGRAPHY_TABLE_SIDE3(lazy { Key.key("minecraft:block/cartography_table_side3") }),
  CARTOGRAPHY_TABLE_TOP(lazy { Key.key("minecraft:block/cartography_table_top") }),
  CARVED_PUMPKIN(lazy { Key.key("minecraft:block/carved_pumpkin") }),
  CAULDRON_BOTTOM(lazy { Key.key("minecraft:block/cauldron_bottom") }),
  CAULDRON_INNER(lazy { Key.key("minecraft:block/cauldron_inner") }),
  CAULDRON_SIDE(lazy { Key.key("minecraft:block/cauldron_side") }),
  CAULDRON_TOP(lazy { Key.key("minecraft:block/cauldron_top") }),
  CAVE_VINES(lazy { Key.key("minecraft:block/cave_vines") }),
  CAVE_VINES_LIT(lazy { Key.key("minecraft:block/cave_vines_lit") }),
  CAVE_VINES_PLANT(lazy { Key.key("minecraft:block/cave_vines_plant") }),
  CAVE_VINES_PLANT_LIT(lazy { Key.key("minecraft:block/cave_vines_plant_lit") }),
  CHAIN(lazy { Key.key("minecraft:block/chain") }),
  CHERRY_DOOR_BOTTOM(lazy { Key.key("minecraft:block/cherry_door_bottom") }),
  CHERRY_DOOR_TOP(lazy { Key.key("minecraft:block/cherry_door_top") }),
  CHERRY_LEAVES(lazy { Key.key("minecraft:block/cherry_leaves") }),
  CHERRY_LOG(lazy { Key.key("minecraft:block/cherry_log") }),
  CHERRY_LOG_TOP(lazy { Key.key("minecraft:block/cherry_log_top") }),
  CHERRY_PLANKS(lazy { Key.key("minecraft:block/cherry_planks") }),
  CHERRY_SAPLING(lazy { Key.key("minecraft:block/cherry_sapling") }),
  CHERRY_TRAPDOOR(lazy { Key.key("minecraft:block/cherry_trapdoor") }),
  CHIPPED_ANVIL_TOP(lazy { Key.key("minecraft:block/chipped_anvil_top") }),
  CHISELED_BOOKSHELF_EMPTY(lazy { Key.key("minecraft:block/chiseled_bookshelf_empty") }),
  CHISELED_BOOKSHELF_OCCUPIED(lazy { Key.key("minecraft:block/chiseled_bookshelf_occupied") }),
  CHISELED_BOOKSHELF_SIDE(lazy { Key.key("minecraft:block/chiseled_bookshelf_side") }),
  CHISELED_BOOKSHELF_TOP(lazy { Key.key("minecraft:block/chiseled_bookshelf_top") }),
  CHISELED_COPPER(lazy { Key.key("minecraft:block/chiseled_copper") }),
  CHISELED_DEEPSLATE(lazy { Key.key("minecraft:block/chiseled_deepslate") }),
  CHISELED_NETHER_BRICKS(lazy { Key.key("minecraft:block/chiseled_nether_bricks") }),
  CHISELED_POLISHED_BLACKSTONE(lazy { Key.key("minecraft:block/chiseled_polished_blackstone") }),
  CHISELED_QUARTZ_BLOCK(lazy { Key.key("minecraft:block/chiseled_quartz_block") }),
  CHISELED_QUARTZ_BLOCK_TOP(lazy { Key.key("minecraft:block/chiseled_quartz_block_top") }),
  CHISELED_RED_SANDSTONE(lazy { Key.key("minecraft:block/chiseled_red_sandstone") }),
  CHISELED_SANDSTONE(lazy { Key.key("minecraft:block/chiseled_sandstone") }),
  CHISELED_STONE_BRICKS(lazy { Key.key("minecraft:block/chiseled_stone_bricks") }),
  CHISELED_TUFF(lazy { Key.key("minecraft:block/chiseled_tuff") }),
  CHISELED_TUFF_BRICKS(lazy { Key.key("minecraft:block/chiseled_tuff_bricks") }),
  CHISELED_TUFF_BRICKS_TOP(lazy { Key.key("minecraft:block/chiseled_tuff_bricks_top") }),
  CHISELED_TUFF_TOP(lazy { Key.key("minecraft:block/chiseled_tuff_top") }),
  CHORUS_FLOWER(lazy { Key.key("minecraft:block/chorus_flower") }),
  CHORUS_FLOWER_DEAD(lazy { Key.key("minecraft:block/chorus_flower_dead") }),
  CHORUS_PLANT(lazy { Key.key("minecraft:block/chorus_plant") }),
  CLAY(lazy { Key.key("minecraft:block/clay") }),
  COAL_BLOCK(lazy { Key.key("minecraft:block/coal_block") }),
  COAL_ORE(lazy { Key.key("minecraft:block/coal_ore") }),
  COARSE_DIRT(lazy { Key.key("minecraft:block/coarse_dirt") }),
  COBBLED_DEEPSLATE(lazy { Key.key("minecraft:block/cobbled_deepslate") }),
  COBBLESTONE(lazy { Key.key("minecraft:block/cobblestone") }),
  COBWEB(lazy { Key.key("minecraft:block/cobweb") }),
  COCOA_STAGE0(lazy { Key.key("minecraft:block/cocoa_stage0") }),
  COCOA_STAGE1(lazy { Key.key("minecraft:block/cocoa_stage1") }),
  COCOA_STAGE2(lazy { Key.key("minecraft:block/cocoa_stage2") }),
  COMPARATOR(lazy { Key.key("minecraft:block/comparator") }),
  COMPARATOR_ON(lazy { Key.key("minecraft:block/comparator_on") }),
  COMPOSTER_BOTTOM(lazy { Key.key("minecraft:block/composter_bottom") }),
  COMPOSTER_COMPOST(lazy { Key.key("minecraft:block/composter_compost") }),
  COMPOSTER_READY(lazy { Key.key("minecraft:block/composter_ready") }),
  COMPOSTER_SIDE(lazy { Key.key("minecraft:block/composter_side") }),
  COMPOSTER_TOP(lazy { Key.key("minecraft:block/composter_top") }),
  CONDUIT(lazy { Key.key("minecraft:block/conduit") }),
  COPPER_BLOCK(lazy { Key.key("minecraft:block/copper_block") }),
  COPPER_BULB(lazy { Key.key("minecraft:block/copper_bulb") }),
  COPPER_BULB_LIT(lazy { Key.key("minecraft:block/copper_bulb_lit") }),
  COPPER_BULB_LIT_POWERED(lazy { Key.key("minecraft:block/copper_bulb_lit_powered") }),
  COPPER_BULB_POWERED(lazy { Key.key("minecraft:block/copper_bulb_powered") }),
  COPPER_DOOR_BOTTOM(lazy { Key.key("minecraft:block/copper_door_bottom") }),
  COPPER_DOOR_TOP(lazy { Key.key("minecraft:block/copper_door_top") }),
  COPPER_GRATE(lazy { Key.key("minecraft:block/copper_grate") }),
  COPPER_ORE(lazy { Key.key("minecraft:block/copper_ore") }),
  COPPER_TRAPDOOR(lazy { Key.key("minecraft:block/copper_trapdoor") }),
  CORNFLOWER(lazy { Key.key("minecraft:block/cornflower") }),
  CRACKED_DEEPSLATE_BRICKS(lazy { Key.key("minecraft:block/cracked_deepslate_bricks") }),
  CRACKED_DEEPSLATE_TILES(lazy { Key.key("minecraft:block/cracked_deepslate_tiles") }),
  CRACKED_NETHER_BRICKS(lazy { Key.key("minecraft:block/cracked_nether_bricks") }),
  CRACKED_POLISHED_BLACKSTONE_BRICKS(lazy {
      Key.key("minecraft:block/cracked_polished_blackstone_bricks") }),
  CRACKED_STONE_BRICKS(lazy { Key.key("minecraft:block/cracked_stone_bricks") }),
  CRAFTER_BOTTOM(lazy { Key.key("minecraft:block/crafter_bottom") }),
  CRAFTER_EAST(lazy { Key.key("minecraft:block/crafter_east") }),
  CRAFTER_EAST_CRAFTING(lazy { Key.key("minecraft:block/crafter_east_crafting") }),
  CRAFTER_EAST_TRIGGERED(lazy { Key.key("minecraft:block/crafter_east_triggered") }),
  CRAFTER_NORTH(lazy { Key.key("minecraft:block/crafter_north") }),
  CRAFTER_NORTH_CRAFTING(lazy { Key.key("minecraft:block/crafter_north_crafting") }),
  CRAFTER_SOUTH(lazy { Key.key("minecraft:block/crafter_south") }),
  CRAFTER_SOUTH_TRIGGERED(lazy { Key.key("minecraft:block/crafter_south_triggered") }),
  CRAFTER_TOP(lazy { Key.key("minecraft:block/crafter_top") }),
  CRAFTER_TOP_CRAFTING(lazy { Key.key("minecraft:block/crafter_top_crafting") }),
  CRAFTER_TOP_TRIGGERED(lazy { Key.key("minecraft:block/crafter_top_triggered") }),
  CRAFTER_WEST(lazy { Key.key("minecraft:block/crafter_west") }),
  CRAFTER_WEST_CRAFTING(lazy { Key.key("minecraft:block/crafter_west_crafting") }),
  CRAFTER_WEST_TRIGGERED(lazy { Key.key("minecraft:block/crafter_west_triggered") }),
  CRAFTING_TABLE_FRONT(lazy { Key.key("minecraft:block/crafting_table_front") }),
  CRAFTING_TABLE_SIDE(lazy { Key.key("minecraft:block/crafting_table_side") }),
  CRAFTING_TABLE_TOP(lazy { Key.key("minecraft:block/crafting_table_top") }),
  CRIMSON_DOOR_BOTTOM(lazy { Key.key("minecraft:block/crimson_door_bottom") }),
  CRIMSON_DOOR_TOP(lazy { Key.key("minecraft:block/crimson_door_top") }),
  CRIMSON_FUNGUS(lazy { Key.key("minecraft:block/crimson_fungus") }),
  CRIMSON_NYLIUM(lazy { Key.key("minecraft:block/crimson_nylium") }),
  CRIMSON_NYLIUM_SIDE(lazy { Key.key("minecraft:block/crimson_nylium_side") }),
  CRIMSON_PLANKS(lazy { Key.key("minecraft:block/crimson_planks") }),
  CRIMSON_ROOTS(lazy { Key.key("minecraft:block/crimson_roots") }),
  CRIMSON_ROOTS_POT(lazy { Key.key("minecraft:block/crimson_roots_pot") }),
  CRIMSON_STEM_TOP(lazy { Key.key("minecraft:block/crimson_stem_top") }),
  CRIMSON_TRAPDOOR(lazy { Key.key("minecraft:block/crimson_trapdoor") }),
  CRYING_OBSIDIAN(lazy { Key.key("minecraft:block/crying_obsidian") }),
  CUT_COPPER(lazy { Key.key("minecraft:block/cut_copper") }),
  CUT_RED_SANDSTONE(lazy { Key.key("minecraft:block/cut_red_sandstone") }),
  CUT_SANDSTONE(lazy { Key.key("minecraft:block/cut_sandstone") }),
  CYAN_CANDLE(lazy { Key.key("minecraft:block/cyan_candle") }),
  CYAN_CANDLE_LIT(lazy { Key.key("minecraft:block/cyan_candle_lit") }),
  CYAN_CONCRETE(lazy { Key.key("minecraft:block/cyan_concrete") }),
  CYAN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/cyan_concrete_powder") }),
  CYAN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/cyan_glazed_terracotta") }),
  CYAN_SHULKER_BOX(lazy { Key.key("minecraft:block/cyan_shulker_box") }),
  CYAN_STAINED_GLASS(lazy { Key.key("minecraft:block/cyan_stained_glass") }),
  CYAN_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/cyan_stained_glass_pane_top") }),
  CYAN_TERRACOTTA(lazy { Key.key("minecraft:block/cyan_terracotta") }),
  CYAN_WOOL(lazy { Key.key("minecraft:block/cyan_wool") }),
  DAMAGED_ANVIL_TOP(lazy { Key.key("minecraft:block/damaged_anvil_top") }),
  DANDELION(lazy { Key.key("minecraft:block/dandelion") }),
  DARK_OAK_DOOR_BOTTOM(lazy { Key.key("minecraft:block/dark_oak_door_bottom") }),
  DARK_OAK_DOOR_TOP(lazy { Key.key("minecraft:block/dark_oak_door_top") }),
  DARK_OAK_LEAVES(lazy { Key.key("minecraft:block/dark_oak_leaves") }),
  DARK_OAK_LOG(lazy { Key.key("minecraft:block/dark_oak_log") }),
  DARK_OAK_LOG_TOP(lazy { Key.key("minecraft:block/dark_oak_log_top") }),
  DARK_OAK_PLANKS(lazy { Key.key("minecraft:block/dark_oak_planks") }),
  DARK_OAK_SAPLING(lazy { Key.key("minecraft:block/dark_oak_sapling") }),
  DARK_OAK_TRAPDOOR(lazy { Key.key("minecraft:block/dark_oak_trapdoor") }),
  DARK_PRISMARINE(lazy { Key.key("minecraft:block/dark_prismarine") }),
  DAYLIGHT_DETECTOR_INVERTED_TOP(lazy { Key.key("minecraft:block/daylight_detector_inverted_top")
      }),
  DAYLIGHT_DETECTOR_SIDE(lazy { Key.key("minecraft:block/daylight_detector_side") }),
  DAYLIGHT_DETECTOR_TOP(lazy { Key.key("minecraft:block/daylight_detector_top") }),
  DEAD_BRAIN_CORAL(lazy { Key.key("minecraft:block/dead_brain_coral") }),
  DEAD_BRAIN_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_brain_coral_block") }),
  DEAD_BRAIN_CORAL_FAN(lazy { Key.key("minecraft:block/dead_brain_coral_fan") }),
  DEAD_BUBBLE_CORAL(lazy { Key.key("minecraft:block/dead_bubble_coral") }),
  DEAD_BUBBLE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_bubble_coral_block") }),
  DEAD_BUBBLE_CORAL_FAN(lazy { Key.key("minecraft:block/dead_bubble_coral_fan") }),
  DEAD_BUSH(lazy { Key.key("minecraft:block/dead_bush") }),
  DEAD_FIRE_CORAL(lazy { Key.key("minecraft:block/dead_fire_coral") }),
  DEAD_FIRE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_fire_coral_block") }),
  DEAD_FIRE_CORAL_FAN(lazy { Key.key("minecraft:block/dead_fire_coral_fan") }),
  DEAD_HORN_CORAL(lazy { Key.key("minecraft:block/dead_horn_coral") }),
  DEAD_HORN_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_horn_coral_block") }),
  DEAD_HORN_CORAL_FAN(lazy { Key.key("minecraft:block/dead_horn_coral_fan") }),
  DEAD_TUBE_CORAL(lazy { Key.key("minecraft:block/dead_tube_coral") }),
  DEAD_TUBE_CORAL_BLOCK(lazy { Key.key("minecraft:block/dead_tube_coral_block") }),
  DEAD_TUBE_CORAL_FAN(lazy { Key.key("minecraft:block/dead_tube_coral_fan") }),
  DEBUG(lazy { Key.key("minecraft:block/debug") }),
  DEBUG2(lazy { Key.key("minecraft:block/debug2") }),
  DEEPSLATE(lazy { Key.key("minecraft:block/deepslate") }),
  DEEPSLATE_BRICKS(lazy { Key.key("minecraft:block/deepslate_bricks") }),
  DEEPSLATE_COAL_ORE(lazy { Key.key("minecraft:block/deepslate_coal_ore") }),
  DEEPSLATE_COPPER_ORE(lazy { Key.key("minecraft:block/deepslate_copper_ore") }),
  DEEPSLATE_DIAMOND_ORE(lazy { Key.key("minecraft:block/deepslate_diamond_ore") }),
  DEEPSLATE_EMERALD_ORE(lazy { Key.key("minecraft:block/deepslate_emerald_ore") }),
  DEEPSLATE_GOLD_ORE(lazy { Key.key("minecraft:block/deepslate_gold_ore") }),
  DEEPSLATE_IRON_ORE(lazy { Key.key("minecraft:block/deepslate_iron_ore") }),
  DEEPSLATE_LAPIS_ORE(lazy { Key.key("minecraft:block/deepslate_lapis_ore") }),
  DEEPSLATE_REDSTONE_ORE(lazy { Key.key("minecraft:block/deepslate_redstone_ore") }),
  DEEPSLATE_TILES(lazy { Key.key("minecraft:block/deepslate_tiles") }),
  DEEPSLATE_TOP(lazy { Key.key("minecraft:block/deepslate_top") }),
  DESTROY_STAGE_0(lazy { Key.key("minecraft:block/destroy_stage_0") }),
  DESTROY_STAGE_1(lazy { Key.key("minecraft:block/destroy_stage_1") }),
  DESTROY_STAGE_2(lazy { Key.key("minecraft:block/destroy_stage_2") }),
  DESTROY_STAGE_3(lazy { Key.key("minecraft:block/destroy_stage_3") }),
  DESTROY_STAGE_4(lazy { Key.key("minecraft:block/destroy_stage_4") }),
  DESTROY_STAGE_5(lazy { Key.key("minecraft:block/destroy_stage_5") }),
  DESTROY_STAGE_6(lazy { Key.key("minecraft:block/destroy_stage_6") }),
  DESTROY_STAGE_7(lazy { Key.key("minecraft:block/destroy_stage_7") }),
  DESTROY_STAGE_8(lazy { Key.key("minecraft:block/destroy_stage_8") }),
  DESTROY_STAGE_9(lazy { Key.key("minecraft:block/destroy_stage_9") }),
  DETECTOR_RAIL(lazy { Key.key("minecraft:block/detector_rail") }),
  DETECTOR_RAIL_ON(lazy { Key.key("minecraft:block/detector_rail_on") }),
  DIAMOND_BLOCK(lazy { Key.key("minecraft:block/diamond_block") }),
  DIAMOND_ORE(lazy { Key.key("minecraft:block/diamond_ore") }),
  DIORITE(lazy { Key.key("minecraft:block/diorite") }),
  DIRT(lazy { Key.key("minecraft:block/dirt") }),
  DIRT_PATH_SIDE(lazy { Key.key("minecraft:block/dirt_path_side") }),
  DIRT_PATH_TOP(lazy { Key.key("minecraft:block/dirt_path_top") }),
  DISPENSER_FRONT(lazy { Key.key("minecraft:block/dispenser_front") }),
  DISPENSER_FRONT_VERTICAL(lazy { Key.key("minecraft:block/dispenser_front_vertical") }),
  DRAGON_EGG(lazy { Key.key("minecraft:block/dragon_egg") }),
  DRIED_KELP_BOTTOM(lazy { Key.key("minecraft:block/dried_kelp_bottom") }),
  DRIED_KELP_SIDE(lazy { Key.key("minecraft:block/dried_kelp_side") }),
  DRIED_KELP_TOP(lazy { Key.key("minecraft:block/dried_kelp_top") }),
  DRIPSTONE_BLOCK(lazy { Key.key("minecraft:block/dripstone_block") }),
  DROPPER_FRONT(lazy { Key.key("minecraft:block/dropper_front") }),
  DROPPER_FRONT_VERTICAL(lazy { Key.key("minecraft:block/dropper_front_vertical") }),
  EMERALD_BLOCK(lazy { Key.key("minecraft:block/emerald_block") }),
  EMERALD_ORE(lazy { Key.key("minecraft:block/emerald_ore") }),
  ENCHANTING_TABLE_BOTTOM(lazy { Key.key("minecraft:block/enchanting_table_bottom") }),
  ENCHANTING_TABLE_SIDE(lazy { Key.key("minecraft:block/enchanting_table_side") }),
  ENCHANTING_TABLE_TOP(lazy { Key.key("minecraft:block/enchanting_table_top") }),
  END_PORTAL_FRAME_EYE(lazy { Key.key("minecraft:block/end_portal_frame_eye") }),
  END_PORTAL_FRAME_SIDE(lazy { Key.key("minecraft:block/end_portal_frame_side") }),
  END_PORTAL_FRAME_TOP(lazy { Key.key("minecraft:block/end_portal_frame_top") }),
  END_ROD(lazy { Key.key("minecraft:block/end_rod") }),
  END_STONE(lazy { Key.key("minecraft:block/end_stone") }),
  END_STONE_BRICKS(lazy { Key.key("minecraft:block/end_stone_bricks") }),
  EXPOSED_CHISELED_COPPER(lazy { Key.key("minecraft:block/exposed_chiseled_copper") }),
  EXPOSED_COPPER(lazy { Key.key("minecraft:block/exposed_copper") }),
  EXPOSED_COPPER_BULB(lazy { Key.key("minecraft:block/exposed_copper_bulb") }),
  EXPOSED_COPPER_BULB_LIT(lazy { Key.key("minecraft:block/exposed_copper_bulb_lit") }),
  EXPOSED_COPPER_BULB_LIT_POWERED(lazy { Key.key("minecraft:block/exposed_copper_bulb_lit_powered")
      }),
  EXPOSED_COPPER_BULB_POWERED(lazy { Key.key("minecraft:block/exposed_copper_bulb_powered") }),
  EXPOSED_COPPER_DOOR_BOTTOM(lazy { Key.key("minecraft:block/exposed_copper_door_bottom") }),
  EXPOSED_COPPER_DOOR_TOP(lazy { Key.key("minecraft:block/exposed_copper_door_top") }),
  EXPOSED_COPPER_GRATE(lazy { Key.key("minecraft:block/exposed_copper_grate") }),
  EXPOSED_COPPER_TRAPDOOR(lazy { Key.key("minecraft:block/exposed_copper_trapdoor") }),
  EXPOSED_CUT_COPPER(lazy { Key.key("minecraft:block/exposed_cut_copper") }),
  FARMLAND(lazy { Key.key("minecraft:block/farmland") }),
  FARMLAND_MOIST(lazy { Key.key("minecraft:block/farmland_moist") }),
  FERN(lazy { Key.key("minecraft:block/fern") }),
  FIRE_CORAL(lazy { Key.key("minecraft:block/fire_coral") }),
  FIRE_CORAL_BLOCK(lazy { Key.key("minecraft:block/fire_coral_block") }),
  FIRE_CORAL_FAN(lazy { Key.key("minecraft:block/fire_coral_fan") }),
  FLETCHING_TABLE_FRONT(lazy { Key.key("minecraft:block/fletching_table_front") }),
  FLETCHING_TABLE_SIDE(lazy { Key.key("minecraft:block/fletching_table_side") }),
  FLETCHING_TABLE_TOP(lazy { Key.key("minecraft:block/fletching_table_top") }),
  FLOWERING_AZALEA_LEAVES(lazy { Key.key("minecraft:block/flowering_azalea_leaves") }),
  FLOWERING_AZALEA_SIDE(lazy { Key.key("minecraft:block/flowering_azalea_side") }),
  FLOWERING_AZALEA_TOP(lazy { Key.key("minecraft:block/flowering_azalea_top") }),
  FLOWER_POT(lazy { Key.key("minecraft:block/flower_pot") }),
  FROGSPAWN(lazy { Key.key("minecraft:block/frogspawn") }),
  FROSTED_ICE_0(lazy { Key.key("minecraft:block/frosted_ice_0") }),
  FROSTED_ICE_1(lazy { Key.key("minecraft:block/frosted_ice_1") }),
  FROSTED_ICE_2(lazy { Key.key("minecraft:block/frosted_ice_2") }),
  FROSTED_ICE_3(lazy { Key.key("minecraft:block/frosted_ice_3") }),
  FURNACE_FRONT(lazy { Key.key("minecraft:block/furnace_front") }),
  FURNACE_FRONT_ON(lazy { Key.key("minecraft:block/furnace_front_on") }),
  FURNACE_SIDE(lazy { Key.key("minecraft:block/furnace_side") }),
  FURNACE_TOP(lazy { Key.key("minecraft:block/furnace_top") }),
  GILDED_BLACKSTONE(lazy { Key.key("minecraft:block/gilded_blackstone") }),
  GLASS(lazy { Key.key("minecraft:block/glass") }),
  GLASS_PANE_TOP(lazy { Key.key("minecraft:block/glass_pane_top") }),
  GLOWSTONE(lazy { Key.key("minecraft:block/glowstone") }),
  GLOW_ITEM_FRAME(lazy { Key.key("minecraft:block/glow_item_frame") }),
  GLOW_LICHEN(lazy { Key.key("minecraft:block/glow_lichen") }),
  GOLD_BLOCK(lazy { Key.key("minecraft:block/gold_block") }),
  GOLD_ORE(lazy { Key.key("minecraft:block/gold_ore") }),
  GRANITE(lazy { Key.key("minecraft:block/granite") }),
  GRASS_BLOCK_SIDE(lazy { Key.key("minecraft:block/grass_block_side") }),
  GRASS_BLOCK_SIDE_OVERLAY(lazy { Key.key("minecraft:block/grass_block_side_overlay") }),
  GRASS_BLOCK_SNOW(lazy { Key.key("minecraft:block/grass_block_snow") }),
  GRASS_BLOCK_TOP(lazy { Key.key("minecraft:block/grass_block_top") }),
  GRAVEL(lazy { Key.key("minecraft:block/gravel") }),
  GRAY_CANDLE(lazy { Key.key("minecraft:block/gray_candle") }),
  GRAY_CANDLE_LIT(lazy { Key.key("minecraft:block/gray_candle_lit") }),
  GRAY_CONCRETE(lazy { Key.key("minecraft:block/gray_concrete") }),
  GRAY_CONCRETE_POWDER(lazy { Key.key("minecraft:block/gray_concrete_powder") }),
  GRAY_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/gray_glazed_terracotta") }),
  GRAY_SHULKER_BOX(lazy { Key.key("minecraft:block/gray_shulker_box") }),
  GRAY_STAINED_GLASS(lazy { Key.key("minecraft:block/gray_stained_glass") }),
  GRAY_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/gray_stained_glass_pane_top") }),
  GRAY_TERRACOTTA(lazy { Key.key("minecraft:block/gray_terracotta") }),
  GRAY_WOOL(lazy { Key.key("minecraft:block/gray_wool") }),
  GREEN_CANDLE(lazy { Key.key("minecraft:block/green_candle") }),
  GREEN_CANDLE_LIT(lazy { Key.key("minecraft:block/green_candle_lit") }),
  GREEN_CONCRETE(lazy { Key.key("minecraft:block/green_concrete") }),
  GREEN_CONCRETE_POWDER(lazy { Key.key("minecraft:block/green_concrete_powder") }),
  GREEN_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/green_glazed_terracotta") }),
  GREEN_SHULKER_BOX(lazy { Key.key("minecraft:block/green_shulker_box") }),
  GREEN_STAINED_GLASS(lazy { Key.key("minecraft:block/green_stained_glass") }),
  GREEN_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/green_stained_glass_pane_top") }),
  GREEN_TERRACOTTA(lazy { Key.key("minecraft:block/green_terracotta") }),
  GREEN_WOOL(lazy { Key.key("minecraft:block/green_wool") }),
  GRINDSTONE_PIVOT(lazy { Key.key("minecraft:block/grindstone_pivot") }),
  GRINDSTONE_ROUND(lazy { Key.key("minecraft:block/grindstone_round") }),
  GRINDSTONE_SIDE(lazy { Key.key("minecraft:block/grindstone_side") }),
  HANGING_ROOTS(lazy { Key.key("minecraft:block/hanging_roots") }),
  HAY_BLOCK_SIDE(lazy { Key.key("minecraft:block/hay_block_side") }),
  HAY_BLOCK_TOP(lazy { Key.key("minecraft:block/hay_block_top") }),
  HEAVY_CORE(lazy { Key.key("minecraft:block/heavy_core") }),
  HONEYCOMB_BLOCK(lazy { Key.key("minecraft:block/honeycomb_block") }),
  HONEY_BLOCK_BOTTOM(lazy { Key.key("minecraft:block/honey_block_bottom") }),
  HONEY_BLOCK_SIDE(lazy { Key.key("minecraft:block/honey_block_side") }),
  HONEY_BLOCK_TOP(lazy { Key.key("minecraft:block/honey_block_top") }),
  HOPPER_INSIDE(lazy { Key.key("minecraft:block/hopper_inside") }),
  HOPPER_OUTSIDE(lazy { Key.key("minecraft:block/hopper_outside") }),
  HOPPER_TOP(lazy { Key.key("minecraft:block/hopper_top") }),
  HORN_CORAL(lazy { Key.key("minecraft:block/horn_coral") }),
  HORN_CORAL_BLOCK(lazy { Key.key("minecraft:block/horn_coral_block") }),
  HORN_CORAL_FAN(lazy { Key.key("minecraft:block/horn_coral_fan") }),
  ICE(lazy { Key.key("minecraft:block/ice") }),
  IRON_BARS(lazy { Key.key("minecraft:block/iron_bars") }),
  IRON_BLOCK(lazy { Key.key("minecraft:block/iron_block") }),
  IRON_DOOR_BOTTOM(lazy { Key.key("minecraft:block/iron_door_bottom") }),
  IRON_DOOR_TOP(lazy { Key.key("minecraft:block/iron_door_top") }),
  IRON_ORE(lazy { Key.key("minecraft:block/iron_ore") }),
  IRON_TRAPDOOR(lazy { Key.key("minecraft:block/iron_trapdoor") }),
  ITEM_FRAME(lazy { Key.key("minecraft:block/item_frame") }),
  JACK_O_LANTERN(lazy { Key.key("minecraft:block/jack_o_lantern") }),
  JIGSAW_BOTTOM(lazy { Key.key("minecraft:block/jigsaw_bottom") }),
  JIGSAW_LOCK(lazy { Key.key("minecraft:block/jigsaw_lock") }),
  JIGSAW_SIDE(lazy { Key.key("minecraft:block/jigsaw_side") }),
  JIGSAW_TOP(lazy { Key.key("minecraft:block/jigsaw_top") }),
  JUKEBOX_SIDE(lazy { Key.key("minecraft:block/jukebox_side") }),
  JUKEBOX_TOP(lazy { Key.key("minecraft:block/jukebox_top") }),
  JUNGLE_DOOR_BOTTOM(lazy { Key.key("minecraft:block/jungle_door_bottom") }),
  JUNGLE_DOOR_TOP(lazy { Key.key("minecraft:block/jungle_door_top") }),
  JUNGLE_LEAVES(lazy { Key.key("minecraft:block/jungle_leaves") }),
  JUNGLE_LOG(lazy { Key.key("minecraft:block/jungle_log") }),
  JUNGLE_LOG_TOP(lazy { Key.key("minecraft:block/jungle_log_top") }),
  JUNGLE_PLANKS(lazy { Key.key("minecraft:block/jungle_planks") }),
  JUNGLE_SAPLING(lazy { Key.key("minecraft:block/jungle_sapling") }),
  JUNGLE_TRAPDOOR(lazy { Key.key("minecraft:block/jungle_trapdoor") }),
  LADDER(lazy { Key.key("minecraft:block/ladder") }),
  LAPIS_BLOCK(lazy { Key.key("minecraft:block/lapis_block") }),
  LAPIS_ORE(lazy { Key.key("minecraft:block/lapis_ore") }),
  LARGE_AMETHYST_BUD(lazy { Key.key("minecraft:block/large_amethyst_bud") }),
  LARGE_FERN_BOTTOM(lazy { Key.key("minecraft:block/large_fern_bottom") }),
  LARGE_FERN_TOP(lazy { Key.key("minecraft:block/large_fern_top") }),
  LECTERN_BASE(lazy { Key.key("minecraft:block/lectern_base") }),
  LECTERN_FRONT(lazy { Key.key("minecraft:block/lectern_front") }),
  LECTERN_SIDES(lazy { Key.key("minecraft:block/lectern_sides") }),
  LECTERN_TOP(lazy { Key.key("minecraft:block/lectern_top") }),
  LEVER(lazy { Key.key("minecraft:block/lever") }),
  LIGHTNING_ROD(lazy { Key.key("minecraft:block/lightning_rod") }),
  LIGHTNING_ROD_ON(lazy { Key.key("minecraft:block/lightning_rod_on") }),
  LIGHT_BLUE_CANDLE(lazy { Key.key("minecraft:block/light_blue_candle") }),
  LIGHT_BLUE_CANDLE_LIT(lazy { Key.key("minecraft:block/light_blue_candle_lit") }),
  LIGHT_BLUE_CONCRETE(lazy { Key.key("minecraft:block/light_blue_concrete") }),
  LIGHT_BLUE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/light_blue_concrete_powder") }),
  LIGHT_BLUE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/light_blue_glazed_terracotta") }),
  LIGHT_BLUE_SHULKER_BOX(lazy { Key.key("minecraft:block/light_blue_shulker_box") }),
  LIGHT_BLUE_STAINED_GLASS(lazy { Key.key("minecraft:block/light_blue_stained_glass") }),
  LIGHT_BLUE_STAINED_GLASS_PANE_TOP(lazy {
      Key.key("minecraft:block/light_blue_stained_glass_pane_top") }),
  LIGHT_BLUE_TERRACOTTA(lazy { Key.key("minecraft:block/light_blue_terracotta") }),
  LIGHT_BLUE_WOOL(lazy { Key.key("minecraft:block/light_blue_wool") }),
  LIGHT_GRAY_CANDLE(lazy { Key.key("minecraft:block/light_gray_candle") }),
  LIGHT_GRAY_CANDLE_LIT(lazy { Key.key("minecraft:block/light_gray_candle_lit") }),
  LIGHT_GRAY_CONCRETE(lazy { Key.key("minecraft:block/light_gray_concrete") }),
  LIGHT_GRAY_CONCRETE_POWDER(lazy { Key.key("minecraft:block/light_gray_concrete_powder") }),
  LIGHT_GRAY_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/light_gray_glazed_terracotta") }),
  LIGHT_GRAY_SHULKER_BOX(lazy { Key.key("minecraft:block/light_gray_shulker_box") }),
  LIGHT_GRAY_STAINED_GLASS(lazy { Key.key("minecraft:block/light_gray_stained_glass") }),
  LIGHT_GRAY_STAINED_GLASS_PANE_TOP(lazy {
      Key.key("minecraft:block/light_gray_stained_glass_pane_top") }),
  LIGHT_GRAY_TERRACOTTA(lazy { Key.key("minecraft:block/light_gray_terracotta") }),
  LIGHT_GRAY_WOOL(lazy { Key.key("minecraft:block/light_gray_wool") }),
  LILAC_BOTTOM(lazy { Key.key("minecraft:block/lilac_bottom") }),
  LILAC_TOP(lazy { Key.key("minecraft:block/lilac_top") }),
  LILY_OF_THE_VALLEY(lazy { Key.key("minecraft:block/lily_of_the_valley") }),
  LILY_PAD(lazy { Key.key("minecraft:block/lily_pad") }),
  LIME_CANDLE(lazy { Key.key("minecraft:block/lime_candle") }),
  LIME_CANDLE_LIT(lazy { Key.key("minecraft:block/lime_candle_lit") }),
  LIME_CONCRETE(lazy { Key.key("minecraft:block/lime_concrete") }),
  LIME_CONCRETE_POWDER(lazy { Key.key("minecraft:block/lime_concrete_powder") }),
  LIME_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/lime_glazed_terracotta") }),
  LIME_SHULKER_BOX(lazy { Key.key("minecraft:block/lime_shulker_box") }),
  LIME_STAINED_GLASS(lazy { Key.key("minecraft:block/lime_stained_glass") }),
  LIME_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/lime_stained_glass_pane_top") }),
  LIME_TERRACOTTA(lazy { Key.key("minecraft:block/lime_terracotta") }),
  LIME_WOOL(lazy { Key.key("minecraft:block/lime_wool") }),
  LODESTONE_SIDE(lazy { Key.key("minecraft:block/lodestone_side") }),
  LODESTONE_TOP(lazy { Key.key("minecraft:block/lodestone_top") }),
  LOOM_BOTTOM(lazy { Key.key("minecraft:block/loom_bottom") }),
  LOOM_FRONT(lazy { Key.key("minecraft:block/loom_front") }),
  LOOM_SIDE(lazy { Key.key("minecraft:block/loom_side") }),
  LOOM_TOP(lazy { Key.key("minecraft:block/loom_top") }),
  MAGENTA_CANDLE(lazy { Key.key("minecraft:block/magenta_candle") }),
  MAGENTA_CANDLE_LIT(lazy { Key.key("minecraft:block/magenta_candle_lit") }),
  MAGENTA_CONCRETE(lazy { Key.key("minecraft:block/magenta_concrete") }),
  MAGENTA_CONCRETE_POWDER(lazy { Key.key("minecraft:block/magenta_concrete_powder") }),
  MAGENTA_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/magenta_glazed_terracotta") }),
  MAGENTA_SHULKER_BOX(lazy { Key.key("minecraft:block/magenta_shulker_box") }),
  MAGENTA_STAINED_GLASS(lazy { Key.key("minecraft:block/magenta_stained_glass") }),
  MAGENTA_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/magenta_stained_glass_pane_top")
      }),
  MAGENTA_TERRACOTTA(lazy { Key.key("minecraft:block/magenta_terracotta") }),
  MAGENTA_WOOL(lazy { Key.key("minecraft:block/magenta_wool") }),
  MANGROVE_DOOR_BOTTOM(lazy { Key.key("minecraft:block/mangrove_door_bottom") }),
  MANGROVE_DOOR_TOP(lazy { Key.key("minecraft:block/mangrove_door_top") }),
  MANGROVE_LEAVES(lazy { Key.key("minecraft:block/mangrove_leaves") }),
  MANGROVE_LOG(lazy { Key.key("minecraft:block/mangrove_log") }),
  MANGROVE_LOG_TOP(lazy { Key.key("minecraft:block/mangrove_log_top") }),
  MANGROVE_PLANKS(lazy { Key.key("minecraft:block/mangrove_planks") }),
  MANGROVE_PROPAGULE(lazy { Key.key("minecraft:block/mangrove_propagule") }),
  MANGROVE_PROPAGULE_HANGING(lazy { Key.key("minecraft:block/mangrove_propagule_hanging") }),
  MANGROVE_ROOTS_SIDE(lazy { Key.key("minecraft:block/mangrove_roots_side") }),
  MANGROVE_ROOTS_TOP(lazy { Key.key("minecraft:block/mangrove_roots_top") }),
  MANGROVE_TRAPDOOR(lazy { Key.key("minecraft:block/mangrove_trapdoor") }),
  MEDIUM_AMETHYST_BUD(lazy { Key.key("minecraft:block/medium_amethyst_bud") }),
  MELON_SIDE(lazy { Key.key("minecraft:block/melon_side") }),
  MELON_STEM(lazy { Key.key("minecraft:block/melon_stem") }),
  MELON_TOP(lazy { Key.key("minecraft:block/melon_top") }),
  MOSSY_COBBLESTONE(lazy { Key.key("minecraft:block/mossy_cobblestone") }),
  MOSSY_STONE_BRICKS(lazy { Key.key("minecraft:block/mossy_stone_bricks") }),
  MOSS_BLOCK(lazy { Key.key("minecraft:block/moss_block") }),
  MUD(lazy { Key.key("minecraft:block/mud") }),
  MUDDY_MANGROVE_ROOTS_SIDE(lazy { Key.key("minecraft:block/muddy_mangrove_roots_side") }),
  MUDDY_MANGROVE_ROOTS_TOP(lazy { Key.key("minecraft:block/muddy_mangrove_roots_top") }),
  MUD_BRICKS(lazy { Key.key("minecraft:block/mud_bricks") }),
  MUSHROOM_BLOCK_INSIDE(lazy { Key.key("minecraft:block/mushroom_block_inside") }),
  MUSHROOM_STEM(lazy { Key.key("minecraft:block/mushroom_stem") }),
  MYCELIUM_SIDE(lazy { Key.key("minecraft:block/mycelium_side") }),
  MYCELIUM_TOP(lazy { Key.key("minecraft:block/mycelium_top") }),
  NETHERITE_BLOCK(lazy { Key.key("minecraft:block/netherite_block") }),
  NETHERRACK(lazy { Key.key("minecraft:block/netherrack") }),
  NETHER_BRICKS(lazy { Key.key("minecraft:block/nether_bricks") }),
  NETHER_GOLD_ORE(lazy { Key.key("minecraft:block/nether_gold_ore") }),
  NETHER_QUARTZ_ORE(lazy { Key.key("minecraft:block/nether_quartz_ore") }),
  NETHER_SPROUTS(lazy { Key.key("minecraft:block/nether_sprouts") }),
  NETHER_WART_BLOCK(lazy { Key.key("minecraft:block/nether_wart_block") }),
  NETHER_WART_STAGE0(lazy { Key.key("minecraft:block/nether_wart_stage0") }),
  NETHER_WART_STAGE1(lazy { Key.key("minecraft:block/nether_wart_stage1") }),
  NETHER_WART_STAGE2(lazy { Key.key("minecraft:block/nether_wart_stage2") }),
  NOTE_BLOCK(lazy { Key.key("minecraft:block/note_block") }),
  OAK_DOOR_BOTTOM(lazy { Key.key("minecraft:block/oak_door_bottom") }),
  OAK_DOOR_TOP(lazy { Key.key("minecraft:block/oak_door_top") }),
  OAK_LEAVES(lazy { Key.key("minecraft:block/oak_leaves") }),
  OAK_LOG(lazy { Key.key("minecraft:block/oak_log") }),
  OAK_LOG_TOP(lazy { Key.key("minecraft:block/oak_log_top") }),
  OAK_PLANKS(lazy { Key.key("minecraft:block/oak_planks") }),
  OAK_SAPLING(lazy { Key.key("minecraft:block/oak_sapling") }),
  OAK_TRAPDOOR(lazy { Key.key("minecraft:block/oak_trapdoor") }),
  OBSERVER_BACK(lazy { Key.key("minecraft:block/observer_back") }),
  OBSERVER_BACK_ON(lazy { Key.key("minecraft:block/observer_back_on") }),
  OBSERVER_FRONT(lazy { Key.key("minecraft:block/observer_front") }),
  OBSERVER_SIDE(lazy { Key.key("minecraft:block/observer_side") }),
  OBSERVER_TOP(lazy { Key.key("minecraft:block/observer_top") }),
  OBSIDIAN(lazy { Key.key("minecraft:block/obsidian") }),
  OCHRE_FROGLIGHT_SIDE(lazy { Key.key("minecraft:block/ochre_froglight_side") }),
  OCHRE_FROGLIGHT_TOP(lazy { Key.key("minecraft:block/ochre_froglight_top") }),
  ORANGE_CANDLE(lazy { Key.key("minecraft:block/orange_candle") }),
  ORANGE_CANDLE_LIT(lazy { Key.key("minecraft:block/orange_candle_lit") }),
  ORANGE_CONCRETE(lazy { Key.key("minecraft:block/orange_concrete") }),
  ORANGE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/orange_concrete_powder") }),
  ORANGE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/orange_glazed_terracotta") }),
  ORANGE_SHULKER_BOX(lazy { Key.key("minecraft:block/orange_shulker_box") }),
  ORANGE_STAINED_GLASS(lazy { Key.key("minecraft:block/orange_stained_glass") }),
  ORANGE_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/orange_stained_glass_pane_top") }),
  ORANGE_TERRACOTTA(lazy { Key.key("minecraft:block/orange_terracotta") }),
  ORANGE_TULIP(lazy { Key.key("minecraft:block/orange_tulip") }),
  ORANGE_WOOL(lazy { Key.key("minecraft:block/orange_wool") }),
  OXEYE_DAISY(lazy { Key.key("minecraft:block/oxeye_daisy") }),
  OXIDIZED_CHISELED_COPPER(lazy { Key.key("minecraft:block/oxidized_chiseled_copper") }),
  OXIDIZED_COPPER(lazy { Key.key("minecraft:block/oxidized_copper") }),
  OXIDIZED_COPPER_BULB(lazy { Key.key("minecraft:block/oxidized_copper_bulb") }),
  OXIDIZED_COPPER_BULB_LIT(lazy { Key.key("minecraft:block/oxidized_copper_bulb_lit") }),
  OXIDIZED_COPPER_BULB_LIT_POWERED(lazy {
      Key.key("minecraft:block/oxidized_copper_bulb_lit_powered") }),
  OXIDIZED_COPPER_BULB_POWERED(lazy { Key.key("minecraft:block/oxidized_copper_bulb_powered") }),
  OXIDIZED_COPPER_DOOR_BOTTOM(lazy { Key.key("minecraft:block/oxidized_copper_door_bottom") }),
  OXIDIZED_COPPER_DOOR_TOP(lazy { Key.key("minecraft:block/oxidized_copper_door_top") }),
  OXIDIZED_COPPER_GRATE(lazy { Key.key("minecraft:block/oxidized_copper_grate") }),
  OXIDIZED_COPPER_TRAPDOOR(lazy { Key.key("minecraft:block/oxidized_copper_trapdoor") }),
  OXIDIZED_CUT_COPPER(lazy { Key.key("minecraft:block/oxidized_cut_copper") }),
  PACKED_ICE(lazy { Key.key("minecraft:block/packed_ice") }),
  PACKED_MUD(lazy { Key.key("minecraft:block/packed_mud") }),
  PEARLESCENT_FROGLIGHT_SIDE(lazy { Key.key("minecraft:block/pearlescent_froglight_side") }),
  PEARLESCENT_FROGLIGHT_TOP(lazy { Key.key("minecraft:block/pearlescent_froglight_top") }),
  PEONY_BOTTOM(lazy { Key.key("minecraft:block/peony_bottom") }),
  PEONY_TOP(lazy { Key.key("minecraft:block/peony_top") }),
  PINK_CANDLE(lazy { Key.key("minecraft:block/pink_candle") }),
  PINK_CANDLE_LIT(lazy { Key.key("minecraft:block/pink_candle_lit") }),
  PINK_CONCRETE(lazy { Key.key("minecraft:block/pink_concrete") }),
  PINK_CONCRETE_POWDER(lazy { Key.key("minecraft:block/pink_concrete_powder") }),
  PINK_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/pink_glazed_terracotta") }),
  PINK_PETALS(lazy { Key.key("minecraft:block/pink_petals") }),
  PINK_PETALS_STEM(lazy { Key.key("minecraft:block/pink_petals_stem") }),
  PINK_SHULKER_BOX(lazy { Key.key("minecraft:block/pink_shulker_box") }),
  PINK_STAINED_GLASS(lazy { Key.key("minecraft:block/pink_stained_glass") }),
  PINK_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/pink_stained_glass_pane_top") }),
  PINK_TERRACOTTA(lazy { Key.key("minecraft:block/pink_terracotta") }),
  PINK_TULIP(lazy { Key.key("minecraft:block/pink_tulip") }),
  PINK_WOOL(lazy { Key.key("minecraft:block/pink_wool") }),
  PISTON_BOTTOM(lazy { Key.key("minecraft:block/piston_bottom") }),
  PISTON_INNER(lazy { Key.key("minecraft:block/piston_inner") }),
  PISTON_SIDE(lazy { Key.key("minecraft:block/piston_side") }),
  PISTON_TOP(lazy { Key.key("minecraft:block/piston_top") }),
  PISTON_TOP_STICKY(lazy { Key.key("minecraft:block/piston_top_sticky") }),
  PITCHER_CROP_BOTTOM(lazy { Key.key("minecraft:block/pitcher_crop_bottom") }),
  PITCHER_CROP_BOTTOM_STAGE_1(lazy { Key.key("minecraft:block/pitcher_crop_bottom_stage_1") }),
  PITCHER_CROP_BOTTOM_STAGE_2(lazy { Key.key("minecraft:block/pitcher_crop_bottom_stage_2") }),
  PITCHER_CROP_BOTTOM_STAGE_3(lazy { Key.key("minecraft:block/pitcher_crop_bottom_stage_3") }),
  PITCHER_CROP_BOTTOM_STAGE_4(lazy { Key.key("minecraft:block/pitcher_crop_bottom_stage_4") }),
  PITCHER_CROP_SIDE(lazy { Key.key("minecraft:block/pitcher_crop_side") }),
  PITCHER_CROP_TOP(lazy { Key.key("minecraft:block/pitcher_crop_top") }),
  PITCHER_CROP_TOP_STAGE_3(lazy { Key.key("minecraft:block/pitcher_crop_top_stage_3") }),
  PITCHER_CROP_TOP_STAGE_4(lazy { Key.key("minecraft:block/pitcher_crop_top_stage_4") }),
  PODZOL_SIDE(lazy { Key.key("minecraft:block/podzol_side") }),
  PODZOL_TOP(lazy { Key.key("minecraft:block/podzol_top") }),
  POINTED_DRIPSTONE_DOWN_BASE(lazy { Key.key("minecraft:block/pointed_dripstone_down_base") }),
  POINTED_DRIPSTONE_DOWN_FRUSTUM(lazy { Key.key("minecraft:block/pointed_dripstone_down_frustum")
      }),
  POINTED_DRIPSTONE_DOWN_MIDDLE(lazy { Key.key("minecraft:block/pointed_dripstone_down_middle") }),
  POINTED_DRIPSTONE_DOWN_TIP(lazy { Key.key("minecraft:block/pointed_dripstone_down_tip") }),
  POINTED_DRIPSTONE_DOWN_TIP_MERGE(lazy {
      Key.key("minecraft:block/pointed_dripstone_down_tip_merge") }),
  POINTED_DRIPSTONE_UP_BASE(lazy { Key.key("minecraft:block/pointed_dripstone_up_base") }),
  POINTED_DRIPSTONE_UP_FRUSTUM(lazy { Key.key("minecraft:block/pointed_dripstone_up_frustum") }),
  POINTED_DRIPSTONE_UP_MIDDLE(lazy { Key.key("minecraft:block/pointed_dripstone_up_middle") }),
  POINTED_DRIPSTONE_UP_TIP(lazy { Key.key("minecraft:block/pointed_dripstone_up_tip") }),
  POINTED_DRIPSTONE_UP_TIP_MERGE(lazy { Key.key("minecraft:block/pointed_dripstone_up_tip_merge")
      }),
  POLISHED_ANDESITE(lazy { Key.key("minecraft:block/polished_andesite") }),
  POLISHED_BASALT_SIDE(lazy { Key.key("minecraft:block/polished_basalt_side") }),
  POLISHED_BASALT_TOP(lazy { Key.key("minecraft:block/polished_basalt_top") }),
  POLISHED_BLACKSTONE(lazy { Key.key("minecraft:block/polished_blackstone") }),
  POLISHED_BLACKSTONE_BRICKS(lazy { Key.key("minecraft:block/polished_blackstone_bricks") }),
  POLISHED_DEEPSLATE(lazy { Key.key("minecraft:block/polished_deepslate") }),
  POLISHED_DIORITE(lazy { Key.key("minecraft:block/polished_diorite") }),
  POLISHED_GRANITE(lazy { Key.key("minecraft:block/polished_granite") }),
  POLISHED_TUFF(lazy { Key.key("minecraft:block/polished_tuff") }),
  POPPY(lazy { Key.key("minecraft:block/poppy") }),
  POTATOES_STAGE0(lazy { Key.key("minecraft:block/potatoes_stage0") }),
  POTATOES_STAGE1(lazy { Key.key("minecraft:block/potatoes_stage1") }),
  POTATOES_STAGE2(lazy { Key.key("minecraft:block/potatoes_stage2") }),
  POTATOES_STAGE3(lazy { Key.key("minecraft:block/potatoes_stage3") }),
  POTTED_AZALEA_BUSH_PLANT(lazy { Key.key("minecraft:block/potted_azalea_bush_plant") }),
  POTTED_AZALEA_BUSH_SIDE(lazy { Key.key("minecraft:block/potted_azalea_bush_side") }),
  POTTED_AZALEA_BUSH_TOP(lazy { Key.key("minecraft:block/potted_azalea_bush_top") }),
  POTTED_FLOWERING_AZALEA_BUSH_PLANT(lazy {
      Key.key("minecraft:block/potted_flowering_azalea_bush_plant") }),
  POTTED_FLOWERING_AZALEA_BUSH_SIDE(lazy {
      Key.key("minecraft:block/potted_flowering_azalea_bush_side") }),
  POTTED_FLOWERING_AZALEA_BUSH_TOP(lazy {
      Key.key("minecraft:block/potted_flowering_azalea_bush_top") }),
  POWDER_SNOW(lazy { Key.key("minecraft:block/powder_snow") }),
  POWERED_RAIL(lazy { Key.key("minecraft:block/powered_rail") }),
  POWERED_RAIL_ON(lazy { Key.key("minecraft:block/powered_rail_on") }),
  PRISMARINE_BRICKS(lazy { Key.key("minecraft:block/prismarine_bricks") }),
  PUMPKIN_SIDE(lazy { Key.key("minecraft:block/pumpkin_side") }),
  PUMPKIN_STEM(lazy { Key.key("minecraft:block/pumpkin_stem") }),
  PUMPKIN_TOP(lazy { Key.key("minecraft:block/pumpkin_top") }),
  PURPLE_CANDLE(lazy { Key.key("minecraft:block/purple_candle") }),
  PURPLE_CANDLE_LIT(lazy { Key.key("minecraft:block/purple_candle_lit") }),
  PURPLE_CONCRETE(lazy { Key.key("minecraft:block/purple_concrete") }),
  PURPLE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/purple_concrete_powder") }),
  PURPLE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/purple_glazed_terracotta") }),
  PURPLE_SHULKER_BOX(lazy { Key.key("minecraft:block/purple_shulker_box") }),
  PURPLE_STAINED_GLASS(lazy { Key.key("minecraft:block/purple_stained_glass") }),
  PURPLE_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/purple_stained_glass_pane_top") }),
  PURPLE_TERRACOTTA(lazy { Key.key("minecraft:block/purple_terracotta") }),
  PURPLE_WOOL(lazy { Key.key("minecraft:block/purple_wool") }),
  PURPUR_BLOCK(lazy { Key.key("minecraft:block/purpur_block") }),
  PURPUR_PILLAR(lazy { Key.key("minecraft:block/purpur_pillar") }),
  PURPUR_PILLAR_TOP(lazy { Key.key("minecraft:block/purpur_pillar_top") }),
  QUARTZ_BLOCK_BOTTOM(lazy { Key.key("minecraft:block/quartz_block_bottom") }),
  QUARTZ_BLOCK_SIDE(lazy { Key.key("minecraft:block/quartz_block_side") }),
  QUARTZ_BLOCK_TOP(lazy { Key.key("minecraft:block/quartz_block_top") }),
  QUARTZ_BRICKS(lazy { Key.key("minecraft:block/quartz_bricks") }),
  QUARTZ_PILLAR(lazy { Key.key("minecraft:block/quartz_pillar") }),
  QUARTZ_PILLAR_TOP(lazy { Key.key("minecraft:block/quartz_pillar_top") }),
  RAIL(lazy { Key.key("minecraft:block/rail") }),
  RAIL_CORNER(lazy { Key.key("minecraft:block/rail_corner") }),
  RAW_COPPER_BLOCK(lazy { Key.key("minecraft:block/raw_copper_block") }),
  RAW_GOLD_BLOCK(lazy { Key.key("minecraft:block/raw_gold_block") }),
  RAW_IRON_BLOCK(lazy { Key.key("minecraft:block/raw_iron_block") }),
  REDSTONE_BLOCK(lazy { Key.key("minecraft:block/redstone_block") }),
  REDSTONE_DUST_DOT(lazy { Key.key("minecraft:block/redstone_dust_dot") }),
  REDSTONE_DUST_LINE0(lazy { Key.key("minecraft:block/redstone_dust_line0") }),
  REDSTONE_DUST_LINE1(lazy { Key.key("minecraft:block/redstone_dust_line1") }),
  REDSTONE_DUST_OVERLAY(lazy { Key.key("minecraft:block/redstone_dust_overlay") }),
  REDSTONE_LAMP(lazy { Key.key("minecraft:block/redstone_lamp") }),
  REDSTONE_LAMP_ON(lazy { Key.key("minecraft:block/redstone_lamp_on") }),
  REDSTONE_ORE(lazy { Key.key("minecraft:block/redstone_ore") }),
  REDSTONE_TORCH(lazy { Key.key("minecraft:block/redstone_torch") }),
  REDSTONE_TORCH_OFF(lazy { Key.key("minecraft:block/redstone_torch_off") }),
  RED_CANDLE(lazy { Key.key("minecraft:block/red_candle") }),
  RED_CANDLE_LIT(lazy { Key.key("minecraft:block/red_candle_lit") }),
  RED_CONCRETE(lazy { Key.key("minecraft:block/red_concrete") }),
  RED_CONCRETE_POWDER(lazy { Key.key("minecraft:block/red_concrete_powder") }),
  RED_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/red_glazed_terracotta") }),
  RED_MUSHROOM(lazy { Key.key("minecraft:block/red_mushroom") }),
  RED_MUSHROOM_BLOCK(lazy { Key.key("minecraft:block/red_mushroom_block") }),
  RED_NETHER_BRICKS(lazy { Key.key("minecraft:block/red_nether_bricks") }),
  RED_SAND(lazy { Key.key("minecraft:block/red_sand") }),
  RED_SANDSTONE(lazy { Key.key("minecraft:block/red_sandstone") }),
  RED_SANDSTONE_BOTTOM(lazy { Key.key("minecraft:block/red_sandstone_bottom") }),
  RED_SANDSTONE_TOP(lazy { Key.key("minecraft:block/red_sandstone_top") }),
  RED_SHULKER_BOX(lazy { Key.key("minecraft:block/red_shulker_box") }),
  RED_STAINED_GLASS(lazy { Key.key("minecraft:block/red_stained_glass") }),
  RED_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/red_stained_glass_pane_top") }),
  RED_TERRACOTTA(lazy { Key.key("minecraft:block/red_terracotta") }),
  RED_TULIP(lazy { Key.key("minecraft:block/red_tulip") }),
  RED_WOOL(lazy { Key.key("minecraft:block/red_wool") }),
  REINFORCED_DEEPSLATE_BOTTOM(lazy { Key.key("minecraft:block/reinforced_deepslate_bottom") }),
  REINFORCED_DEEPSLATE_SIDE(lazy { Key.key("minecraft:block/reinforced_deepslate_side") }),
  REINFORCED_DEEPSLATE_TOP(lazy { Key.key("minecraft:block/reinforced_deepslate_top") }),
  REPEATER(lazy { Key.key("minecraft:block/repeater") }),
  REPEATER_ON(lazy { Key.key("minecraft:block/repeater_on") }),
  RESPAWN_ANCHOR_BOTTOM(lazy { Key.key("minecraft:block/respawn_anchor_bottom") }),
  RESPAWN_ANCHOR_SIDE0(lazy { Key.key("minecraft:block/respawn_anchor_side0") }),
  RESPAWN_ANCHOR_SIDE1(lazy { Key.key("minecraft:block/respawn_anchor_side1") }),
  RESPAWN_ANCHOR_SIDE2(lazy { Key.key("minecraft:block/respawn_anchor_side2") }),
  RESPAWN_ANCHOR_SIDE3(lazy { Key.key("minecraft:block/respawn_anchor_side3") }),
  RESPAWN_ANCHOR_SIDE4(lazy { Key.key("minecraft:block/respawn_anchor_side4") }),
  RESPAWN_ANCHOR_TOP_OFF(lazy { Key.key("minecraft:block/respawn_anchor_top_off") }),
  ROOTED_DIRT(lazy { Key.key("minecraft:block/rooted_dirt") }),
  ROSE_BUSH_BOTTOM(lazy { Key.key("minecraft:block/rose_bush_bottom") }),
  ROSE_BUSH_TOP(lazy { Key.key("minecraft:block/rose_bush_top") }),
  SAND(lazy { Key.key("minecraft:block/sand") }),
  SANDSTONE(lazy { Key.key("minecraft:block/sandstone") }),
  SANDSTONE_BOTTOM(lazy { Key.key("minecraft:block/sandstone_bottom") }),
  SANDSTONE_TOP(lazy { Key.key("minecraft:block/sandstone_top") }),
  SCAFFOLDING_BOTTOM(lazy { Key.key("minecraft:block/scaffolding_bottom") }),
  SCAFFOLDING_SIDE(lazy { Key.key("minecraft:block/scaffolding_side") }),
  SCAFFOLDING_TOP(lazy { Key.key("minecraft:block/scaffolding_top") }),
  SCULK_CATALYST_BOTTOM(lazy { Key.key("minecraft:block/sculk_catalyst_bottom") }),
  SCULK_CATALYST_SIDE(lazy { Key.key("minecraft:block/sculk_catalyst_side") }),
  SCULK_CATALYST_TOP(lazy { Key.key("minecraft:block/sculk_catalyst_top") }),
  SCULK_SENSOR_BOTTOM(lazy { Key.key("minecraft:block/sculk_sensor_bottom") }),
  SCULK_SENSOR_SIDE(lazy { Key.key("minecraft:block/sculk_sensor_side") }),
  SCULK_SENSOR_TOP(lazy { Key.key("minecraft:block/sculk_sensor_top") }),
  SCULK_SHRIEKER_BOTTOM(lazy { Key.key("minecraft:block/sculk_shrieker_bottom") }),
  SCULK_SHRIEKER_SIDE(lazy { Key.key("minecraft:block/sculk_shrieker_side") }),
  SCULK_SHRIEKER_TOP(lazy { Key.key("minecraft:block/sculk_shrieker_top") }),
  SEA_PICKLE(lazy { Key.key("minecraft:block/sea_pickle") }),
  SHORT_GRASS(lazy { Key.key("minecraft:block/short_grass") }),
  SHROOMLIGHT(lazy { Key.key("minecraft:block/shroomlight") }),
  SHULKER_BOX(lazy { Key.key("minecraft:block/shulker_box") }),
  SLIME_BLOCK(lazy { Key.key("minecraft:block/slime_block") }),
  SMALL_AMETHYST_BUD(lazy { Key.key("minecraft:block/small_amethyst_bud") }),
  SMALL_DRIPLEAF_SIDE(lazy { Key.key("minecraft:block/small_dripleaf_side") }),
  SMALL_DRIPLEAF_STEM_BOTTOM(lazy { Key.key("minecraft:block/small_dripleaf_stem_bottom") }),
  SMALL_DRIPLEAF_STEM_TOP(lazy { Key.key("minecraft:block/small_dripleaf_stem_top") }),
  SMALL_DRIPLEAF_TOP(lazy { Key.key("minecraft:block/small_dripleaf_top") }),
  SMITHING_TABLE_BOTTOM(lazy { Key.key("minecraft:block/smithing_table_bottom") }),
  SMITHING_TABLE_FRONT(lazy { Key.key("minecraft:block/smithing_table_front") }),
  SMITHING_TABLE_SIDE(lazy { Key.key("minecraft:block/smithing_table_side") }),
  SMITHING_TABLE_TOP(lazy { Key.key("minecraft:block/smithing_table_top") }),
  SMOKER_BOTTOM(lazy { Key.key("minecraft:block/smoker_bottom") }),
  SMOKER_FRONT(lazy { Key.key("minecraft:block/smoker_front") }),
  SMOKER_SIDE(lazy { Key.key("minecraft:block/smoker_side") }),
  SMOKER_TOP(lazy { Key.key("minecraft:block/smoker_top") }),
  SMOOTH_BASALT(lazy { Key.key("minecraft:block/smooth_basalt") }),
  SMOOTH_STONE(lazy { Key.key("minecraft:block/smooth_stone") }),
  SMOOTH_STONE_SLAB_SIDE(lazy { Key.key("minecraft:block/smooth_stone_slab_side") }),
  SNIFFER_EGG_NOT_CRACKED_BOTTOM(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_bottom")
      }),
  SNIFFER_EGG_NOT_CRACKED_EAST(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_east") }),
  SNIFFER_EGG_NOT_CRACKED_NORTH(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_north") }),
  SNIFFER_EGG_NOT_CRACKED_SOUTH(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_south") }),
  SNIFFER_EGG_NOT_CRACKED_TOP(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_top") }),
  SNIFFER_EGG_NOT_CRACKED_WEST(lazy { Key.key("minecraft:block/sniffer_egg_not_cracked_west") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_BOTTOM(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_bottom") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_EAST(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_east") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_NORTH(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_north") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_SOUTH(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_south") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_TOP(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_top") }),
  SNIFFER_EGG_SLIGHTLY_CRACKED_WEST(lazy {
      Key.key("minecraft:block/sniffer_egg_slightly_cracked_west") }),
  SNIFFER_EGG_VERY_CRACKED_BOTTOM(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_bottom")
      }),
  SNIFFER_EGG_VERY_CRACKED_EAST(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_east") }),
  SNIFFER_EGG_VERY_CRACKED_NORTH(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_north")
      }),
  SNIFFER_EGG_VERY_CRACKED_SOUTH(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_south")
      }),
  SNIFFER_EGG_VERY_CRACKED_TOP(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_top") }),
  SNIFFER_EGG_VERY_CRACKED_WEST(lazy { Key.key("minecraft:block/sniffer_egg_very_cracked_west") }),
  SNOW(lazy { Key.key("minecraft:block/snow") }),
  SOUL_SAND(lazy { Key.key("minecraft:block/soul_sand") }),
  SOUL_SOIL(lazy { Key.key("minecraft:block/soul_soil") }),
  SOUL_TORCH(lazy { Key.key("minecraft:block/soul_torch") }),
  SPAWNER(lazy { Key.key("minecraft:block/spawner") }),
  SPONGE(lazy { Key.key("minecraft:block/sponge") }),
  SPORE_BLOSSOM(lazy { Key.key("minecraft:block/spore_blossom") }),
  SPORE_BLOSSOM_BASE(lazy { Key.key("minecraft:block/spore_blossom_base") }),
  SPRUCE_DOOR_BOTTOM(lazy { Key.key("minecraft:block/spruce_door_bottom") }),
  SPRUCE_DOOR_TOP(lazy { Key.key("minecraft:block/spruce_door_top") }),
  SPRUCE_LEAVES(lazy { Key.key("minecraft:block/spruce_leaves") }),
  SPRUCE_LOG(lazy { Key.key("minecraft:block/spruce_log") }),
  SPRUCE_LOG_TOP(lazy { Key.key("minecraft:block/spruce_log_top") }),
  SPRUCE_PLANKS(lazy { Key.key("minecraft:block/spruce_planks") }),
  SPRUCE_SAPLING(lazy { Key.key("minecraft:block/spruce_sapling") }),
  SPRUCE_TRAPDOOR(lazy { Key.key("minecraft:block/spruce_trapdoor") }),
  STONE(lazy { Key.key("minecraft:block/stone") }),
  STONECUTTER_BOTTOM(lazy { Key.key("minecraft:block/stonecutter_bottom") }),
  STONECUTTER_SIDE(lazy { Key.key("minecraft:block/stonecutter_side") }),
  STONECUTTER_TOP(lazy { Key.key("minecraft:block/stonecutter_top") }),
  STONE_BRICKS(lazy { Key.key("minecraft:block/stone_bricks") }),
  STRIPPED_ACACIA_LOG(lazy { Key.key("minecraft:block/stripped_acacia_log") }),
  STRIPPED_ACACIA_LOG_TOP(lazy { Key.key("minecraft:block/stripped_acacia_log_top") }),
  STRIPPED_BAMBOO_BLOCK(lazy { Key.key("minecraft:block/stripped_bamboo_block") }),
  STRIPPED_BAMBOO_BLOCK_TOP(lazy { Key.key("minecraft:block/stripped_bamboo_block_top") }),
  STRIPPED_BIRCH_LOG(lazy { Key.key("minecraft:block/stripped_birch_log") }),
  STRIPPED_BIRCH_LOG_TOP(lazy { Key.key("minecraft:block/stripped_birch_log_top") }),
  STRIPPED_CHERRY_LOG(lazy { Key.key("minecraft:block/stripped_cherry_log") }),
  STRIPPED_CHERRY_LOG_TOP(lazy { Key.key("minecraft:block/stripped_cherry_log_top") }),
  STRIPPED_CRIMSON_STEM(lazy { Key.key("minecraft:block/stripped_crimson_stem") }),
  STRIPPED_CRIMSON_STEM_TOP(lazy { Key.key("minecraft:block/stripped_crimson_stem_top") }),
  STRIPPED_DARK_OAK_LOG(lazy { Key.key("minecraft:block/stripped_dark_oak_log") }),
  STRIPPED_DARK_OAK_LOG_TOP(lazy { Key.key("minecraft:block/stripped_dark_oak_log_top") }),
  STRIPPED_JUNGLE_LOG(lazy { Key.key("minecraft:block/stripped_jungle_log") }),
  STRIPPED_JUNGLE_LOG_TOP(lazy { Key.key("minecraft:block/stripped_jungle_log_top") }),
  STRIPPED_MANGROVE_LOG(lazy { Key.key("minecraft:block/stripped_mangrove_log") }),
  STRIPPED_MANGROVE_LOG_TOP(lazy { Key.key("minecraft:block/stripped_mangrove_log_top") }),
  STRIPPED_OAK_LOG(lazy { Key.key("minecraft:block/stripped_oak_log") }),
  STRIPPED_OAK_LOG_TOP(lazy { Key.key("minecraft:block/stripped_oak_log_top") }),
  STRIPPED_SPRUCE_LOG(lazy { Key.key("minecraft:block/stripped_spruce_log") }),
  STRIPPED_SPRUCE_LOG_TOP(lazy { Key.key("minecraft:block/stripped_spruce_log_top") }),
  STRIPPED_WARPED_STEM(lazy { Key.key("minecraft:block/stripped_warped_stem") }),
  STRIPPED_WARPED_STEM_TOP(lazy { Key.key("minecraft:block/stripped_warped_stem_top") }),
  STRUCTURE_BLOCK(lazy { Key.key("minecraft:block/structure_block") }),
  STRUCTURE_BLOCK_CORNER(lazy { Key.key("minecraft:block/structure_block_corner") }),
  STRUCTURE_BLOCK_DATA(lazy { Key.key("minecraft:block/structure_block_data") }),
  STRUCTURE_BLOCK_LOAD(lazy { Key.key("minecraft:block/structure_block_load") }),
  STRUCTURE_BLOCK_SAVE(lazy { Key.key("minecraft:block/structure_block_save") }),
  SUGAR_CANE(lazy { Key.key("minecraft:block/sugar_cane") }),
  SUNFLOWER_BACK(lazy { Key.key("minecraft:block/sunflower_back") }),
  SUNFLOWER_BOTTOM(lazy { Key.key("minecraft:block/sunflower_bottom") }),
  SUNFLOWER_FRONT(lazy { Key.key("minecraft:block/sunflower_front") }),
  SUNFLOWER_TOP(lazy { Key.key("minecraft:block/sunflower_top") }),
  SUSPICIOUS_GRAVEL_0(lazy { Key.key("minecraft:block/suspicious_gravel_0") }),
  SUSPICIOUS_GRAVEL_1(lazy { Key.key("minecraft:block/suspicious_gravel_1") }),
  SUSPICIOUS_GRAVEL_2(lazy { Key.key("minecraft:block/suspicious_gravel_2") }),
  SUSPICIOUS_GRAVEL_3(lazy { Key.key("minecraft:block/suspicious_gravel_3") }),
  SUSPICIOUS_SAND_0(lazy { Key.key("minecraft:block/suspicious_sand_0") }),
  SUSPICIOUS_SAND_1(lazy { Key.key("minecraft:block/suspicious_sand_1") }),
  SUSPICIOUS_SAND_2(lazy { Key.key("minecraft:block/suspicious_sand_2") }),
  SUSPICIOUS_SAND_3(lazy { Key.key("minecraft:block/suspicious_sand_3") }),
  SWEET_BERRY_BUSH_STAGE0(lazy { Key.key("minecraft:block/sweet_berry_bush_stage0") }),
  SWEET_BERRY_BUSH_STAGE1(lazy { Key.key("minecraft:block/sweet_berry_bush_stage1") }),
  SWEET_BERRY_BUSH_STAGE2(lazy { Key.key("minecraft:block/sweet_berry_bush_stage2") }),
  SWEET_BERRY_BUSH_STAGE3(lazy { Key.key("minecraft:block/sweet_berry_bush_stage3") }),
  TALL_GRASS_BOTTOM(lazy { Key.key("minecraft:block/tall_grass_bottom") }),
  TALL_GRASS_TOP(lazy { Key.key("minecraft:block/tall_grass_top") }),
  TARGET_SIDE(lazy { Key.key("minecraft:block/target_side") }),
  TARGET_TOP(lazy { Key.key("minecraft:block/target_top") }),
  TERRACOTTA(lazy { Key.key("minecraft:block/terracotta") }),
  TINTED_GLASS(lazy { Key.key("minecraft:block/tinted_glass") }),
  TNT_BOTTOM(lazy { Key.key("minecraft:block/tnt_bottom") }),
  TNT_SIDE(lazy { Key.key("minecraft:block/tnt_side") }),
  TNT_TOP(lazy { Key.key("minecraft:block/tnt_top") }),
  TORCH(lazy { Key.key("minecraft:block/torch") }),
  TORCHFLOWER(lazy { Key.key("minecraft:block/torchflower") }),
  TORCHFLOWER_CROP_STAGE0(lazy { Key.key("minecraft:block/torchflower_crop_stage0") }),
  TORCHFLOWER_CROP_STAGE1(lazy { Key.key("minecraft:block/torchflower_crop_stage1") }),
  TRIAL_SPAWNER_BOTTOM(lazy { Key.key("minecraft:block/trial_spawner_bottom") }),
  TRIAL_SPAWNER_SIDE_ACTIVE(lazy { Key.key("minecraft:block/trial_spawner_side_active") }),
  TRIAL_SPAWNER_SIDE_ACTIVE_OMINOUS(lazy {
      Key.key("minecraft:block/trial_spawner_side_active_ominous") }),
  TRIAL_SPAWNER_SIDE_INACTIVE(lazy { Key.key("minecraft:block/trial_spawner_side_inactive") }),
  TRIAL_SPAWNER_SIDE_INACTIVE_OMINOUS(lazy {
      Key.key("minecraft:block/trial_spawner_side_inactive_ominous") }),
  TRIAL_SPAWNER_TOP_ACTIVE(lazy { Key.key("minecraft:block/trial_spawner_top_active") }),
  TRIAL_SPAWNER_TOP_ACTIVE_OMINOUS(lazy {
      Key.key("minecraft:block/trial_spawner_top_active_ominous") }),
  TRIAL_SPAWNER_TOP_EJECTING_REWARD(lazy {
      Key.key("minecraft:block/trial_spawner_top_ejecting_reward") }),
  TRIAL_SPAWNER_TOP_EJECTING_REWARD_OMINOUS(lazy {
      Key.key("minecraft:block/trial_spawner_top_ejecting_reward_ominous") }),
  TRIAL_SPAWNER_TOP_INACTIVE(lazy { Key.key("minecraft:block/trial_spawner_top_inactive") }),
  TRIAL_SPAWNER_TOP_INACTIVE_OMINOUS(lazy {
      Key.key("minecraft:block/trial_spawner_top_inactive_ominous") }),
  TRIPWIRE(lazy { Key.key("minecraft:block/tripwire") }),
  TRIPWIRE_HOOK(lazy { Key.key("minecraft:block/tripwire_hook") }),
  TUBE_CORAL(lazy { Key.key("minecraft:block/tube_coral") }),
  TUBE_CORAL_BLOCK(lazy { Key.key("minecraft:block/tube_coral_block") }),
  TUBE_CORAL_FAN(lazy { Key.key("minecraft:block/tube_coral_fan") }),
  TUFF(lazy { Key.key("minecraft:block/tuff") }),
  TUFF_BRICKS(lazy { Key.key("minecraft:block/tuff_bricks") }),
  TURTLE_EGG(lazy { Key.key("minecraft:block/turtle_egg") }),
  TURTLE_EGG_SLIGHTLY_CRACKED(lazy { Key.key("minecraft:block/turtle_egg_slightly_cracked") }),
  TURTLE_EGG_VERY_CRACKED(lazy { Key.key("minecraft:block/turtle_egg_very_cracked") }),
  TWISTING_VINES(lazy { Key.key("minecraft:block/twisting_vines") }),
  TWISTING_VINES_PLANT(lazy { Key.key("minecraft:block/twisting_vines_plant") }),
  VAULT_BOTTOM(lazy { Key.key("minecraft:block/vault_bottom") }),
  VAULT_BOTTOM_OMINOUS(lazy { Key.key("minecraft:block/vault_bottom_ominous") }),
  VAULT_FRONT_EJECTING(lazy { Key.key("minecraft:block/vault_front_ejecting") }),
  VAULT_FRONT_EJECTING_OMINOUS(lazy { Key.key("minecraft:block/vault_front_ejecting_ominous") }),
  VAULT_FRONT_OFF(lazy { Key.key("minecraft:block/vault_front_off") }),
  VAULT_FRONT_OFF_OMINOUS(lazy { Key.key("minecraft:block/vault_front_off_ominous") }),
  VAULT_FRONT_ON(lazy { Key.key("minecraft:block/vault_front_on") }),
  VAULT_FRONT_ON_OMINOUS(lazy { Key.key("minecraft:block/vault_front_on_ominous") }),
  VAULT_SIDE_OFF(lazy { Key.key("minecraft:block/vault_side_off") }),
  VAULT_SIDE_OFF_OMINOUS(lazy { Key.key("minecraft:block/vault_side_off_ominous") }),
  VAULT_SIDE_ON(lazy { Key.key("minecraft:block/vault_side_on") }),
  VAULT_SIDE_ON_OMINOUS(lazy { Key.key("minecraft:block/vault_side_on_ominous") }),
  VAULT_TOP(lazy { Key.key("minecraft:block/vault_top") }),
  VAULT_TOP_EJECTING(lazy { Key.key("minecraft:block/vault_top_ejecting") }),
  VAULT_TOP_EJECTING_OMINOUS(lazy { Key.key("minecraft:block/vault_top_ejecting_ominous") }),
  VAULT_TOP_OMINOUS(lazy { Key.key("minecraft:block/vault_top_ominous") }),
  VERDANT_FROGLIGHT_SIDE(lazy { Key.key("minecraft:block/verdant_froglight_side") }),
  VERDANT_FROGLIGHT_TOP(lazy { Key.key("minecraft:block/verdant_froglight_top") }),
  VINE(lazy { Key.key("minecraft:block/vine") }),
  WARPED_DOOR_BOTTOM(lazy { Key.key("minecraft:block/warped_door_bottom") }),
  WARPED_DOOR_TOP(lazy { Key.key("minecraft:block/warped_door_top") }),
  WARPED_FUNGUS(lazy { Key.key("minecraft:block/warped_fungus") }),
  WARPED_NYLIUM(lazy { Key.key("minecraft:block/warped_nylium") }),
  WARPED_NYLIUM_SIDE(lazy { Key.key("minecraft:block/warped_nylium_side") }),
  WARPED_PLANKS(lazy { Key.key("minecraft:block/warped_planks") }),
  WARPED_ROOTS(lazy { Key.key("minecraft:block/warped_roots") }),
  WARPED_ROOTS_POT(lazy { Key.key("minecraft:block/warped_roots_pot") }),
  WARPED_STEM_TOP(lazy { Key.key("minecraft:block/warped_stem_top") }),
  WARPED_TRAPDOOR(lazy { Key.key("minecraft:block/warped_trapdoor") }),
  WARPED_WART_BLOCK(lazy { Key.key("minecraft:block/warped_wart_block") }),
  WATER_OVERLAY(lazy { Key.key("minecraft:block/water_overlay") }),
  WEATHERED_CHISELED_COPPER(lazy { Key.key("minecraft:block/weathered_chiseled_copper") }),
  WEATHERED_COPPER(lazy { Key.key("minecraft:block/weathered_copper") }),
  WEATHERED_COPPER_BULB(lazy { Key.key("minecraft:block/weathered_copper_bulb") }),
  WEATHERED_COPPER_BULB_LIT(lazy { Key.key("minecraft:block/weathered_copper_bulb_lit") }),
  WEATHERED_COPPER_BULB_LIT_POWERED(lazy {
      Key.key("minecraft:block/weathered_copper_bulb_lit_powered") }),
  WEATHERED_COPPER_BULB_POWERED(lazy { Key.key("minecraft:block/weathered_copper_bulb_powered") }),
  WEATHERED_COPPER_DOOR_BOTTOM(lazy { Key.key("minecraft:block/weathered_copper_door_bottom") }),
  WEATHERED_COPPER_DOOR_TOP(lazy { Key.key("minecraft:block/weathered_copper_door_top") }),
  WEATHERED_COPPER_GRATE(lazy { Key.key("minecraft:block/weathered_copper_grate") }),
  WEATHERED_COPPER_TRAPDOOR(lazy { Key.key("minecraft:block/weathered_copper_trapdoor") }),
  WEATHERED_CUT_COPPER(lazy { Key.key("minecraft:block/weathered_cut_copper") }),
  WEEPING_VINES(lazy { Key.key("minecraft:block/weeping_vines") }),
  WEEPING_VINES_PLANT(lazy { Key.key("minecraft:block/weeping_vines_plant") }),
  WET_SPONGE(lazy { Key.key("minecraft:block/wet_sponge") }),
  WHEAT_STAGE0(lazy { Key.key("minecraft:block/wheat_stage0") }),
  WHEAT_STAGE1(lazy { Key.key("minecraft:block/wheat_stage1") }),
  WHEAT_STAGE2(lazy { Key.key("minecraft:block/wheat_stage2") }),
  WHEAT_STAGE3(lazy { Key.key("minecraft:block/wheat_stage3") }),
  WHEAT_STAGE4(lazy { Key.key("minecraft:block/wheat_stage4") }),
  WHEAT_STAGE5(lazy { Key.key("minecraft:block/wheat_stage5") }),
  WHEAT_STAGE6(lazy { Key.key("minecraft:block/wheat_stage6") }),
  WHEAT_STAGE7(lazy { Key.key("minecraft:block/wheat_stage7") }),
  WHITE_CANDLE(lazy { Key.key("minecraft:block/white_candle") }),
  WHITE_CANDLE_LIT(lazy { Key.key("minecraft:block/white_candle_lit") }),
  WHITE_CONCRETE(lazy { Key.key("minecraft:block/white_concrete") }),
  WHITE_CONCRETE_POWDER(lazy { Key.key("minecraft:block/white_concrete_powder") }),
  WHITE_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/white_glazed_terracotta") }),
  WHITE_SHULKER_BOX(lazy { Key.key("minecraft:block/white_shulker_box") }),
  WHITE_STAINED_GLASS(lazy { Key.key("minecraft:block/white_stained_glass") }),
  WHITE_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/white_stained_glass_pane_top") }),
  WHITE_TERRACOTTA(lazy { Key.key("minecraft:block/white_terracotta") }),
  WHITE_TULIP(lazy { Key.key("minecraft:block/white_tulip") }),
  WHITE_WOOL(lazy { Key.key("minecraft:block/white_wool") }),
  WITHER_ROSE(lazy { Key.key("minecraft:block/wither_rose") }),
  YELLOW_CANDLE(lazy { Key.key("minecraft:block/yellow_candle") }),
  YELLOW_CANDLE_LIT(lazy { Key.key("minecraft:block/yellow_candle_lit") }),
  YELLOW_CONCRETE(lazy { Key.key("minecraft:block/yellow_concrete") }),
  YELLOW_CONCRETE_POWDER(lazy { Key.key("minecraft:block/yellow_concrete_powder") }),
  YELLOW_GLAZED_TERRACOTTA(lazy { Key.key("minecraft:block/yellow_glazed_terracotta") }),
  YELLOW_SHULKER_BOX(lazy { Key.key("minecraft:block/yellow_shulker_box") }),
  YELLOW_STAINED_GLASS(lazy { Key.key("minecraft:block/yellow_stained_glass") }),
  YELLOW_STAINED_GLASS_PANE_TOP(lazy { Key.key("minecraft:block/yellow_stained_glass_pane_top") }),
  YELLOW_TERRACOTTA(lazy { Key.key("minecraft:block/yellow_terracotta") }),
  YELLOW_WOOL(lazy { Key.key("minecraft:block/yellow_wool") }),
  ;

  public fun toGeneric(): SolidMaterialTexture = SolidMaterialTexture(key.value)
}
