package io.github.solid.resourcepack.material

import kotlin.Lazy
import net.kyori.adventure.key.Key

public enum class SolidEntityMaterialTexture(
  public val key: Lazy<Key>,
) {
  WIND(lazy { Key.key("minecraft:entity/conduit/wind") }),
  WIND_VERTICAL(lazy { Key.key("minecraft:entity/conduit/wind_vertical") }),
  BUTCHER(lazy { Key.key("minecraft:entity/zombie_villager/profession/butcher") }),
  FARMER(lazy { Key.key("minecraft:entity/zombie_villager/profession/farmer") }),
  FISHERMAN(lazy { Key.key("minecraft:entity/zombie_villager/profession/fisherman") }),
  FLETCHER(lazy { Key.key("minecraft:entity/zombie_villager/profession/fletcher") }),
  LIBRARIAN(lazy { Key.key("minecraft:entity/zombie_villager/profession/librarian") }),
  SHEPHERD(lazy { Key.key("minecraft:entity/zombie_villager/profession/shepherd") }),
  DESERT(lazy { Key.key("minecraft:entity/zombie_villager/type/desert") }),
  SNOW(lazy { Key.key("minecraft:entity/zombie_villager/type/snow") }),
  ARMADILLO(lazy { Key.key("minecraft:entity/armadillo") }),
  BANNER_BASE(lazy { Key.key("minecraft:entity/banner_base") }),
  BAT(lazy { Key.key("minecraft:entity/bat") }),
  BEACON_BEAM(lazy { Key.key("minecraft:entity/beacon_beam") }),
  BLAZE(lazy { Key.key("minecraft:entity/blaze") }),
  CHICKEN(lazy { Key.key("minecraft:entity/chicken") }),
  DOLPHIN(lazy { Key.key("minecraft:entity/dolphin") }),
  ELYTRA(lazy { Key.key("minecraft:entity/elytra") }),
  ENCHANTING_TABLE_BOOK(lazy { Key.key("minecraft:entity/enchanting_table_book") }),
  ENDERMITE(lazy { Key.key("minecraft:entity/endermite") }),
  END_GATEWAY_BEAM(lazy { Key.key("minecraft:entity/end_gateway_beam") }),
  END_PORTAL(lazy { Key.key("minecraft:entity/end_portal") }),
  EXPERIENCE_ORB(lazy { Key.key("minecraft:entity/experience_orb") }),
  FISHING_HOOK(lazy { Key.key("minecraft:entity/fishing_hook") }),
  GUARDIAN(lazy { Key.key("minecraft:entity/guardian") }),
  GUARDIAN_BEAM(lazy { Key.key("minecraft:entity/guardian_beam") }),
  GUARDIAN_ELDER(lazy { Key.key("minecraft:entity/guardian_elder") }),
  LEAD_KNOT(lazy { Key.key("minecraft:entity/lead_knot") }),
  MINECART(lazy { Key.key("minecraft:entity/minecart") }),
  PHANTOM(lazy { Key.key("minecraft:entity/phantom") }),
  PHANTOM_EYES(lazy { Key.key("minecraft:entity/phantom_eyes") }),
  SHIELD_BASE(lazy { Key.key("minecraft:entity/shield_base") }),
  SHIELD_BASE_NOPATTERN(lazy { Key.key("minecraft:entity/shield_base_nopattern") }),
  SILVERFISH(lazy { Key.key("minecraft:entity/silverfish") }),
  SNOW_GOLEM(lazy { Key.key("minecraft:entity/snow_golem") }),
  SPIDER_EYES(lazy { Key.key("minecraft:entity/spider_eyes") }),
  TRIDENT(lazy { Key.key("minecraft:entity/trident") }),
  TRIDENT_RIPTIDE(lazy { Key.key("minecraft:entity/trident_riptide") }),
  WANDERING_TRADER(lazy { Key.key("minecraft:entity/wandering_trader") }),
  WITCH(lazy { Key.key("minecraft:entity/witch") }),
  ALLAY(lazy { Key.key("minecraft:entity/allay/allay") }),
  WOOD(lazy { Key.key("minecraft:entity/armorstand/wood") }),
  AXOLOTL_BLUE(lazy { Key.key("minecraft:entity/axolotl/axolotl_blue") }),
  AXOLOTL_CYAN(lazy { Key.key("minecraft:entity/axolotl/axolotl_cyan") }),
  AXOLOTL_GOLD(lazy { Key.key("minecraft:entity/axolotl/axolotl_gold") }),
  AXOLOTL_LUCY(lazy { Key.key("minecraft:entity/axolotl/axolotl_lucy") }),
  AXOLOTL_WILD(lazy { Key.key("minecraft:entity/axolotl/axolotl_wild") }),
  BASE(lazy { Key.key("minecraft:entity/shield/base") }),
  BORDER(lazy { Key.key("minecraft:entity/shield/border") }),
  BRICKS(lazy { Key.key("minecraft:entity/shield/bricks") }),
  CIRCLE(lazy { Key.key("minecraft:entity/shield/circle") }),
  CREEPER(lazy { Key.key("minecraft:entity/shield/creeper") }),
  CROSS(lazy { Key.key("minecraft:entity/shield/cross") }),
  CURLY_BORDER(lazy { Key.key("minecraft:entity/shield/curly_border") }),
  DIAGONAL_LEFT(lazy { Key.key("minecraft:entity/shield/diagonal_left") }),
  DIAGONAL_RIGHT(lazy { Key.key("minecraft:entity/shield/diagonal_right") }),
  DIAGONAL_UP_LEFT(lazy { Key.key("minecraft:entity/shield/diagonal_up_left") }),
  DIAGONAL_UP_RIGHT(lazy { Key.key("minecraft:entity/shield/diagonal_up_right") }),
  FLOW(lazy { Key.key("minecraft:entity/shield/flow") }),
  FLOWER(lazy { Key.key("minecraft:entity/shield/flower") }),
  GLOBE(lazy { Key.key("minecraft:entity/shield/globe") }),
  GRADIENT(lazy { Key.key("minecraft:entity/shield/gradient") }),
  GRADIENT_UP(lazy { Key.key("minecraft:entity/shield/gradient_up") }),
  GUSTER(lazy { Key.key("minecraft:entity/shield/guster") }),
  HALF_HORIZONTAL(lazy { Key.key("minecraft:entity/shield/half_horizontal") }),
  HALF_HORIZONTAL_BOTTOM(lazy { Key.key("minecraft:entity/shield/half_horizontal_bottom") }),
  HALF_VERTICAL(lazy { Key.key("minecraft:entity/shield/half_vertical") }),
  HALF_VERTICAL_RIGHT(lazy { Key.key("minecraft:entity/shield/half_vertical_right") }),
  MOJANG(lazy { Key.key("minecraft:entity/shield/mojang") }),
  PIGLIN(lazy { Key.key("minecraft:entity/shield/piglin") }),
  RHOMBUS(lazy { Key.key("minecraft:entity/shield/rhombus") }),
  SKULL(lazy { Key.key("minecraft:entity/shield/skull") }),
  SMALL_STRIPES(lazy { Key.key("minecraft:entity/shield/small_stripes") }),
  SQUARE_BOTTOM_LEFT(lazy { Key.key("minecraft:entity/shield/square_bottom_left") }),
  SQUARE_BOTTOM_RIGHT(lazy { Key.key("minecraft:entity/shield/square_bottom_right") }),
  SQUARE_TOP_LEFT(lazy { Key.key("minecraft:entity/shield/square_top_left") }),
  SQUARE_TOP_RIGHT(lazy { Key.key("minecraft:entity/shield/square_top_right") }),
  STRAIGHT_CROSS(lazy { Key.key("minecraft:entity/shield/straight_cross") }),
  STRIPE_BOTTOM(lazy { Key.key("minecraft:entity/shield/stripe_bottom") }),
  STRIPE_CENTER(lazy { Key.key("minecraft:entity/shield/stripe_center") }),
  STRIPE_DOWNLEFT(lazy { Key.key("minecraft:entity/shield/stripe_downleft") }),
  STRIPE_DOWNRIGHT(lazy { Key.key("minecraft:entity/shield/stripe_downright") }),
  STRIPE_LEFT(lazy { Key.key("minecraft:entity/shield/stripe_left") }),
  STRIPE_MIDDLE(lazy { Key.key("minecraft:entity/shield/stripe_middle") }),
  STRIPE_RIGHT(lazy { Key.key("minecraft:entity/shield/stripe_right") }),
  STRIPE_TOP(lazy { Key.key("minecraft:entity/shield/stripe_top") }),
  TRIANGLES_BOTTOM(lazy { Key.key("minecraft:entity/shield/triangles_bottom") }),
  TRIANGLES_TOP(lazy { Key.key("minecraft:entity/shield/triangles_top") }),
  TRIANGLE_BOTTOM(lazy { Key.key("minecraft:entity/shield/triangle_bottom") }),
  TRIANGLE_TOP(lazy { Key.key("minecraft:entity/shield/triangle_top") }),
  POLARBEAR(lazy { Key.key("minecraft:entity/bear/polarbear") }),
  BLACK(lazy { Key.key("minecraft:entity/llama/decor/black") }),
  BLUE(lazy { Key.key("minecraft:entity/llama/decor/blue") }),
  BROWN(lazy { Key.key("minecraft:entity/llama/decor/brown") }),
  CYAN(lazy { Key.key("minecraft:entity/llama/decor/cyan") }),
  GRAY(lazy { Key.key("minecraft:entity/llama/decor/gray") }),
  GREEN(lazy { Key.key("minecraft:entity/llama/decor/green") }),
  LIGHT_BLUE(lazy { Key.key("minecraft:entity/llama/decor/light_blue") }),
  LIGHT_GRAY(lazy { Key.key("minecraft:entity/llama/decor/light_gray") }),
  LIME(lazy { Key.key("minecraft:entity/llama/decor/lime") }),
  MAGENTA(lazy { Key.key("minecraft:entity/llama/decor/magenta") }),
  ORANGE(lazy { Key.key("minecraft:entity/llama/decor/orange") }),
  PINK(lazy { Key.key("minecraft:entity/llama/decor/pink") }),
  PURPLE(lazy { Key.key("minecraft:entity/llama/decor/purple") }),
  RED(lazy { Key.key("minecraft:entity/llama/decor/red") }),
  WHITE(lazy { Key.key("minecraft:entity/llama/decor/white") }),
  YELLOW(lazy { Key.key("minecraft:entity/llama/decor/yellow") }),
  BEE(lazy { Key.key("minecraft:entity/bee/bee") }),
  BEE_ANGRY(lazy { Key.key("minecraft:entity/bee/bee_angry") }),
  BEE_ANGRY_NECTAR(lazy { Key.key("minecraft:entity/bee/bee_angry_nectar") }),
  BEE_NECTAR(lazy { Key.key("minecraft:entity/bee/bee_nectar") }),
  BEE_STINGER(lazy { Key.key("minecraft:entity/bee/bee_stinger") }),
  BELL_BODY(lazy { Key.key("minecraft:entity/bell/bell_body") }),
  ACACIA(lazy { Key.key("minecraft:entity/signs/hanging/acacia") }),
  BAMBOO(lazy { Key.key("minecraft:entity/signs/hanging/bamboo") }),
  BIRCH(lazy { Key.key("minecraft:entity/signs/hanging/birch") }),
  CHERRY(lazy { Key.key("minecraft:entity/signs/hanging/cherry") }),
  DARK_OAK(lazy { Key.key("minecraft:entity/signs/hanging/dark_oak") }),
  JUNGLE(lazy { Key.key("minecraft:entity/zombie_villager/type/jungle") }),
  MANGROVE(lazy { Key.key("minecraft:entity/signs/hanging/mangrove") }),
  OAK(lazy { Key.key("minecraft:entity/signs/hanging/oak") }),
  SPRUCE(lazy { Key.key("minecraft:entity/signs/hanging/spruce") }),
  BREEZE(lazy { Key.key("minecraft:entity/breeze/breeze") }),
  BREEZE_EYES(lazy { Key.key("minecraft:entity/breeze/breeze_eyes") }),
  BREEZE_WIND(lazy { Key.key("minecraft:entity/breeze/breeze_wind") }),
  CAMEL(lazy { Key.key("minecraft:entity/camel/camel") }),
  ALL_BLACK(lazy { Key.key("minecraft:entity/cat/all_black") }),
  BRITISH_SHORTHAIR(lazy { Key.key("minecraft:entity/cat/british_shorthair") }),
  CALICO(lazy { Key.key("minecraft:entity/cat/calico") }),
  CAT_COLLAR(lazy { Key.key("minecraft:entity/cat/cat_collar") }),
  JELLIE(lazy { Key.key("minecraft:entity/cat/jellie") }),
  OCELOT(lazy { Key.key("minecraft:entity/cat/ocelot") }),
  PERSIAN(lazy { Key.key("minecraft:entity/cat/persian") }),
  RAGDOLL(lazy { Key.key("minecraft:entity/cat/ragdoll") }),
  SIAMESE(lazy { Key.key("minecraft:entity/cat/siamese") }),
  TABBY(lazy { Key.key("minecraft:entity/cat/tabby") }),
  CHRISTMAS(lazy { Key.key("minecraft:entity/chest/christmas") }),
  CHRISTMAS_LEFT(lazy { Key.key("minecraft:entity/chest/christmas_left") }),
  CHRISTMAS_RIGHT(lazy { Key.key("minecraft:entity/chest/christmas_right") }),
  ENDER(lazy { Key.key("minecraft:entity/chest/ender") }),
  NORMAL(lazy { Key.key("minecraft:entity/chest/normal") }),
  NORMAL_LEFT(lazy { Key.key("minecraft:entity/chest/normal_left") }),
  NORMAL_RIGHT(lazy { Key.key("minecraft:entity/chest/normal_right") }),
  TRAPPED(lazy { Key.key("minecraft:entity/chest/trapped") }),
  TRAPPED_LEFT(lazy { Key.key("minecraft:entity/chest/trapped_left") }),
  TRAPPED_RIGHT(lazy { Key.key("minecraft:entity/chest/trapped_right") }),
  BREAK_PARTICLE(lazy { Key.key("minecraft:entity/conduit/break_particle") }),
  CAGE(lazy { Key.key("minecraft:entity/conduit/cage") }),
  CLOSED_EYE(lazy { Key.key("minecraft:entity/conduit/closed_eye") }),
  OPEN_EYE(lazy { Key.key("minecraft:entity/conduit/open_eye") }),
  BROWN_MOOSHROOM(lazy { Key.key("minecraft:entity/cow/brown_mooshroom") }),
  COW(lazy { Key.key("minecraft:entity/cow/cow") }),
  RED_MOOSHROOM(lazy { Key.key("minecraft:entity/cow/red_mooshroom") }),
  CREEPER_ARMOR(lazy { Key.key("minecraft:entity/creeper/creeper_armor") }),
  ANGLER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/angler_pottery_pattern") }),
  ARCHER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/archer_pottery_pattern") }),
  ARMS_UP_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/arms_up_pottery_pattern")
      }),
  BLADE_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/blade_pottery_pattern") }),
  BREWER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/brewer_pottery_pattern") }),
  BURN_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/burn_pottery_pattern") }),
  DANGER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/danger_pottery_pattern") }),
  DECORATED_POT_BASE(lazy { Key.key("minecraft:entity/decorated_pot/decorated_pot_base") }),
  DECORATED_POT_SIDE(lazy { Key.key("minecraft:entity/decorated_pot/decorated_pot_side") }),
  EXPLORER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/explorer_pottery_pattern")
      }),
  FLOW_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/flow_pottery_pattern") }),
  FRIEND_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/friend_pottery_pattern") }),
  GUSTER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/guster_pottery_pattern") }),
  HEARTBREAK_POTTERY_PATTERN(lazy {
      Key.key("minecraft:entity/decorated_pot/heartbreak_pottery_pattern") }),
  HEART_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/heart_pottery_pattern") }),
  HOWL_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/howl_pottery_pattern") }),
  MINER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/miner_pottery_pattern") }),
  MOURNER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/mourner_pottery_pattern")
      }),
  PLENTY_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/plenty_pottery_pattern") }),
  PRIZE_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/prize_pottery_pattern") }),
  SCRAPE_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/scrape_pottery_pattern") }),
  SHEAF_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/sheaf_pottery_pattern") }),
  SHELTER_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/shelter_pottery_pattern")
      }),
  SKULL_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/skull_pottery_pattern") }),
  SNORT_POTTERY_PATTERN(lazy { Key.key("minecraft:entity/decorated_pot/snort_pottery_pattern") }),
  DRAGON(lazy { Key.key("minecraft:entity/enderdragon/dragon") }),
  DRAGON_EXPLODING(lazy { Key.key("minecraft:entity/enderdragon/dragon_exploding") }),
  DRAGON_EYES(lazy { Key.key("minecraft:entity/enderdragon/dragon_eyes") }),
  DRAGON_FIREBALL(lazy { Key.key("minecraft:entity/enderdragon/dragon_fireball") }),
  ENDERMAN(lazy { Key.key("minecraft:entity/enderman/enderman") }),
  ENDERMAN_EYES(lazy { Key.key("minecraft:entity/enderman/enderman_eyes") }),
  END_CRYSTAL(lazy { Key.key("minecraft:entity/end_crystal/end_crystal") }),
  END_CRYSTAL_BEAM(lazy { Key.key("minecraft:entity/end_crystal/end_crystal_beam") }),
  COD(lazy { Key.key("minecraft:entity/fish/cod") }),
  PUFFERFISH(lazy { Key.key("minecraft:entity/fish/pufferfish") }),
  SALMON(lazy { Key.key("minecraft:entity/fish/salmon") }),
  TROPICAL_A(lazy { Key.key("minecraft:entity/fish/tropical_a") }),
  TROPICAL_A_PATTERN_1(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_1") }),
  TROPICAL_A_PATTERN_2(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_2") }),
  TROPICAL_A_PATTERN_3(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_3") }),
  TROPICAL_A_PATTERN_4(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_4") }),
  TROPICAL_A_PATTERN_5(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_5") }),
  TROPICAL_A_PATTERN_6(lazy { Key.key("minecraft:entity/fish/tropical_a_pattern_6") }),
  TROPICAL_B(lazy { Key.key("minecraft:entity/fish/tropical_b") }),
  TROPICAL_B_PATTERN_1(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_1") }),
  TROPICAL_B_PATTERN_2(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_2") }),
  TROPICAL_B_PATTERN_3(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_3") }),
  TROPICAL_B_PATTERN_4(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_4") }),
  TROPICAL_B_PATTERN_5(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_5") }),
  TROPICAL_B_PATTERN_6(lazy { Key.key("minecraft:entity/fish/tropical_b_pattern_6") }),
  FOX(lazy { Key.key("minecraft:entity/fox/fox") }),
  FOX_SLEEP(lazy { Key.key("minecraft:entity/fox/fox_sleep") }),
  SNOW_FOX(lazy { Key.key("minecraft:entity/fox/snow_fox") }),
  SNOW_FOX_SLEEP(lazy { Key.key("minecraft:entity/fox/snow_fox_sleep") }),
  COLD_FROG(lazy { Key.key("minecraft:entity/frog/cold_frog") }),
  TEMPERATE_FROG(lazy { Key.key("minecraft:entity/frog/temperate_frog") }),
  WARM_FROG(lazy { Key.key("minecraft:entity/frog/warm_frog") }),
  GHAST(lazy { Key.key("minecraft:entity/ghast/ghast") }),
  GHAST_SHOOTING(lazy { Key.key("minecraft:entity/ghast/ghast_shooting") }),
  GOAT(lazy { Key.key("minecraft:entity/goat/goat") }),
  HOGLIN(lazy { Key.key("minecraft:entity/hoglin/hoglin") }),
  ZOGLIN(lazy { Key.key("minecraft:entity/hoglin/zoglin") }),
  DONKEY(lazy { Key.key("minecraft:entity/horse/donkey") }),
  HORSE_BLACK(lazy { Key.key("minecraft:entity/horse/horse_black") }),
  HORSE_BROWN(lazy { Key.key("minecraft:entity/horse/horse_brown") }),
  HORSE_CHESTNUT(lazy { Key.key("minecraft:entity/horse/horse_chestnut") }),
  HORSE_CREAMY(lazy { Key.key("minecraft:entity/horse/horse_creamy") }),
  HORSE_DARKBROWN(lazy { Key.key("minecraft:entity/horse/horse_darkbrown") }),
  HORSE_GRAY(lazy { Key.key("minecraft:entity/horse/horse_gray") }),
  HORSE_MARKINGS_BLACKDOTS(lazy { Key.key("minecraft:entity/horse/horse_markings_blackdots") }),
  HORSE_MARKINGS_WHITE(lazy { Key.key("minecraft:entity/horse/horse_markings_white") }),
  HORSE_MARKINGS_WHITEDOTS(lazy { Key.key("minecraft:entity/horse/horse_markings_whitedots") }),
  HORSE_MARKINGS_WHITEFIELD(lazy { Key.key("minecraft:entity/horse/horse_markings_whitefield") }),
  HORSE_SKELETON(lazy { Key.key("minecraft:entity/horse/horse_skeleton") }),
  HORSE_WHITE(lazy { Key.key("minecraft:entity/horse/horse_white") }),
  HORSE_ZOMBIE(lazy { Key.key("minecraft:entity/horse/horse_zombie") }),
  MULE(lazy { Key.key("minecraft:entity/horse/mule") }),
  EVOKER(lazy { Key.key("minecraft:entity/illager/evoker") }),
  EVOKER_FANGS(lazy { Key.key("minecraft:entity/illager/evoker_fangs") }),
  ILLUSIONER(lazy { Key.key("minecraft:entity/illager/illusioner") }),
  PILLAGER(lazy { Key.key("minecraft:entity/illager/pillager") }),
  RAVAGER(lazy { Key.key("minecraft:entity/illager/ravager") }),
  VEX(lazy { Key.key("minecraft:entity/illager/vex") }),
  VEX_CHARGING(lazy { Key.key("minecraft:entity/illager/vex_charging") }),
  VINDICATOR(lazy { Key.key("minecraft:entity/illager/vindicator") }),
  IRON_GOLEM(lazy { Key.key("minecraft:entity/iron_golem/iron_golem") }),
  IRON_GOLEM_CRACKINESS_HIGH(lazy {
      Key.key("minecraft:entity/iron_golem/iron_golem_crackiness_high") }),
  IRON_GOLEM_CRACKINESS_LOW(lazy { Key.key("minecraft:entity/iron_golem/iron_golem_crackiness_low")
      }),
  IRON_GOLEM_CRACKINESS_MEDIUM(lazy {
      Key.key("minecraft:entity/iron_golem/iron_golem_crackiness_medium") }),
  CREAMY(lazy { Key.key("minecraft:entity/llama/creamy") }),
  SPIT(lazy { Key.key("minecraft:entity/llama/spit") }),
  AGGRESSIVE_PANDA(lazy { Key.key("minecraft:entity/panda/aggressive_panda") }),
  BROWN_PANDA(lazy { Key.key("minecraft:entity/panda/brown_panda") }),
  LAZY_PANDA(lazy { Key.key("minecraft:entity/panda/lazy_panda") }),
  PANDA(lazy { Key.key("minecraft:entity/panda/panda") }),
  PLAYFUL_PANDA(lazy { Key.key("minecraft:entity/panda/playful_panda") }),
  WEAK_PANDA(lazy { Key.key("minecraft:entity/panda/weak_panda") }),
  WORRIED_PANDA(lazy { Key.key("minecraft:entity/panda/worried_panda") }),
  PARROT_BLUE(lazy { Key.key("minecraft:entity/parrot/parrot_blue") }),
  PARROT_GREEN(lazy { Key.key("minecraft:entity/parrot/parrot_green") }),
  PARROT_GREY(lazy { Key.key("minecraft:entity/parrot/parrot_grey") }),
  PARROT_RED_BLUE(lazy { Key.key("minecraft:entity/parrot/parrot_red_blue") }),
  PARROT_YELLOW_BLUE(lazy { Key.key("minecraft:entity/parrot/parrot_yellow_blue") }),
  PIG(lazy { Key.key("minecraft:entity/pig/pig") }),
  PIG_SADDLE(lazy { Key.key("minecraft:entity/pig/pig_saddle") }),
  PIGLIN_BRUTE(lazy { Key.key("minecraft:entity/piglin/piglin_brute") }),
  ZOMBIFIED_PIGLIN(lazy { Key.key("minecraft:entity/piglin/zombified_piglin") }),
  ARROW(lazy { Key.key("minecraft:entity/projectiles/arrow") }),
  SPECTRAL_ARROW(lazy { Key.key("minecraft:entity/projectiles/spectral_arrow") }),
  TIPPED_ARROW(lazy { Key.key("minecraft:entity/projectiles/tipped_arrow") }),
  WIND_CHARGE(lazy { Key.key("minecraft:entity/projectiles/wind_charge") }),
  CAERBANNOG(lazy { Key.key("minecraft:entity/rabbit/caerbannog") }),
  GOLD(lazy { Key.key("minecraft:entity/zombie_villager/profession_level/gold") }),
  SALT(lazy { Key.key("minecraft:entity/rabbit/salt") }),
  TOAST(lazy { Key.key("minecraft:entity/rabbit/toast") }),
  WHITE_SPLOTCHED(lazy { Key.key("minecraft:entity/rabbit/white_splotched") }),
  SHEEP(lazy { Key.key("minecraft:entity/sheep/sheep") }),
  SHEEP_FUR(lazy { Key.key("minecraft:entity/sheep/sheep_fur") }),
  SHULKER(lazy { Key.key("minecraft:entity/shulker/shulker") }),
  SHULKER_BLACK(lazy { Key.key("minecraft:entity/shulker/shulker_black") }),
  SHULKER_BLUE(lazy { Key.key("minecraft:entity/shulker/shulker_blue") }),
  SHULKER_BROWN(lazy { Key.key("minecraft:entity/shulker/shulker_brown") }),
  SHULKER_CYAN(lazy { Key.key("minecraft:entity/shulker/shulker_cyan") }),
  SHULKER_GRAY(lazy { Key.key("minecraft:entity/shulker/shulker_gray") }),
  SHULKER_GREEN(lazy { Key.key("minecraft:entity/shulker/shulker_green") }),
  SHULKER_LIGHT_BLUE(lazy { Key.key("minecraft:entity/shulker/shulker_light_blue") }),
  SHULKER_LIGHT_GRAY(lazy { Key.key("minecraft:entity/shulker/shulker_light_gray") }),
  SHULKER_LIME(lazy { Key.key("minecraft:entity/shulker/shulker_lime") }),
  SHULKER_MAGENTA(lazy { Key.key("minecraft:entity/shulker/shulker_magenta") }),
  SHULKER_ORANGE(lazy { Key.key("minecraft:entity/shulker/shulker_orange") }),
  SHULKER_PINK(lazy { Key.key("minecraft:entity/shulker/shulker_pink") }),
  SHULKER_PURPLE(lazy { Key.key("minecraft:entity/shulker/shulker_purple") }),
  SHULKER_RED(lazy { Key.key("minecraft:entity/shulker/shulker_red") }),
  SHULKER_WHITE(lazy { Key.key("minecraft:entity/shulker/shulker_white") }),
  SHULKER_YELLOW(lazy { Key.key("minecraft:entity/shulker/shulker_yellow") }),
  SPARK(lazy { Key.key("minecraft:entity/shulker/spark") }),
  CRIMSON(lazy { Key.key("minecraft:entity/signs/hanging/crimson") }),
  WARPED(lazy { Key.key("minecraft:entity/signs/hanging/warped") }),
  BOGGED(lazy { Key.key("minecraft:entity/skeleton/bogged") }),
  BOGGED_OVERLAY(lazy { Key.key("minecraft:entity/skeleton/bogged_overlay") }),
  SKELETON(lazy { Key.key("minecraft:entity/skeleton/skeleton") }),
  STRAY(lazy { Key.key("minecraft:entity/skeleton/stray") }),
  STRAY_OVERLAY(lazy { Key.key("minecraft:entity/skeleton/stray_overlay") }),
  WITHER_SKELETON(lazy { Key.key("minecraft:entity/skeleton/wither_skeleton") }),
  MAGMACUBE(lazy { Key.key("minecraft:entity/slime/magmacube") }),
  SLIME(lazy { Key.key("minecraft:entity/slime/slime") }),
  SNIFFER(lazy { Key.key("minecraft:entity/sniffer/sniffer") }),
  CAVE_SPIDER(lazy { Key.key("minecraft:entity/spider/cave_spider") }),
  SPIDER(lazy { Key.key("minecraft:entity/spider/spider") }),
  GLOW_SQUID(lazy { Key.key("minecraft:entity/squid/glow_squid") }),
  SQUID(lazy { Key.key("minecraft:entity/squid/squid") }),
  STRIDER(lazy { Key.key("minecraft:entity/strider/strider") }),
  STRIDER_COLD(lazy { Key.key("minecraft:entity/strider/strider_cold") }),
  STRIDER_SADDLE(lazy { Key.key("minecraft:entity/strider/strider_saddle") }),
  TADPOLE(lazy { Key.key("minecraft:entity/tadpole/tadpole") }),
  BIG_SEA_TURTLE(lazy { Key.key("minecraft:entity/turtle/big_sea_turtle") }),
  VILLAGER(lazy { Key.key("minecraft:entity/villager/villager") }),
  WARDEN(lazy { Key.key("minecraft:entity/warden/warden") }),
  WARDEN_BIOLUMINESCENT_LAYER(lazy { Key.key("minecraft:entity/warden/warden_bioluminescent_layer")
      }),
  WARDEN_HEART(lazy { Key.key("minecraft:entity/warden/warden_heart") }),
  WARDEN_PULSATING_SPOTS_1(lazy { Key.key("minecraft:entity/warden/warden_pulsating_spots_1") }),
  WARDEN_PULSATING_SPOTS_2(lazy { Key.key("minecraft:entity/warden/warden_pulsating_spots_2") }),
  WITHER(lazy { Key.key("minecraft:entity/wither/wither") }),
  WITHER_ARMOR(lazy { Key.key("minecraft:entity/wither/wither_armor") }),
  WITHER_INVULNERABLE(lazy { Key.key("minecraft:entity/wither/wither_invulnerable") }),
  WOLF(lazy { Key.key("minecraft:entity/wolf/wolf") }),
  WOLF_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_angry") }),
  WOLF_ARMOR(lazy { Key.key("minecraft:entity/wolf/wolf_armor") }),
  WOLF_ARMOR_CRACKINESS_HIGH(lazy { Key.key("minecraft:entity/wolf/wolf_armor_crackiness_high") }),
  WOLF_ARMOR_CRACKINESS_LOW(lazy { Key.key("minecraft:entity/wolf/wolf_armor_crackiness_low") }),
  WOLF_ARMOR_CRACKINESS_MEDIUM(lazy { Key.key("minecraft:entity/wolf/wolf_armor_crackiness_medium")
      }),
  WOLF_ARMOR_OVERLAY(lazy { Key.key("minecraft:entity/wolf/wolf_armor_overlay") }),
  WOLF_ASHEN(lazy { Key.key("minecraft:entity/wolf/wolf_ashen") }),
  WOLF_ASHEN_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_ashen_angry") }),
  WOLF_ASHEN_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_ashen_tame") }),
  WOLF_BLACK(lazy { Key.key("minecraft:entity/wolf/wolf_black") }),
  WOLF_BLACK_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_black_angry") }),
  WOLF_BLACK_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_black_tame") }),
  WOLF_CHESTNUT(lazy { Key.key("minecraft:entity/wolf/wolf_chestnut") }),
  WOLF_CHESTNUT_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_chestnut_angry") }),
  WOLF_CHESTNUT_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_chestnut_tame") }),
  WOLF_COLLAR(lazy { Key.key("minecraft:entity/wolf/wolf_collar") }),
  WOLF_RUSTY(lazy { Key.key("minecraft:entity/wolf/wolf_rusty") }),
  WOLF_RUSTY_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_rusty_angry") }),
  WOLF_RUSTY_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_rusty_tame") }),
  WOLF_SNOWY(lazy { Key.key("minecraft:entity/wolf/wolf_snowy") }),
  WOLF_SNOWY_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_snowy_angry") }),
  WOLF_SNOWY_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_snowy_tame") }),
  WOLF_SPOTTED(lazy { Key.key("minecraft:entity/wolf/wolf_spotted") }),
  WOLF_SPOTTED_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_spotted_angry") }),
  WOLF_SPOTTED_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_spotted_tame") }),
  WOLF_STRIPED(lazy { Key.key("minecraft:entity/wolf/wolf_striped") }),
  WOLF_STRIPED_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_striped_angry") }),
  WOLF_STRIPED_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_striped_tame") }),
  WOLF_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_tame") }),
  WOLF_WOODS(lazy { Key.key("minecraft:entity/wolf/wolf_woods") }),
  WOLF_WOODS_ANGRY(lazy { Key.key("minecraft:entity/wolf/wolf_woods_angry") }),
  WOLF_WOODS_TAME(lazy { Key.key("minecraft:entity/wolf/wolf_woods_tame") }),
  DROWNED(lazy { Key.key("minecraft:entity/zombie/drowned") }),
  DROWNED_OUTER_LAYER(lazy { Key.key("minecraft:entity/zombie/drowned_outer_layer") }),
  HUSK(lazy { Key.key("minecraft:entity/zombie/husk") }),
  ZOMBIE(lazy { Key.key("minecraft:entity/zombie/zombie") }),
  ZOMBIE_VILLAGER(lazy { Key.key("minecraft:entity/zombie_villager/zombie_villager") }),
  HORSE_ARMOR_DIAMOND(lazy { Key.key("minecraft:entity/horse/armor/horse_armor_diamond") }),
  HORSE_ARMOR_GOLD(lazy { Key.key("minecraft:entity/horse/armor/horse_armor_gold") }),
  HORSE_ARMOR_IRON(lazy { Key.key("minecraft:entity/horse/armor/horse_armor_iron") }),
  HORSE_ARMOR_LEATHER(lazy { Key.key("minecraft:entity/horse/armor/horse_armor_leather") }),
  TRADER_LLAMA(lazy { Key.key("minecraft:entity/llama/decor/trader_llama") }),
  ALEX(lazy { Key.key("minecraft:entity/player/wide/alex") }),
  ARI(lazy { Key.key("minecraft:entity/player/wide/ari") }),
  EFE(lazy { Key.key("minecraft:entity/player/wide/efe") }),
  KAI(lazy { Key.key("minecraft:entity/player/wide/kai") }),
  MAKENA(lazy { Key.key("minecraft:entity/player/wide/makena") }),
  NOOR(lazy { Key.key("minecraft:entity/player/wide/noor") }),
  STEVE(lazy { Key.key("minecraft:entity/player/wide/steve") }),
  SUNNY(lazy { Key.key("minecraft:entity/player/wide/sunny") }),
  ZURI(lazy { Key.key("minecraft:entity/player/wide/zuri") }),
  ARMORER(lazy { Key.key("minecraft:entity/zombie_villager/profession/armorer") }),
  CARTOGRAPHER(lazy { Key.key("minecraft:entity/zombie_villager/profession/cartographer") }),
  CLERIC(lazy { Key.key("minecraft:entity/zombie_villager/profession/cleric") }),
  LEATHERWORKER(lazy { Key.key("minecraft:entity/zombie_villager/profession/leatherworker") }),
  MASON(lazy { Key.key("minecraft:entity/zombie_villager/profession/mason") }),
  NITWIT(lazy { Key.key("minecraft:entity/zombie_villager/profession/nitwit") }),
  TOOLSMITH(lazy { Key.key("minecraft:entity/zombie_villager/profession/toolsmith") }),
  WEAPONSMITH(lazy { Key.key("minecraft:entity/zombie_villager/profession/weaponsmith") }),
  DIAMOND(lazy { Key.key("minecraft:entity/zombie_villager/profession_level/diamond") }),
  EMERALD(lazy { Key.key("minecraft:entity/zombie_villager/profession_level/emerald") }),
  IRON(lazy { Key.key("minecraft:entity/zombie_villager/profession_level/iron") }),
  STONE(lazy { Key.key("minecraft:entity/zombie_villager/profession_level/stone") }),
  PLAINS(lazy { Key.key("minecraft:entity/zombie_villager/type/plains") }),
  SAVANNA(lazy { Key.key("minecraft:entity/zombie_villager/type/savanna") }),
  SWAMP(lazy { Key.key("minecraft:entity/zombie_villager/type/swamp") }),
  TAIGA(lazy { Key.key("minecraft:entity/zombie_villager/type/taiga") }),
  ;

  public fun toGeneric(): SolidMaterialTexture = SolidMaterialTexture(key.value)
}
