package io.github.solid.resourcepack.material

import kotlin.Lazy
import net.kyori.adventure.key.Key

public enum class SolidTrimsMaterialTexture(
  public val key: Lazy<Key>,
) {
  AMETHYST(lazy { Key.key("minecraft:trims/color_palettes/amethyst") }),
  COPPER(lazy { Key.key("minecraft:trims/color_palettes/copper") }),
  DIAMOND(lazy { Key.key("minecraft:trims/color_palettes/diamond") }),
  DIAMOND_DARKER(lazy { Key.key("minecraft:trims/color_palettes/diamond_darker") }),
  EMERALD(lazy { Key.key("minecraft:trims/color_palettes/emerald") }),
  GOLD(lazy { Key.key("minecraft:trims/color_palettes/gold") }),
  GOLD_DARKER(lazy { Key.key("minecraft:trims/color_palettes/gold_darker") }),
  IRON(lazy { Key.key("minecraft:trims/color_palettes/iron") }),
  IRON_DARKER(lazy { Key.key("minecraft:trims/color_palettes/iron_darker") }),
  LAPIS(lazy { Key.key("minecraft:trims/color_palettes/lapis") }),
  NETHERITE(lazy { Key.key("minecraft:trims/color_palettes/netherite") }),
  NETHERITE_DARKER(lazy { Key.key("minecraft:trims/color_palettes/netherite_darker") }),
  QUARTZ(lazy { Key.key("minecraft:trims/color_palettes/quartz") }),
  REDSTONE(lazy { Key.key("minecraft:trims/color_palettes/redstone") }),
  TRIM_PALETTE(lazy { Key.key("minecraft:trims/color_palettes/trim_palette") }),
  BOOTS_TRIM(lazy { Key.key("minecraft:trims/items/boots_trim") }),
  CHESTPLATE_TRIM(lazy { Key.key("minecraft:trims/items/chestplate_trim") }),
  HELMET_TRIM(lazy { Key.key("minecraft:trims/items/helmet_trim") }),
  LEGGINGS_TRIM(lazy { Key.key("minecraft:trims/items/leggings_trim") }),
  BOLT(lazy { Key.key("minecraft:trims/models/armor/bolt") }),
  BOLT_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/bolt_leggings") }),
  COAST(lazy { Key.key("minecraft:trims/models/armor/coast") }),
  COAST_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/coast_leggings") }),
  DUNE(lazy { Key.key("minecraft:trims/models/armor/dune") }),
  DUNE_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/dune_leggings") }),
  EYE(lazy { Key.key("minecraft:trims/models/armor/eye") }),
  EYE_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/eye_leggings") }),
  FLOW(lazy { Key.key("minecraft:trims/models/armor/flow") }),
  FLOW_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/flow_leggings") }),
  HOST(lazy { Key.key("minecraft:trims/models/armor/host") }),
  HOST_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/host_leggings") }),
  RAISER(lazy { Key.key("minecraft:trims/models/armor/raiser") }),
  RAISER_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/raiser_leggings") }),
  RIB(lazy { Key.key("minecraft:trims/models/armor/rib") }),
  RIB_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/rib_leggings") }),
  SENTRY(lazy { Key.key("minecraft:trims/models/armor/sentry") }),
  SENTRY_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/sentry_leggings") }),
  SHAPER(lazy { Key.key("minecraft:trims/models/armor/shaper") }),
  SHAPER_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/shaper_leggings") }),
  SILENCE(lazy { Key.key("minecraft:trims/models/armor/silence") }),
  SILENCE_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/silence_leggings") }),
  SNOUT(lazy { Key.key("minecraft:trims/models/armor/snout") }),
  SNOUT_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/snout_leggings") }),
  SPIRE(lazy { Key.key("minecraft:trims/models/armor/spire") }),
  SPIRE_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/spire_leggings") }),
  TIDE(lazy { Key.key("minecraft:trims/models/armor/tide") }),
  TIDE_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/tide_leggings") }),
  VEX(lazy { Key.key("minecraft:trims/models/armor/vex") }),
  VEX_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/vex_leggings") }),
  WARD(lazy { Key.key("minecraft:trims/models/armor/ward") }),
  WARD_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/ward_leggings") }),
  WAYFINDER(lazy { Key.key("minecraft:trims/models/armor/wayfinder") }),
  WAYFINDER_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/wayfinder_leggings") }),
  WILD(lazy { Key.key("minecraft:trims/models/armor/wild") }),
  WILD_LEGGINGS(lazy { Key.key("minecraft:trims/models/armor/wild_leggings") }),
  ;

  public fun toGeneric(): SolidMaterialTexture = SolidMaterialTexture(key.value)
}
