/*
 * Decompiled with CFR 0.152.
 */
package io.github.suppierk.java.util.function;

import io.github.suppierk.java.util.ExceptionSuppressor;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowableFunction<T, R>
extends Function<T, R> {
    public R applyUnsafe(T var1) throws Throwable;

    @Override
    default public R apply(T t) {
        try {
            return this.applyUnsafe(t);
        }
        catch (Throwable throwable) {
            return ExceptionSuppressor.asUnchecked(throwable);
        }
    }

    public static <T> ThrowableFunction<T, T> identity() {
        return t -> t;
    }
}

