/*
 * Decompiled with CFR 0.152.
 */
package io.github.suppierk.java.util.function;

import io.github.suppierk.java.util.function.ThrowableBiFunction;
import java.util.Comparator;
import java.util.Objects;

@FunctionalInterface
public interface ThrowableBinaryOperator<T>
extends ThrowableBiFunction<T, T, T> {
    public static <T> ThrowableBinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> ThrowableBinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }
}

