/*
 * Decompiled with CFR 0.152.
 */
package io.github.suppierk.java;

import io.github.suppierk.java.util.ExceptionSuppressor;
import io.github.suppierk.java.util.function.ThrowableConsumer;
import io.github.suppierk.java.util.function.ThrowableFunction;
import io.github.suppierk.java.util.function.ThrowablePredicate;
import io.github.suppierk.java.util.function.ThrowableSupplier;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface Try<T> {
    public static <T> Try<T> of(ThrowableSupplier<T> supplier) {
        try {
            return Try.success(Objects.requireNonNull(supplier).get());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    public static <T> Try<T> fromOptional(Optional<T> optional) {
        try {
            if (Objects.requireNonNull(optional).isPresent()) {
                return Try.success(optional.get());
            }
            return Try.failure(new NoSuchElementException());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<T> failure(Throwable throwable) {
        return new Failure(throwable);
    }

    public T get();

    public boolean isSuccess();

    public boolean isFailure();

    public void ifSuccess(ThrowableConsumer<? super T> var1);

    public void ifFailure(ThrowableConsumer<Throwable> var1);

    public Try<T> filter(ThrowablePredicate<? super T> var1);

    public <U> Try<U> map(ThrowableFunction<? super T, ? extends U> var1);

    public <U> Try<U> flatMap(ThrowableFunction<? super T, Try<U>> var1);

    public Optional<T> toOptional();

    public Try<T> orElseTry(ThrowableSupplier<T> var1);

    default public T orElse(T other) {
        try {
            return this.get();
        }
        catch (Throwable t) {
            return other;
        }
    }

    default public T orElse(Supplier<? extends T> other) {
        try {
            return this.get();
        }
        catch (Throwable t) {
            return Objects.requireNonNull(other, "Try.orElseGet(Supplier) argument must not be null").get();
        }
    }

    public static class Success<T>
    implements Try<T> {
        private final T value;

        protected Success(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public void ifSuccess(ThrowableConsumer<? super T> consumer) {
            Objects.requireNonNull(consumer).accept(this.value);
        }

        @Override
        public void ifFailure(ThrowableConsumer<Throwable> consumer) {
        }

        @Override
        public Try<T> filter(ThrowablePredicate<? super T> predicate) {
            try {
                if (Objects.requireNonNull(predicate).test(this.get())) {
                    return this;
                }
                return Try.failure(new NoSuchElementException());
            }
            catch (Throwable t) {
                return Try.failure(t);
            }
        }

        @Override
        public <U> Try<U> map(ThrowableFunction<? super T, ? extends U> mapper) {
            return Try.of(() -> Objects.requireNonNull(mapper).apply(this.get()));
        }

        @Override
        public <U> Try<U> flatMap(ThrowableFunction<? super T, Try<U>> mapper) {
            try {
                return Objects.requireNonNull(mapper).apply(this.get());
            }
            catch (Throwable t) {
                return Try.failure(t);
            }
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.ofNullable(this.get());
        }

        @Override
        public Try<T> orElseTry(ThrowableSupplier<T> supplier) {
            Objects.requireNonNull(supplier, "Try.orElse argument must not be null");
            return this;
        }
    }

    public static class Failure<T>
    implements Try<T> {
        private final Throwable exception;

        protected Failure(Throwable exception) {
            this.exception = Objects.requireNonNull(exception, "Try.failure(Throwable) argument must not be null");
        }

        @Override
        public T get() {
            return (T)ExceptionSuppressor.asUnchecked(this.exception);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public void ifSuccess(ThrowableConsumer<? super T> consumer) {
        }

        @Override
        public void ifFailure(ThrowableConsumer<Throwable> consumer) {
            Objects.requireNonNull(consumer).accept(this.exception);
        }

        @Override
        public Try<T> filter(ThrowablePredicate<? super T> predicate) {
            return this;
        }

        @Override
        public <U> Try<U> map(ThrowableFunction<? super T, ? extends U> mapper) {
            return this;
        }

        @Override
        public <U> Try<U> flatMap(ThrowableFunction<? super T, Try<U>> mapper) {
            return this;
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.empty();
        }

        @Override
        public Try<T> orElseTry(ThrowableSupplier<T> supplier) {
            return Try.of(Objects.requireNonNull(supplier, "Try.orElse argument must not be null"));
        }
    }
}

