/*
 * Decompiled with CFR 0.152.
 */
package io.github.suppierk.java.util.function;

import io.github.suppierk.java.util.ExceptionSuppressor;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface ThrowableBinaryOperator<T>
extends BinaryOperator<T> {
    public T applyUnsafe(T var1, T var2) throws Throwable;

    @Override
    default public T apply(T t, T t2) {
        try {
            return this.applyUnsafe(t, t2);
        }
        catch (Throwable throwable) {
            return (T)ExceptionSuppressor.asUnchecked(throwable);
        }
    }

    public static <T> ThrowableBinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> ThrowableBinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }
}

