package wf.utils.db.models;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ImprovedSQLException extends RuntimeException {

    private final SQLException sqlException;


    public ImprovedSQLException(SQLException sqlException) {
        this.sqlException = sqlException;
    }

    public String getSQLState() {
        return sqlException.getSQLState();
    }

    public int getErrorCode() {
        return sqlException.getErrorCode();
    }

    public SQLException getNextException() {
        return sqlException.getNextException();
    }

    public void setNextException(SQLException ex) {
        sqlException.setNextException(ex);
    }

    public Iterator<Throwable> iterator() {
        return sqlException.iterator();
    }

    @Override
    public String getMessage() {
        return sqlException.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return sqlException.getLocalizedMessage();
    }

    @Override
    public Throwable getCause() {
        return sqlException.getCause();
    }

    @Override
    public Throwable initCause(Throwable cause) {
        return sqlException.initCause(cause);
    }

    @Override
    public String toString() {
        return sqlException.toString();
    }

    @Override
    public void printStackTrace() {
        sqlException.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        sqlException.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        sqlException.printStackTrace(s);
    }

    @Override
    public Throwable fillInStackTrace() {
        return sqlException.fillInStackTrace();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return sqlException.getStackTrace();
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        sqlException.setStackTrace(stackTrace);
    }

    public void forEach(Consumer<? super Throwable> action) {
        sqlException.forEach(action);
    }

    public Spliterator<Throwable> spliterator() {
        return sqlException.spliterator();
    }
}
