package wf.utils.db.table;

import wf.utils.db.entity.DBEntity;
import wf.utils.db.models.ImprovedPreparedStatement;

import java.sql.ResultSet;
import java.util.Optional;

public interface DBTable<E extends DBEntity<ID>, ID>{



    public Optional<E> findById(ID id);

    public boolean deleteById(ID id);

    public boolean update(E entity);

    public E save(E entity);

    public E parse(ResultSet resultSet);

    public String getTableName();

    public default ImprovedPreparedStatement parse(E entity, ImprovedPreparedStatement preparedStatement) {
        return parse(entity, preparedStatement, 1);
    }

    public ImprovedPreparedStatement parse(E entity, ImprovedPreparedStatement preparedStatement, int i);





}
