package wf.utils.db.utils;


import wf.utils.db.entity.DBEntity;
import java.util.UUID;

public class EntityUtils {


    public static String parseId(DBEntity<?> entity) {
        if(entity.getId() == null) return null;
        return entity.getId().toString();
    }

    @SuppressWarnings("unchecked")
    public static  <ID> DBEntity<ID> setId(DBEntity<ID> entity, String id) {
        Class<ID> idClass = entity.getIdClass();

        if(idClass == Integer.class)
            entity.setId((ID) new Integer(id));

        else if(idClass == Long.class)
            entity.setId((ID) new Long(id));

        else if(idClass == UUID.class)
            entity.setId((ID) UUID.fromString(id));

        else if(idClass == String.class)
            entity.setId((ID) id);


        return entity;
    }


}
