package wf.utils.db.entity;



import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public interface DBEntity<ID> {

    public ID getId();


    public void setId(ID id);


    @SuppressWarnings("unchecked")
    public default Class<ID> getIdClass() {
        for(Type type : getClass().getGenericInterfaces()) {
            if(!type.getTypeName().startsWith("wf.utils.db.entity.DBEntity"))
                continue;

            return (Class<ID>) ((ParameterizedType) type).getActualTypeArguments()[0];
        }
        return null;
    }


}
