package wf.utils.db.models;


import lombok.Getter;
import lombok.SneakyThrows;
import wf.utils.db.models.DBType;

import java.sql.*;
import java.util.Map;

@Getter
public class DBConnection {

    private final String hostname;
    private final String port;
    private final String database;
    private final String user;
    private final String password;
    private final DBType type;


    private volatile Connection connection;


    public DBConnection(String hostname, String port, String database, String user, String password) {
        this(hostname, port, database, password, user, DBType.MY_SQL);
    }

    public DBConnection(Map<String, String> parameters) {
        this(parameters.get("hostname"), parameters.get("port"), parameters.get("database"), parameters.get("password"),
                parameters.get("user"), DBType.valueOf(parameters.getOrDefault("type", "MY_SQL")));
    }

    public DBConnection(String hostname, String port, String database, String user, String password, DBType type) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
        this.type = type;


        try { Class.forName(type.getDriverPath()); }
        catch (ClassNotFoundException e) {throw new RuntimeException("DataBase driver " + type.getDriverPath() + " not found!", e);}

        connect();
    }



    public synchronized void connect() {
        try {
            if(connection != null && !connection.isClosed())
                return;

            this.connection = DriverManager.getConnection("jdbc:" + type.getTypeName() + "://" + this.hostname + ":" + this.port + "/" + this.database, this.user, this.password);
        } catch (SQLException sqlException) {
            throw new RuntimeException("DataBase connection failure", sqlException);
        }
    }

    public boolean checkConnection() {
        return connection != null;
    }


    @SneakyThrows
    public Connection getConnection() {
        if(connection == null || connection.isClosed())
            connect();

        return connection;
    }


    @SneakyThrows
    public void closeConnection() {
        if (connection != null || connection.isClosed()) {
            try {
                connection.close();
            } catch (SQLException sqlException) {
                throw new RuntimeException("DataBase connection close failure", sqlException);
            }
        }
    }

    @SneakyThrows
    public PreparedStatement preparedStatement(String sql) {
        if(connection == null || connection.isClosed())
            connect();

        return connection.prepareStatement(sql);
    }


    @SneakyThrows
    public PreparedStatement preparedStatement(String sql, int autoGeneratedKeys) {
        if(connection == null || connection.isClosed())
            connect();

        return connection.prepareStatement(sql, autoGeneratedKeys);
    }

}
