/*
 * Decompiled with CFR 0.152.
 */
package io.github.xfuns.java.fun;

import io.github.xfuns.java.Fun;
import io.github.xfuns.java.fun.ArrayFun;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

public class NumberFun {
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    public static double add(float v1, float v2) {
        return NumberFun.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return NumberFun.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(Double v1, Double v2) {
        return NumberFun.add((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return NumberFun.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(BigDecimal ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(value);
        }
        return result;
    }

    public static double sub(float v1, float v2) {
        return NumberFun.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return NumberFun.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(Double v1, Double v2) {
        return NumberFun.sub((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return NumberFun.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(BigDecimal ... values) {
        if (Fun.empty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(value);
        }
        return result;
    }

    public static double mul(float v1, float v2) {
        return NumberFun.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return NumberFun.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(Double v1, Double v2) {
        return NumberFun.mul((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return NumberFun.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (Fun.empty(values) || ArrayFun.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return NumberFun.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... values) {
        if (Fun.empty(values) || ArrayFun.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = new BigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(new BigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... values) {
        if (Fun.empty(values) || ArrayFun.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(values[i]);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return NumberFun.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return NumberFun.div(v1, v2, 10);
    }

    public static double div(Double v1, Double v2) {
        return NumberFun.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return NumberFun.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return NumberFun.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return NumberFun.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return NumberFun.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(Double v1, Double v2, int scale) {
        return NumberFun.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return NumberFun.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return NumberFun.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return NumberFun.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return NumberFun.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(Double v1, Double v2, int scale, RoundingMode roundingMode) {
        return NumberFun.div((Number)v1, (Number)v2, scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        return NumberFun.div(v1.toString(), v2.toString(), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return NumberFun.div(new BigDecimal(v1), new BigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        assert (v2 != null);
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static int[] range(int stop) {
        return NumberFun.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return NumberFun.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public static long factorial(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException("Factorial start and end both must be >= 0");
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        return NumberFun.factorialMultiplyAndCheck(start, NumberFun.factorial(start - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException("Overflow in multiplication");
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException("Factorial must have n >= 0 and n <= 20");
        }
        return FACTORIALS[(int)n];
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / NumberFun.divisor(m, n);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static BigDecimal calculate(String firstValue, String secondValue, char ops) {
        BigDecimal result;
        switch (ops) {
            case '+': {
                result = NumberFun.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = NumberFun.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = NumberFun.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = NumberFun.div(firstValue, secondValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + ops);
            }
        }
        return result;
    }
}

