/*
 * Decompiled with CFR 0.152.
 */
package io.github.xfuns.java.fun;

import io.github.xfuns.java.Fun;
import java.util.concurrent.ThreadLocalRandom;

public class RandomFun {
    public static final String RANDOM_UPPER_LETTER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String RANDOM_LOWER_LETTER = "abcdefghijklmnopqrstuvwxyz";
    public static final String RANDOM_NUMBER = "0123456789";
    public static final String RANDOM_LETTER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String RANDOM_LETTER_NUMBER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    private RandomFun() {
        throw new AssertionError();
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static int randomInt() {
        return RandomFun.getRandom().nextInt();
    }

    public static int randomInt(int min, int max) {
        return RandomFun.getRandom().nextInt(min, max);
    }

    public static int randomInt(int max) {
        return RandomFun.getRandom().nextInt(max);
    }

    public static long randomLong(long min, long max) {
        return RandomFun.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomFun.getRandom().nextLong();
    }

    public static long randomLong(long max) {
        return RandomFun.getRandom().nextLong(max);
    }

    public static String randomString(int length) {
        return RandomFun.randomPool(RANDOM_LETTER_NUMBER, length);
    }

    public static String randomStringExcept(int length, String ... excepts) {
        String pool = RANDOM_LETTER_NUMBER;
        pool = Fun.removeAny((CharSequence)pool, excepts);
        return RandomFun.randomPool(pool, length);
    }

    public static String randomNumber(int length) {
        return RandomFun.randomPool(RANDOM_NUMBER, length);
    }

    public static String randomLetter(int length) {
        return RandomFun.randomPool(RANDOM_LETTER, length);
    }

    public static String randomPool(String baseString, int length) {
        if (Fun.empty(baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomFun.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }
}

