/*
 * Decompiled with CFR 0.152.
 */
package io.github.xfuns.java.fun;

import io.github.xfuns.java.fun.NumberFun;

public class SimilarityFun {
    private SimilarityFun() {
        throw new AssertionError();
    }

    public static double similarity(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = SimilarityFun.removeSign(strB);
            newStrB = SimilarityFun.removeSign(strA);
        } else {
            newStrA = SimilarityFun.removeSign(strA);
            newStrB = SimilarityFun.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int temp2 = SimilarityFun.longestCommonSubstring(newStrA, newStrB).length();
        return NumberFun.div(temp2, temp);
    }

    public static String similarity(String strA, String strB, int scale) {
        return NumberFun.formatPercent(SimilarityFun.similarity(strA, strB), scale);
    }

    private static String removeSign(String str) {
        return str.replaceAll("[\\pP\\pS\\pZ\\pC]", "");
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] charsStrA = strA.toCharArray();
        char[] charsStrB = strB.toCharArray();
        int m = charsStrA.length;
        int n = charsStrB.length;
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = charsStrA[i - 1] == charsStrB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = charsStrA[m - 1];
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    public static double strSim(String a, String b) {
        int len1 = a.length();
        int len2 = b.length();
        if (len1 == 0 || len2 == 0) {
            return 0.0;
        }
        double ratio = len1 > len2 ? ((double)len1 + 0.0) / (double)len2 : ((double)len2 + 0.0) / (double)len1;
        if (ratio >= 3.0) {
            return 0.0;
        }
        return ((double)SimilarityFun.lcs(a, b) + 0.0) / (double)Math.max(len1, len2);
    }

    public static int lcs(String x, String y) {
        int m = x.length();
        int n = y.length();
        if (m == 0 || n == 0) {
            return 0;
        }
        int[][] opt = new int[m + 1][n + 1];
        for (int i = m - 1; i >= 0; --i) {
            for (int j = n - 1; j >= 0; --j) {
                opt[i][j] = x.charAt(i) == y.charAt(j) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        return opt[0][0];
    }
}

