package com.livehelps.dify.api.callback;

import com.livehelps.dify.data.event.NodeFinishedEvent;
import com.livehelps.dify.data.event.NodeStartedEvent;
import com.livehelps.dify.data.event.WorkflowFinishedEvent;
import com.livehelps.dify.data.event.WorkflowStartedEvent;

/**
 * 工作流编排对话型应用流式回调接口
 */
public interface ChatflowStreamCallback extends ChatStreamCallback {
    /**
     * 工作流开始事件
     */
    default void onWorkflowStarted(WorkflowStartedEvent event) {
    }

    /**
     * 节点开始事件
     */
    default void onNodeStarted(NodeStartedEvent event) {
    }

    /**
     * 节点完成事件
     */
    default void onNodeFinished(NodeFinishedEvent event) {
    }

    /**
     * 工作流完成事件
     */
    default void onWorkflowFinished(WorkflowFinishedEvent event) {
    }
}
