package com.livehelps.dify.service;

import com.livehelps.dify.data.request.ChatMessageRequest;
import com.livehelps.dify.data.request.StopChatMessageRequest;
import com.livehelps.dify.data.response.ChatMessageResponse;
import com.livehelps.dify.data.response.StopChatMessageResponse;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Streaming;

public interface DifyChatApiService extends DifyMessageSuggestedApiService,DifyConversationApiService,DifyFeedBackApiService,DifySpeechToTextConversionApiService{

    @POST("chat-messages")
    Call<ChatMessageResponse> sendChatMessage(@Body ChatMessageRequest message);

    @POST("chat-messages")
    @Streaming
    Call<ResponseBody> sendChatMessageStream(@Body ChatMessageRequest message);

    @POST("chat-messages/{task_id}/stop")
    Call<StopChatMessageResponse> stopChatMessage(@Path("task_id")String taskId, @Body StopChatMessageRequest user);
}
