/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.livehelps.dify.api.callback.StreamCallback;
import com.livehelps.dify.api.interceptor.AuthenticationInterceptor;
import com.livehelps.dify.api.proxy.CustomHttpProxySelector;
import com.livehelps.dify.api.proxy.CustomProxyAuthenticator;
import com.livehelps.dify.data.event.BaseEvent;
import com.livehelps.dify.exception.DifyApiError;
import com.livehelps.dify.exception.DifyApiException;
import com.livehelps.dify.util.JSONUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DIfyApiServiceGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DIfyApiServiceGenerator.class);
    private static volatile OkHttpClient sharedClient = DIfyApiServiceGenerator.createDefaultHttpClient();
    private static final String DONE_MARKER = "[DONE]";
    private static final String DATA_PREFIX = "data:";
    private static final Converter.Factory converterFactory = JacksonConverterFactory.create((ObjectMapper)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE));
    private static final Converter<ResponseBody, DifyApiError> errorBodyConverter = converterFactory.responseBodyConverter(DifyApiError.class, new Annotation[0], null);

    public static OkHttpClient createDefaultHttpClient() {
        return new OkHttpClient.Builder().callTimeout(120L, TimeUnit.SECONDS).pingInterval(20L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).build();
    }

    public static void configureHttpClient(OkHttpClient client) {
        Objects.requireNonNull(client, "Client cannot be null");
        sharedClient = client;
    }

    public static void setHttpProxy(String host, int port, String username, String pwd) {
        Objects.requireNonNull(host, "Host cannot be null");
        CustomHttpProxySelector proxySelector = new CustomHttpProxySelector(host, port);
        sharedClient = sharedClient.newBuilder().proxySelector((ProxySelector)proxySelector).build();
        if (username == null || pwd == null) {
            return;
        }
        CustomProxyAuthenticator proxyAuthenticator = new CustomProxyAuthenticator(username, pwd);
        sharedClient = sharedClient.newBuilder().proxyAuthenticator((Authenticator)proxyAuthenticator).build();
    }

    public static <S> S createService(Class<S> serviceClass, String apiKey, String baseUrl) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory(converterFactory);
        if (apiKey == null) {
            retrofitBuilder.client(sharedClient);
        } else {
            AuthenticationInterceptor interceptor = new AuthenticationInterceptor(apiKey);
            OkHttpClient adaptedClient = sharedClient.newBuilder().addInterceptor((Interceptor)interceptor).build();
            retrofitBuilder.client(adaptedClient);
        }
        Retrofit retrofit = retrofitBuilder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            DifyApiError apiError = DIfyApiServiceGenerator.getDifyApiError(response);
            throw new DifyApiException(apiError);
        }
        catch (IOException e) {
            log.error("exceute sync error {}", (Throwable)e);
            throw new DifyApiException(e);
        }
    }

    public static void executeStreamRequest(Call<ResponseBody> call, final LineProcessor lineProcessor, final Consumer<Throwable> errorHandler) {
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable e) {
                log.error("stream request error {}", e);
                errorHandler.accept(e);
            }

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (!response.isSuccessful()) {
                    try {
                        String errorBody = response.body() != null ? ((ResponseBody)response.body()).string() : "";
                        DifyApiException exception = DIfyApiServiceGenerator.createDifyApiException(response.code(), errorBody);
                        log.error("stream request error {}", (Throwable)exception);
                        errorHandler.accept(exception);
                    }
                    catch (IOException e) {
                        log.error("stream request error {}", (Throwable)e);
                        errorHandler.accept(e);
                    }
                    return;
                }
                try (ResponseBody responseBody = (ResponseBody)response.body();){
                    if (responseBody == null) {
                        IOException exception = new IOException("response is null");
                        errorHandler.accept(exception);
                        return;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody.byteStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null && (line.isEmpty() || lineProcessor.process(line))) {
                        }
                    }
                }
                catch (Exception e) {
                    log.error("process stream response error {}", (Throwable)e);
                    errorHandler.accept(e);
                }
            }
        });
    }

    private static DifyApiException createDifyApiException(int code, String message) {
        String errorCode = "unknown_error";
        String errorMessage = message;
        try {
            DifyApiError error;
            if (message != null && !message.isEmpty() && JSONUtils.isValidJson(message) && (error = JSONUtils.fromJson(message, DifyApiError.class)) != null) {
                return new DifyApiException(error);
            }
        }
        catch (Exception error) {
            // empty catch block
        }
        DifyApiError difyApiError = new DifyApiError(code, errorCode, errorMessage);
        return new DifyApiException(difyApiError);
    }

    public static boolean processStreamLine(String line, StreamCallback callback, EventProcessor eventProcessor) {
        if (line.startsWith(DATA_PREFIX)) {
            String data = line.substring(DATA_PREFIX.length()).trim();
            if (DONE_MARKER.equals(data)) {
                callback.onComplete();
                return false;
            }
            try {
                BaseEvent baseEvent = JSONUtils.fromJson(data, BaseEvent.class);
                if (baseEvent == null) {
                    return true;
                }
                eventProcessor.process(data, baseEvent.getEvent());
            }
            catch (Exception e) {
                callback.onException(e);
            }
        }
        return true;
    }

    public static DifyApiError getDifyApiError(Response<?> response) throws DifyApiException, IOException {
        Objects.requireNonNull(errorBodyConverter);
        ResponseBody responseBody = response.errorBody();
        Objects.requireNonNull(responseBody);
        if (responseBody.contentLength() <= 0L) {
            return new DifyApiError(response.code(), response.message());
        }
        return (DifyApiError)errorBodyConverter.convert((Object)responseBody);
    }

    @FunctionalInterface
    public static interface EventProcessor {
        public void process(String var1, String var2);
    }

    @FunctionalInterface
    public static interface LineProcessor {
        public boolean process(String var1);
    }
}

