/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api;

import com.livehelps.dify.DIfyApiServiceGenerator;
import com.livehelps.dify.api.callback.CompletionStreamCallback;
import com.livehelps.dify.api.callback.StreamEventDispatcher;
import com.livehelps.dify.data.enums.AnnotationReplyAction;
import com.livehelps.dify.data.request.AnnotationReplyRequest;
import com.livehelps.dify.data.request.AnnotationRequest;
import com.livehelps.dify.data.request.CompletionMessageRequest;
import com.livehelps.dify.data.request.FeedBackRequest;
import com.livehelps.dify.data.request.StopCompletionMessageRequest;
import com.livehelps.dify.data.request.TextToAudioRequest;
import com.livehelps.dify.data.response.Annotation;
import com.livehelps.dify.data.response.AnnotationListResponse;
import com.livehelps.dify.data.response.AnnotationReplyResponse;
import com.livehelps.dify.data.response.ChatCompletionResponse;
import com.livehelps.dify.data.response.FeedBackListResponse;
import com.livehelps.dify.data.response.LittleResponse;
import com.livehelps.dify.data.response.StopCompletionMessageResponse;
import com.livehelps.dify.service.DifyCompletionApiService;
import java.io.IOException;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class DIfyCompletionApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DIfyCompletionApi.class);
    private final DifyCompletionApiService completionApiService;

    public DIfyCompletionApi(String baseUrl, String apiKey) {
        this.completionApiService = DIfyApiServiceGenerator.createService(DifyCompletionApiService.class, apiKey, baseUrl);
    }

    public ChatCompletionResponse sendCompletionMessage(CompletionMessageRequest message) {
        log.debug("send completion message: {}", (Object)message);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.sendCompletionMessage(message));
    }

    public void sendCompletionMessageStream(CompletionMessageRequest message, CompletionStreamCallback callback) {
        log.debug("send completion message stream: {}", (Object)message);
        Call<ResponseBody> call = this.completionApiService.sendCompletionMessageStream(message);
        DIfyApiServiceGenerator.executeStreamRequest(call, line -> DIfyApiServiceGenerator.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchCompletionEvent(callback, data)), callback::onException);
    }

    public StopCompletionMessageResponse stopCompletionMessage(String taskId, StopCompletionMessageRequest request) {
        log.debug("stop completion message taskId {} request: {}", (Object)taskId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.stopCompletionMessage(taskId, request));
    }

    public LittleResponse feedbackMessage(String messageId, FeedBackRequest request) {
        log.debug("feedback completion message messageId {} request: {}", (Object)messageId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.feedbackMessage(messageId, request));
    }

    public FeedBackListResponse getFeedBackList(Integer page, Integer limit) {
        log.debug("get feed back list page {} limit: {}", (Object)page, (Object)limit);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.getAppfeedbacks(page, limit));
    }

    public byte[] textToAudio(TextToAudioRequest request) throws IOException {
        ResponseBody responseBody = DIfyApiServiceGenerator.executeSync(this.completionApiService.textToAudio(request));
        return responseBody.bytes();
    }

    public Annotation createAnnotation(AnnotationRequest request) {
        log.debug("create annotation request: {}", (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.createAnnotation(request));
    }

    public AnnotationListResponse getAnnotationList(Integer page, Integer limit) {
        log.debug("get annotation list page {} limit: {}", (Object)page, (Object)limit);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.getAnnotationList(page, limit));
    }

    public void deleteAnnotation(String id) {
        log.debug("delete annotation id: {}", (Object)id);
        DIfyApiServiceGenerator.executeSync(this.completionApiService.deleteAnnotation(id));
    }

    public Annotation updateAnnotation(String id, AnnotationRequest request) {
        log.debug("update annotation id: {} request: {}", (Object)id, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.updateAnnotation(id, request));
    }

    public AnnotationReplyResponse annotationReply(AnnotationReplyAction action, AnnotationReplyRequest request) {
        log.debug("annotation reply action: {} request: {}", (Object)action, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.annotationReply(action, request));
    }

    public AnnotationReplyResponse getAnnotationReplyStatus(AnnotationReplyAction action, String jobId) {
        log.debug("get annotation reply status action: {} jobId: {}", (Object)action, (Object)jobId);
        return DIfyApiServiceGenerator.executeSync(this.completionApiService.getAnnotationReplyStatus(action, jobId));
    }
}

