/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api;

import com.livehelps.dify.DIfyApiServiceGenerator;
import com.livehelps.dify.data.request.UploadFileRequest;
import com.livehelps.dify.data.response.AppInfoResponse;
import com.livehelps.dify.data.response.AppMetaInfoResponse;
import com.livehelps.dify.data.response.AppParametersResponse;
import com.livehelps.dify.data.response.UploadFileResponse;
import com.livehelps.dify.data.response.WebAppResponse;
import com.livehelps.dify.service.DifyBaseApiService;
import java.io.File;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifyBaseApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyBaseApi.class);
    private final String baseUrl;
    private final String apiKey;
    private final DifyBaseApiService difyBaseApiService;

    public DifyBaseApi(String baseUrl, String apiKey) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.difyBaseApiService = DIfyApiServiceGenerator.createService(DifyBaseApiService.class, apiKey, baseUrl);
    }

    public AppInfoResponse getAppInfo() {
        return DIfyApiServiceGenerator.executeSync(this.difyBaseApiService.getAppInfo());
    }

    public AppParametersResponse getAppParameters() {
        return DIfyApiServiceGenerator.executeSync(this.difyBaseApiService.getAppParameters());
    }

    public AppMetaInfoResponse getAppMetaInfo() {
        return DIfyApiServiceGenerator.executeSync(this.difyBaseApiService.getAppMetaInfo());
    }

    public WebAppResponse getWebAppInfo() {
        return DIfyApiServiceGenerator.executeSync(this.difyBaseApiService.getWebAppInfo());
    }

    public UploadFileResponse uploadFile(UploadFileRequest request, File file) {
        RequestBody requestFile = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        MultipartBody.Part userPart = MultipartBody.Part.createFormData((String)"user", (String)request.getUser());
        return DIfyApiServiceGenerator.executeSync(this.difyBaseApiService.uploadFile(filePart, userPart));
    }
}

