/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api;

import com.livehelps.dify.DIfyApiServiceGenerator;
import com.livehelps.dify.api.callback.ChatflowStreamCallback;
import com.livehelps.dify.api.callback.StreamEventDispatcher;
import com.livehelps.dify.data.enums.AnnotationReplyAction;
import com.livehelps.dify.data.enums.ResponseMode;
import com.livehelps.dify.data.request.AnnotationReplyRequest;
import com.livehelps.dify.data.request.AnnotationRequest;
import com.livehelps.dify.data.request.ChatMessageRequest;
import com.livehelps.dify.data.request.FeedBackRequest;
import com.livehelps.dify.data.request.SimpleUserRequest;
import com.livehelps.dify.data.request.StopChatMessageRequest;
import com.livehelps.dify.data.request.TextToAudioRequest;
import com.livehelps.dify.data.response.Annotation;
import com.livehelps.dify.data.response.AnnotationListResponse;
import com.livehelps.dify.data.response.AnnotationReplyResponse;
import com.livehelps.dify.data.response.AudioToTextResponse;
import com.livehelps.dify.data.response.ChatMessageListResponse;
import com.livehelps.dify.data.response.ChatMessageResponse;
import com.livehelps.dify.data.response.ConversationListResponse;
import com.livehelps.dify.data.response.ConversationVariablesResponse;
import com.livehelps.dify.data.response.FeedBackListResponse;
import com.livehelps.dify.data.response.LittleResponse;
import com.livehelps.dify.data.response.StopChatMessageResponse;
import com.livehelps.dify.data.response.SuggestedQuestionsResponse;
import com.livehelps.dify.service.DifyChatFlowApiService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class DifyChatFlowApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyChatFlowApi.class);
    private final DifyChatFlowApiService chatFlowApiService;

    public DifyChatFlowApi(String baseUrl, String apiKey) {
        this.chatFlowApiService = DIfyApiServiceGenerator.createService(DifyChatFlowApiService.class, apiKey, baseUrl);
    }

    public ChatMessageResponse sendChatMessage(ChatMessageRequest message) {
        log.debug("send chat message: {}", (Object)message);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.sendChatMessage(message));
    }

    public void sendChatMessageStream(ChatMessageRequest message, ChatflowStreamCallback callback) {
        log.debug("send stream chat message: user={}, inputs={}", (Object)message.getUser(), message.getInputs() != null ? message.getInputs().keySet() : null);
        message.setResponseMode(ResponseMode.STREAMING);
        Call<ResponseBody> call = this.chatFlowApiService.sendChatMessageStream(message);
        DIfyApiServiceGenerator.executeStreamRequest(call, line -> DIfyApiServiceGenerator.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchChatFlowEvent(callback, data, eventType)), callback::onException);
    }

    public StopChatMessageResponse stopChatMessage(String taskId, StopChatMessageRequest request) {
        log.debug("stop chat message taskId {} request: {}", (Object)taskId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.stopChatMessage(taskId, request));
    }

    public SuggestedQuestionsResponse getSuggestedQuestions(String messageId, String user) {
        log.debug("get suggested questions messageId={}, user={}", (Object)messageId, (Object)user);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getSuggestedQuestions(messageId, user));
    }

    public ConversationListResponse getConversations(String user, String lastId, Integer limit, String sortBy) {
        log.debug("get Conversations list user={}, lastId={}, limit={}, sortBy={}", new Object[]{user, lastId, limit, sortBy});
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getConversations(user, lastId, limit, sortBy));
    }

    public ChatMessageListResponse getMessages(String conversationId, String user, String firstId, Integer limit) {
        log.debug("get message list : conversationId={}, user={}, firstId={}, limit={}", new Object[]{conversationId, user, firstId, limit});
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getMessages(conversationId, user, firstId, limit));
    }

    public LittleResponse deleteConversation(String conversationId, SimpleUserRequest user) {
        log.debug("delete Conversation: conversationId={}, user={}", (Object)conversationId, (Object)user.getUser());
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.deleteConversation(conversationId, user));
    }

    public ConversationVariablesResponse getConversationVariables(String conversationId, String user, String lastId, Integer limit, String variableName) {
        log.debug("get Conversation Variables list : conversationId={}, user={}, lastId={}, limit={}.variableName={}", new Object[]{conversationId, user, lastId, limit, variableName});
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getConversationVariables(conversationId, user, lastId, limit, variableName));
    }

    public LittleResponse feedbackMessage(String messageId, FeedBackRequest request) {
        log.debug("message feedback: messageId={}, rating={}, user={}", new Object[]{messageId, request.getRating(), request.getUser()});
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.feedbackMessage(messageId, request));
    }

    public FeedBackListResponse getFeedBackList(Integer page, Integer limit) {
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getAppfeedbacks(page, limit));
    }

    public byte[] textToAudio(TextToAudioRequest request) throws IOException {
        ResponseBody responseBody = DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.textToAudio(request));
        return responseBody.bytes();
    }

    public AudioToTextResponse audioToText(File file, String user) throws IOException {
        log.debug("audioToText: fileName={}, user={}", (Object)file.getName(), (Object)user);
        Path filePath = file.toPath();
        String mimeType = Files.probeContentType(filePath);
        RequestBody requestFile = RequestBody.create((File)file, (MediaType)MediaType.parse((String)mimeType));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        MultipartBody.Part userPart = MultipartBody.Part.createFormData((String)"user", (String)user);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.audioToText(filePart, userPart));
    }

    public Annotation createAnnotation(AnnotationRequest request) {
        log.debug("create annotation request: {}", (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.createAnnotation(request));
    }

    public AnnotationListResponse getAnnotationList(Integer page, Integer limit) {
        log.debug("get annotation list page {} limit: {}", (Object)page, (Object)limit);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getAnnotationList(page, limit));
    }

    public void deleteAnnotation(String id) {
        log.debug("delete annotation id: {}", (Object)id);
        DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.deleteAnnotation(id));
    }

    public Annotation updateAnnotation(String id, AnnotationRequest request) {
        log.debug("update annotation id: {} request: {}", (Object)id, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.updateAnnotation(id, request));
    }

    public AnnotationReplyResponse annotationReply(AnnotationReplyAction action, AnnotationReplyRequest request) {
        log.debug("annotation reply action: {} request: {}", (Object)action, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.annotationReply(action, request));
    }

    public AnnotationReplyResponse getAnnotationReplyStatus(AnnotationReplyAction action, String jobId) {
        log.debug("get annotation reply status action: {} jobId: {}", (Object)action, (Object)jobId);
        return DIfyApiServiceGenerator.executeSync(this.chatFlowApiService.getAnnotationReplyStatus(action, jobId));
    }
}

