/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api;

import com.livehelps.dify.DIfyApiServiceGenerator;
import com.livehelps.dify.data.request.datasets.CreateDatasetRequest;
import com.livehelps.dify.data.request.datasets.CreateDocumentByFileRequest;
import com.livehelps.dify.data.request.datasets.CreateDocumentByTextRequest;
import com.livehelps.dify.data.request.datasets.CreateMetadataRequest;
import com.livehelps.dify.data.request.datasets.CreateSegmentsRequest;
import com.livehelps.dify.data.request.datasets.RetrieveRequest;
import com.livehelps.dify.data.request.datasets.SubmitChildChunkRequest;
import com.livehelps.dify.data.request.datasets.UpdateDatasetRequest;
import com.livehelps.dify.data.request.datasets.UpdateDocumentByFileRequest;
import com.livehelps.dify.data.request.datasets.UpdateDocumentByTextRequest;
import com.livehelps.dify.data.request.datasets.UpdateDocumentMetadataRequest;
import com.livehelps.dify.data.request.datasets.UpdateMetadataRequest;
import com.livehelps.dify.data.request.datasets.UpdateSegmentsRequest;
import com.livehelps.dify.data.response.datasets.ChildChunkListResponse;
import com.livehelps.dify.data.response.datasets.ChildChunkResponse;
import com.livehelps.dify.data.response.datasets.CreateSegmentResponse;
import com.livehelps.dify.data.response.datasets.DatasetListResponse;
import com.livehelps.dify.data.response.datasets.DatasetMetadataResponse;
import com.livehelps.dify.data.response.datasets.DatasetResponse;
import com.livehelps.dify.data.response.datasets.DocumentIndexingStatusResponse;
import com.livehelps.dify.data.response.datasets.DocumentListResponse;
import com.livehelps.dify.data.response.datasets.DocumentResponse;
import com.livehelps.dify.data.response.datasets.DocumentUploadFileResponse;
import com.livehelps.dify.data.response.datasets.EmbeddingModelListResponse;
import com.livehelps.dify.data.response.datasets.MetadataResponse;
import com.livehelps.dify.data.response.datasets.RetrieveResponse;
import com.livehelps.dify.data.response.datasets.SegmentListResponse;
import com.livehelps.dify.data.response.datasets.UpdateSegmentResponse;
import com.livehelps.dify.service.DifyDatasetsApiService;
import com.livehelps.dify.util.JSONUtils;
import java.io.File;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifyDatasetsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyDatasetsApi.class);
    private final DifyDatasetsApiService datasetsApiService;

    public DifyDatasetsApi(String baseUrl, String apiKey) {
        this.datasetsApiService = DIfyApiServiceGenerator.createService(DifyDatasetsApiService.class, apiKey, baseUrl);
    }

    public DatasetResponse createDataset(CreateDatasetRequest request) {
        log.debug("create dataset: request={}", (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createDataset(request));
    }

    public DatasetResponse updateDataset(String datasetId, UpdateDatasetRequest request) {
        log.debug("update dataset: datasetId={}, request={}", (Object)datasetId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateDataset(datasetId, request));
    }

    public DatasetListResponse listDataset(Integer page, Integer limit) {
        log.debug("query dataset list");
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listDataset(page, limit));
    }

    public DatasetResponse getDataset(String datasetId) {
        log.info("get dataset info: datasetId={}", (Object)datasetId);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.getDataset(datasetId));
    }

    public void deleteDataset(String datasetId) {
        log.debug("delete dataset: datasetId={}", (Object)datasetId);
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.deleteDataset(datasetId));
    }

    public DocumentResponse createDocumentByText(String datasetId, CreateDocumentByTextRequest request) {
        log.debug("create document by text: datasetId={}, request={}", (Object)datasetId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createDocumentByText(datasetId, request));
    }

    public DocumentResponse createDocumentByFile(String datasetId, File file, CreateDocumentByFileRequest request) {
        log.debug("create document by file: datasetId={}, fileName={}, request={}", new Object[]{datasetId, file.getName(), request});
        RequestBody fileRequestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileRequestBody);
        MultipartBody.Part dataPart = MultipartBody.Part.createFormData((String)"data", (String)JSONUtils.toJson(request));
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createDocumentByFile(datasetId, filePart, dataPart));
    }

    public DocumentResponse updateDocumentByText(String datasetId, String documentId, UpdateDocumentByTextRequest request) {
        log.debug("update document by text: datasetId={}, documentId={}, request={}", new Object[]{datasetId, documentId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateDocumentByText(datasetId, documentId, request));
    }

    public DocumentResponse updateDocumentByFile(String datasetId, String documentId, File file, UpdateDocumentByFileRequest request) {
        log.debug("update document by file: datasetId={}, documentId={}, fileName={}, request={}", new Object[]{datasetId, documentId, file.getName(), request});
        RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestBody);
        MultipartBody.Part dataPart = MultipartBody.Part.createFormData((String)"data", (String)JSONUtils.toJson(request));
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateDocumentByFile(datasetId, documentId, filePart, dataPart));
    }

    public DocumentIndexingStatusResponse getDocumentIndexingStatus(String datasetId, String batch) {
        log.debug("get document indexing status: datasetId={}, batch={}", (Object)datasetId, (Object)batch);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.getDocumentIndexingStatus(datasetId, batch));
    }

    public void deleteDocument(String datasetId, String documentId) {
        log.debug("delete document: datasetId={}, documentId={}", (Object)datasetId, (Object)documentId);
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.deleteDocument(datasetId, documentId));
    }

    public DocumentListResponse listDocuments(String datasetId, String keyword, Integer page, Integer limit) {
        log.debug("query document list: datasetId={}", (Object)datasetId);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listDocuments(datasetId, keyword, page, limit));
    }

    public CreateSegmentResponse createDocumentSegments(String datasetId, String documentId, CreateSegmentsRequest request) {
        log.debug("create document segments: datasetId={}, documentId={}, request={}", new Object[]{datasetId, documentId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createDocumentSegments(datasetId, documentId, request));
    }

    public UpdateSegmentResponse updateDocumentSegment(String datasetId, String documentId, String segmentId, UpdateSegmentsRequest request) {
        log.debug("update document segments: datasetId={}, documentId={}, segmentId={} request={}", new Object[]{datasetId, documentId, segmentId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateDocumentSegment(datasetId, documentId, segmentId, request));
    }

    public SegmentListResponse listDocumentSegments(String datasetId, String documentId, String keyword, String status, Integer page, Integer limit) {
        log.debug("query document segments: datasetId={}, documentId={}, keyword={}", new Object[]{datasetId, documentId, keyword});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listDocumentSegments(datasetId, documentId, keyword, status, page, limit));
    }

    public void deleteDocumentSegment(String datasetId, String documentId, String segmentId) {
        log.debug("query document segments: datasetId={}, documentId={}, segmentId={}", new Object[]{datasetId, documentId, segmentId});
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.deleteDocumentSegment(datasetId, documentId, segmentId));
    }

    public ChildChunkResponse createChildChunk(String datasetId, String documentId, String segmentId, SubmitChildChunkRequest request) {
        log.debug("create document child chunk: datasetId={}, documentId={}, segmentId={}, request={}", new Object[]{datasetId, documentId, segmentId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createChildChunk(datasetId, documentId, segmentId, request));
    }

    public ChildChunkResponse updateChildChunk(String datasetId, String documentId, String segmentId, String childChunkId, SubmitChildChunkRequest request) {
        log.debug("create document child chunk: datasetId={}, documentId={}, segmentId={}, childChunkId={}, request={}", new Object[]{datasetId, documentId, segmentId, childChunkId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateChildChunk(datasetId, documentId, segmentId, childChunkId, request));
    }

    public ChildChunkListResponse listChildChunks(String datasetId, String documentId, String segmentId, String keyword, Integer page, Integer limit) {
        log.debug("query document child chunk list: datasetId={}, documentId={}, segmentId={}, keyword={}", new Object[]{datasetId, documentId, segmentId, keyword});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listChildChunks(datasetId, documentId, segmentId, keyword, page, limit));
    }

    public void deleteChildChunk(String datasetId, String documentId, String segmentId, String childChunkId) {
        log.debug("delete document child chunk: datasetId={}, documentId={}, segmentId={}, childChunkId={}", new Object[]{datasetId, documentId, segmentId, childChunkId});
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.deleteChildChunk(datasetId, documentId, segmentId, childChunkId));
    }

    public DocumentUploadFileResponse getDocumentUploadFile(String datasetId, String documentId) {
        log.info("get document upload file info: datasetId={}, documentId={}", (Object)datasetId, (Object)documentId);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.getDocumentUploadFile(datasetId, documentId));
    }

    public MetadataResponse createMetadata(String datasetId, CreateMetadataRequest request) {
        log.info("create dataset metadata: datasetId={}, request={}", (Object)datasetId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.createMetadata(datasetId, request));
    }

    public MetadataResponse updateMetadata(String datasetId, String metadataId, UpdateMetadataRequest request) {
        log.info("update dataset metadata: datasetId={}, metadataId={}, request={}", new Object[]{datasetId, metadataId, request});
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateMetadata(datasetId, metadataId, request));
    }

    public void deleteMetadata(String datasetId, String metadataId) {
        log.info("delete dataset metadata: datasetId={}, metadataId={}", (Object)datasetId, (Object)metadataId);
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.deleteMetadata(datasetId, metadataId));
    }

    public void toggleBuiltInMetadata(String datasetId, String action) {
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.toggleBuiltInMetadata(datasetId, action));
    }

    public void updateDocumentMetadata(String datasetId, UpdateDocumentMetadataRequest request) {
        log.debug("update document metadata: datasetId={}, request={}", (Object)datasetId, (Object)request);
        DIfyApiServiceGenerator.executeSync(this.datasetsApiService.updateDocumentMetadata(datasetId, request));
    }

    public DatasetMetadataResponse listDatasetMetadata(String datasetId) {
        log.debug("query datasets metadata list: datasetId={}", (Object)datasetId);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listDatasetMetadata(datasetId));
    }

    public EmbeddingModelListResponse listEmbeddingModels() {
        log.debug("get datasets embedding models");
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.listEmbeddingModels());
    }

    public RetrieveResponse retrieveDataset(String datasetId, RetrieveRequest request) {
        log.debug("retrieve dataset: datasetId={}, request={}", (Object)datasetId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.datasetsApiService.retrieveDataset(datasetId, request));
    }
}

