/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api;

import com.livehelps.dify.DIfyApiServiceGenerator;
import com.livehelps.dify.api.callback.StreamEventDispatcher;
import com.livehelps.dify.api.callback.WorkflowStreamCallback;
import com.livehelps.dify.data.enums.ResponseMode;
import com.livehelps.dify.data.request.SimpleUserRequest;
import com.livehelps.dify.data.request.WorkflowRunRequest;
import com.livehelps.dify.data.response.WorkflowLogListResponse;
import com.livehelps.dify.data.response.WorkflowRunResponse;
import com.livehelps.dify.data.response.WorkflowRunStatusResponse;
import com.livehelps.dify.data.response.WorkflowStopResponse;
import com.livehelps.dify.service.DifyWorkflowApiService;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class DifyWorkflowApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyWorkflowApi.class);
    private final DifyWorkflowApiService workflowApiService;

    public DifyWorkflowApi(String baseUrl, String apiKey) {
        this.workflowApiService = DIfyApiServiceGenerator.createService(DifyWorkflowApiService.class, apiKey, baseUrl);
    }

    public WorkflowRunResponse runWorkflow(WorkflowRunRequest request) {
        log.debug("run workflow, request={}", (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.workflowApiService.runWorkflow(request));
    }

    public void runWorkflowStream(WorkflowRunRequest request, WorkflowStreamCallback callback) {
        log.debug("run stream workflow, request={}", (Object)request);
        request.setResponseMode(ResponseMode.STREAMING);
        Call<ResponseBody> call = this.workflowApiService.runWorkflowStream(request);
        DIfyApiServiceGenerator.executeStreamRequest(call, line -> DIfyApiServiceGenerator.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchWorkflowEvent(callback, data)), callback::onException);
    }

    public WorkflowRunStatusResponse getWorkflowRunStatus(String workflowRunId) {
        log.debug("get workflow run status, workflowRunId={}", (Object)workflowRunId);
        return DIfyApiServiceGenerator.executeSync(this.workflowApiService.getWorkflowRunStatus(workflowRunId));
    }

    public WorkflowStopResponse stopWorkflow(String taskId, SimpleUserRequest request) {
        log.debug("stop workflow, taskId={}, request={}", (Object)taskId, (Object)request);
        return DIfyApiServiceGenerator.executeSync(this.workflowApiService.stopWorkflow(taskId, request));
    }

    public WorkflowLogListResponse getWorkflowLogs(String keyword, String status, Integer page, Integer limit) {
        log.debug("get workflow logs, keyword={}, status={}, page={}, limit={}", new Object[]{keyword, status, page, limit});
        return DIfyApiServiceGenerator.executeSync(this.workflowApiService.getWorkflowLogs(keyword, status, page, limit));
    }
}

