/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.api.callback;

import com.livehelps.dify.api.callback.ChatStreamCallback;
import com.livehelps.dify.api.callback.ChatflowStreamCallback;
import com.livehelps.dify.api.callback.CompletionStreamCallback;
import com.livehelps.dify.api.callback.StreamCallback;
import com.livehelps.dify.api.callback.WorkflowStreamCallback;
import com.livehelps.dify.data.enums.StreamEventType;
import com.livehelps.dify.data.event.AgentMessageEvent;
import com.livehelps.dify.data.event.AgentThoughtEvent;
import com.livehelps.dify.data.event.BaseEvent;
import com.livehelps.dify.data.event.ErrorEvent;
import com.livehelps.dify.data.event.MessageEndEvent;
import com.livehelps.dify.data.event.MessageEvent;
import com.livehelps.dify.data.event.MessageFileEvent;
import com.livehelps.dify.data.event.MessageReplaceEvent;
import com.livehelps.dify.data.event.NodeFinishedEvent;
import com.livehelps.dify.data.event.NodeStartedEvent;
import com.livehelps.dify.data.event.PingEvent;
import com.livehelps.dify.data.event.TtsMessageEndEvent;
import com.livehelps.dify.data.event.TtsMessageEvent;
import com.livehelps.dify.data.event.WorkflowFinishedEvent;
import com.livehelps.dify.data.event.WorkflowStartedEvent;
import com.livehelps.dify.data.event.WorkflowTextChunkEvent;
import com.livehelps.dify.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEventDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamEventDispatcher.class);
    private static final Map<StreamEventType, BiConsumer<ChatflowStreamCallback, String>> chatFlowEventHandlers = new HashMap<StreamEventType, BiConsumer<ChatflowStreamCallback, String>>();
    private static final Map<StreamEventType, BiConsumer<ChatStreamCallback, String>> chatEventHandlers = new HashMap<StreamEventType, BiConsumer<ChatStreamCallback, String>>();
    private static final Map<StreamEventType, BiConsumer<CompletionStreamCallback, String>> completionEventHandlers = new HashMap<StreamEventType, BiConsumer<CompletionStreamCallback, String>>();
    private static final Map<StreamEventType, BiConsumer<WorkflowStreamCallback, String>> workflowEventHandlers = new HashMap<StreamEventType, BiConsumer<WorkflowStreamCallback, String>>();

    public static void dispatchChatFlowEvent(ChatflowStreamCallback callback, String data, String StreamEventType2) {
        StreamEventDispatcher.dispatchEvent(callback, data, StreamEventType2, chatFlowEventHandlers);
    }

    public static void dispatchChatEvent(ChatStreamCallback callback, String data, String StreamEventType2) {
        StreamEventDispatcher.dispatchEvent(callback, data, StreamEventType2, chatEventHandlers);
    }

    public static void dispatchCompletionEvent(CompletionStreamCallback callback, String data) {
        BaseEvent baseEvent = JSONUtils.fromJson(data, BaseEvent.class);
        if (baseEvent == null) {
            log.warn("process event data null: {}", (Object)data);
            return;
        }
        String StreamEventTypeStr = baseEvent.getEvent();
        StreamEventDispatcher.dispatchEvent(callback, data, StreamEventTypeStr, completionEventHandlers);
    }

    public static void dispatchWorkflowEvent(WorkflowStreamCallback callback, String data) {
        BaseEvent baseEvent = JSONUtils.fromJson(data, BaseEvent.class);
        if (baseEvent == null) {
            log.warn("process event data null: {}", (Object)data);
            return;
        }
        String StreamEventTypeStr = baseEvent.getEvent();
        StreamEventDispatcher.dispatchEvent(callback, data, StreamEventTypeStr, workflowEventHandlers);
    }

    private static <T, C> void dispatchEvent(C callback, String data, String StreamEventTypeStr, Map<StreamEventType, BiConsumer<C, String>> handlers) {
        try {
            StreamEventType type = StreamEventType.fromValue(StreamEventTypeStr);
            if (type == null) {
                log.warn("unknow event type: {}", (Object)StreamEventTypeStr);
                return;
            }
            BiConsumer<C, String> handler = handlers.get((Object)type);
            if (handler != null) {
                handler.accept(callback, data);
            } else {
                log.warn("not process event type: {}", (Object)StreamEventTypeStr);
            }
        }
        catch (Exception e) {
            log.error("callback exception: {}", (Object)e.getMessage(), (Object)e);
            try {
                if (callback instanceof ChatflowStreamCallback) {
                    ((ChatflowStreamCallback)callback).onException(e);
                } else if (callback instanceof ChatStreamCallback) {
                    ((ChatStreamCallback)callback).onException(e);
                } else if (callback instanceof CompletionStreamCallback) {
                    ((CompletionStreamCallback)callback).onException(e);
                } else if (callback instanceof WorkflowStreamCallback) {
                    ((WorkflowStreamCallback)callback).onException(e);
                }
            }
            catch (Exception ex) {
                log.error("callback exception", (Throwable)ex);
            }
        }
    }

    private static <T, C> void handleEvent(C callback, String data, Class<T> clazz, BiConsumer<C, T> consumer) {
        try {
            T event = JSONUtils.fromJson(data, clazz);
            consumer.accept(callback, event);
        }
        catch (Exception e) {
            log.error("Exception occurred while parsing event data: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    static {
        chatFlowEventHandlers.put(StreamEventType.MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEvent.class, ChatStreamCallback::onMessage));
        chatFlowEventHandlers.put(StreamEventType.MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEndEvent.class, ChatStreamCallback::onMessageEnd));
        chatFlowEventHandlers.put(StreamEventType.MESSAGE_FILE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageFileEvent.class, ChatStreamCallback::onMessageFile));
        chatFlowEventHandlers.put(StreamEventType.TTS_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEvent.class, ChatStreamCallback::onTTSMessage));
        chatFlowEventHandlers.put(StreamEventType.TTS_MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEndEvent.class, ChatStreamCallback::onTTSMessageEnd));
        chatFlowEventHandlers.put(StreamEventType.MESSAGE_REPLACE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageReplaceEvent.class, ChatStreamCallback::onMessageReplace));
        chatFlowEventHandlers.put(StreamEventType.AGENT_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, AgentMessageEvent.class, ChatStreamCallback::onAgentMessage));
        chatFlowEventHandlers.put(StreamEventType.AGENT_THOUGHT, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, AgentThoughtEvent.class, ChatStreamCallback::onAgentThought));
        chatFlowEventHandlers.put(StreamEventType.WORKFLOW_STARTED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, WorkflowStartedEvent.class, ChatflowStreamCallback::onWorkflowStarted));
        chatFlowEventHandlers.put(StreamEventType.NODE_STARTED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, NodeStartedEvent.class, ChatflowStreamCallback::onNodeStarted));
        chatFlowEventHandlers.put(StreamEventType.NODE_FINISHED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, NodeFinishedEvent.class, ChatflowStreamCallback::onNodeFinished));
        chatFlowEventHandlers.put(StreamEventType.WORKFLOW_FINISHED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, WorkflowFinishedEvent.class, ChatflowStreamCallback::onWorkflowFinished));
        chatFlowEventHandlers.put(StreamEventType.ERROR, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, ErrorEvent.class, StreamCallback::onError));
        chatFlowEventHandlers.put(StreamEventType.PING, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, PingEvent.class, StreamCallback::onPing));
        chatEventHandlers.put(StreamEventType.MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEvent.class, ChatStreamCallback::onMessage));
        chatEventHandlers.put(StreamEventType.MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEndEvent.class, ChatStreamCallback::onMessageEnd));
        chatEventHandlers.put(StreamEventType.MESSAGE_FILE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageFileEvent.class, ChatStreamCallback::onMessageFile));
        chatEventHandlers.put(StreamEventType.TTS_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEvent.class, ChatStreamCallback::onTTSMessage));
        chatEventHandlers.put(StreamEventType.TTS_MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEndEvent.class, ChatStreamCallback::onTTSMessageEnd));
        chatEventHandlers.put(StreamEventType.MESSAGE_REPLACE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageReplaceEvent.class, ChatStreamCallback::onMessageReplace));
        chatEventHandlers.put(StreamEventType.AGENT_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, AgentMessageEvent.class, ChatStreamCallback::onAgentMessage));
        chatEventHandlers.put(StreamEventType.AGENT_THOUGHT, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, AgentThoughtEvent.class, ChatStreamCallback::onAgentThought));
        chatEventHandlers.put(StreamEventType.ERROR, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, ErrorEvent.class, StreamCallback::onError));
        chatEventHandlers.put(StreamEventType.PING, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, PingEvent.class, StreamCallback::onPing));
        completionEventHandlers.put(StreamEventType.MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEvent.class, CompletionStreamCallback::onMessage));
        completionEventHandlers.put(StreamEventType.MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageEndEvent.class, CompletionStreamCallback::onMessageEnd));
        completionEventHandlers.put(StreamEventType.TTS_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEvent.class, CompletionStreamCallback::onTtsMessage));
        completionEventHandlers.put(StreamEventType.TTS_MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEndEvent.class, CompletionStreamCallback::onTtsMessageEnd));
        completionEventHandlers.put(StreamEventType.MESSAGE_REPLACE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, MessageReplaceEvent.class, CompletionStreamCallback::onMessageReplace));
        completionEventHandlers.put(StreamEventType.ERROR, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, ErrorEvent.class, StreamCallback::onError));
        completionEventHandlers.put(StreamEventType.PING, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, PingEvent.class, StreamCallback::onPing));
        workflowEventHandlers.put(StreamEventType.WORKFLOW_STARTED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, WorkflowStartedEvent.class, WorkflowStreamCallback::onWorkflowStarted));
        workflowEventHandlers.put(StreamEventType.NODE_STARTED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, NodeStartedEvent.class, WorkflowStreamCallback::onNodeStarted));
        workflowEventHandlers.put(StreamEventType.NODE_FINISHED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, NodeFinishedEvent.class, WorkflowStreamCallback::onNodeFinished));
        workflowEventHandlers.put(StreamEventType.WORKFLOW_FINISHED, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, WorkflowFinishedEvent.class, WorkflowStreamCallback::onWorkflowFinished));
        workflowEventHandlers.put(StreamEventType.WORKFLOW_TEXT_CHUNK, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, WorkflowTextChunkEvent.class, WorkflowStreamCallback::onWorkflowTextChunk));
        workflowEventHandlers.put(StreamEventType.TTS_MESSAGE, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEvent.class, WorkflowStreamCallback::onTtsMessage));
        workflowEventHandlers.put(StreamEventType.TTS_MESSAGE_END, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, TtsMessageEndEvent.class, WorkflowStreamCallback::onTtsMessageEnd));
        workflowEventHandlers.put(StreamEventType.PING, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, PingEvent.class, StreamCallback::onPing));
        workflowEventHandlers.put(StreamEventType.ERROR, (callback, data) -> StreamEventDispatcher.handleEvent(callback, data, ErrorEvent.class, StreamCallback::onError));
    }
}

