/*
 * Decompiled with CFR 0.152.
 */
package com.livehelps.dify.service;

import com.livehelps.dify.data.request.datasets.CreateDatasetRequest;
import com.livehelps.dify.data.request.datasets.CreateDocumentByTextRequest;
import com.livehelps.dify.data.request.datasets.CreateMetadataRequest;
import com.livehelps.dify.data.request.datasets.CreateSegmentsRequest;
import com.livehelps.dify.data.request.datasets.RetrieveRequest;
import com.livehelps.dify.data.request.datasets.SubmitChildChunkRequest;
import com.livehelps.dify.data.request.datasets.UpdateDatasetRequest;
import com.livehelps.dify.data.request.datasets.UpdateDocumentByTextRequest;
import com.livehelps.dify.data.request.datasets.UpdateDocumentMetadataRequest;
import com.livehelps.dify.data.request.datasets.UpdateMetadataRequest;
import com.livehelps.dify.data.request.datasets.UpdateSegmentsRequest;
import com.livehelps.dify.data.response.datasets.ChildChunkListResponse;
import com.livehelps.dify.data.response.datasets.ChildChunkResponse;
import com.livehelps.dify.data.response.datasets.CreateSegmentResponse;
import com.livehelps.dify.data.response.datasets.DatasetListResponse;
import com.livehelps.dify.data.response.datasets.DatasetMetadataResponse;
import com.livehelps.dify.data.response.datasets.DatasetResponse;
import com.livehelps.dify.data.response.datasets.DocumentIndexingStatusResponse;
import com.livehelps.dify.data.response.datasets.DocumentListResponse;
import com.livehelps.dify.data.response.datasets.DocumentResponse;
import com.livehelps.dify.data.response.datasets.DocumentUploadFileResponse;
import com.livehelps.dify.data.response.datasets.EmbeddingModelListResponse;
import com.livehelps.dify.data.response.datasets.MetadataResponse;
import com.livehelps.dify.data.response.datasets.RetrieveResponse;
import com.livehelps.dify.data.response.datasets.SegmentListResponse;
import com.livehelps.dify.data.response.datasets.UpdateSegmentResponse;
import okhttp3.MultipartBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface DifyDatasetsApiService {
    public static final String DATASETS_PATH = "datasets";
    public static final String DATASETS_EMBEDDING_MODELS_PATH = "workspaces/current/models/model-types/text-embedding";

    @POST(value="datasets")
    public Call<DatasetResponse> createDataset(@Body CreateDatasetRequest var1);

    @PATCH(value="datasets/{dataset_id}")
    public Call<DatasetResponse> updateDataset(@Path(value="dataset_id") String var1, @Body UpdateDatasetRequest var2);

    @GET(value="datasets")
    public Call<DatasetListResponse> listDataset(@Query(value="page") Integer var1, @Query(value="limit") Integer var2);

    @GET(value="datasets/{dataset_id}")
    public Call<DatasetResponse> getDataset(@Path(value="dataset_id") String var1);

    @DELETE(value="datasets/{dataset_id}")
    public Call<Void> deleteDataset(@Path(value="dataset_id") String var1);

    @POST(value="datasets/{dataset_id}/document/create-by-text")
    public Call<DocumentResponse> createDocumentByText(@Path(value="dataset_id") String var1, @Body CreateDocumentByTextRequest var2);

    @Multipart
    @POST(value="datasets/{dataset_id}/document/create-by-file")
    public Call<DocumentResponse> createDocumentByFile(@Path(value="dataset_id") String var1, @Part MultipartBody.Part var2, @Part MultipartBody.Part var3);

    @POST(value="datasets/{dataset_id}/documents/{document_id}/update-by-text")
    public Call<DocumentResponse> updateDocumentByText(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Body UpdateDocumentByTextRequest var3);

    @Multipart
    @POST(value="datasets/{dataset_id}/documents/{document_id}/update-by-file")
    public Call<DocumentResponse> updateDocumentByFile(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Part MultipartBody.Part var3, @Part MultipartBody.Part var4);

    @GET(value="datasets/{dataset_id}/documents/{batch}/indexing-status")
    public Call<DocumentIndexingStatusResponse> getDocumentIndexingStatus(@Path(value="dataset_id") String var1, @Path(value="batch") String var2);

    @DELETE(value="datasets/{dataset_id}/documents/{document_id}")
    public Call<Void> deleteDocument(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2);

    @GET(value="datasets/{dataset_id}/documents")
    public Call<DocumentListResponse> listDocuments(@Path(value="dataset_id") String var1, @Query(value="keyword") String var2, @Query(value="page") Integer var3, @Query(value="limit") Integer var4);

    @POST(value="datasets/{dataset_id}/documents/{document_id}/segments")
    public Call<CreateSegmentResponse> createDocumentSegments(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Body CreateSegmentsRequest var3);

    @POST(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}")
    public Call<UpdateSegmentResponse> updateDocumentSegment(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3, @Body UpdateSegmentsRequest var4);

    @GET(value="datasets/{dataset_id}/documents/{document_id}/segments")
    public Call<SegmentListResponse> listDocumentSegments(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Query(value="keyword") String var3, @Query(value="status") String var4, @Query(value="page") Integer var5, @Query(value="limit") Integer var6);

    @DELETE(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}")
    public Call<Void> deleteDocumentSegment(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3);

    @POST(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}/child_chunks")
    public Call<ChildChunkResponse> createChildChunk(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3, @Body SubmitChildChunkRequest var4);

    @PATCH(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}/child_chunks/{child_chunk_id}")
    public Call<ChildChunkResponse> updateChildChunk(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3, @Path(value="child_chunk_id") String var4, @Body SubmitChildChunkRequest var5);

    @GET(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}/child_chunks")
    public Call<ChildChunkListResponse> listChildChunks(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3, @Query(value="keyword") String var4, @Query(value="page") Integer var5, @Query(value="limit") Integer var6);

    @DELETE(value="datasets/{dataset_id}/documents/{document_id}/segments/{segment_id}/child_chunks/{child_chunk_id}")
    public Call<Void> deleteChildChunk(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2, @Path(value="segment_id") String var3, @Path(value="child_chunk_id") String var4);

    @GET(value="datasets/{dataset_id}/documents/{document_id}/upload-file")
    public Call<DocumentUploadFileResponse> getDocumentUploadFile(@Path(value="dataset_id") String var1, @Path(value="document_id") String var2);

    @POST(value="datasets/{dataset_id}/metadata")
    public Call<MetadataResponse> createMetadata(@Path(value="dataset_id") String var1, @Body CreateMetadataRequest var2);

    @PATCH(value="datasets/{dataset_id}/metadata/{metadata_id}")
    public Call<MetadataResponse> updateMetadata(@Path(value="dataset_id") String var1, @Path(value="metadata_id") String var2, @Body UpdateMetadataRequest var3);

    @DELETE(value="datasets/{dataset_id}/metadata/{metadata_id}")
    public Call<Void> deleteMetadata(@Path(value="dataset_id") String var1, @Path(value="metadata_id") String var2);

    @POST(value="datasets/{dataset_id}/metadata/built-in/{action}")
    public Call<Void> toggleBuiltInMetadata(@Path(value="dataset_id") String var1, @Path(value="action") String var2);

    @POST(value="datasets/{dataset_id}/documents/metadata")
    public Call<Void> updateDocumentMetadata(@Path(value="dataset_id") String var1, @Body UpdateDocumentMetadataRequest var2);

    @GET(value="datasets/{dataset_id}/metadata")
    public Call<DatasetMetadataResponse> listDatasetMetadata(@Path(value="dataset_id") String var1);

    @GET(value="workspaces/current/models/model-types/text-embedding")
    public Call<EmbeddingModelListResponse> listEmbeddingModels();

    @POST(value="datasets/{dataset_id}/retrieve")
    public Call<RetrieveResponse> retrieveDataset(@Path(value="dataset_id") String var1, @Body RetrieveRequest var2);
}

