/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.impl.AbstractJavaFunction;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.RankFunction;

public abstract class AbstractDatabaseFunctionAbstract
extends AbstractJavaFunction {
    public String rank(AbstractFunction function) {
        return this.getRankDatabaseSql("RANK", function);
    }

    public String denseRank(AbstractFunction function) {
        return this.getRankDatabaseSql("DENSE_RANK", function);
    }

    public String rowNumber(AbstractFunction function) {
        return this.getRankDatabaseSql("ROW_NUMBER", function);
    }

    private String getRankDatabaseSql(String keyword, AbstractFunction function) {
        int i;
        int size;
        DatabaseType databaseType = this.getDatabaseType();
        if (databaseType == null) {
            throw new SQLBuildException("\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(function instanceof RankFunction)) {
            throw new SQLBuildException((Object)((Object)function.getModelType()) + "\u4e0d\u662f\u6392\u540d\u51fd\u6570");
        }
        RankFunction rankFunction = (RankFunction)function;
        StringBuilder sql = new StringBuilder();
        sql.append(keyword).append(" () OVER (");
        if (rankFunction.getPartitionList() != null && !rankFunction.getPartitionList().isEmpty()) {
            sql.append("PARTITION BY ");
            size = rankFunction.getPartitionList().size();
            for (i = 0; i < size; ++i) {
                sql.append(rankFunction.getPartitionList().get(i).getDatabaseSql(databaseType));
                if (i == size - 1) continue;
                sql.append(",");
            }
        }
        if (rankFunction.getOrderList() == null || rankFunction.getOrderList().isEmpty()) {
            throw new SQLBuildException("\u6392\u540d\u51fd\u6570order by\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sql.append(" ORDER BY ");
        size = rankFunction.getOrderList().size();
        for (i = 0; i < size; ++i) {
            sql.append(rankFunction.getOrderList().get(i).getDatabaseSql(databaseType));
            if (i == size - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }
}

