/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.IDatabaseFunction;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.util.PropertyUtils;
import java.util.Objects;

public abstract class AbstractJavaFunction
implements IDatabaseFunction {
    protected Function isFunction(AbstractFunction abstractFunction) {
        if (!(abstractFunction instanceof Function)) {
            throw new SQLBuildException("\u51fd\u6570\u6784\u9020\u65b9\u6cd5\u4e0d\u6b63\u786e");
        }
        return (Function)abstractFunction;
    }

    protected void verifyParamSize(Function function, int size) {
        int realParamSize = function.getParamList().size();
        if (realParamSize != size) {
            throw new SQLBuildException("\u51fd\u6570" + function.getFunctionType().getCode() + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u9700\u8981" + size + "\u4e2a\uff0c\u5b9e\u9645" + realParamSize + "\u4e2a");
        }
    }

    protected String getDatabaseTimeUnit(Function function, int paramSize, int index) {
        TimeUnitType timeUnitType = this.getTimeUnitType(function, paramSize, index);
        return PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), timeUnitType);
    }

    protected TimeUnitType getTimeUnitType(Function function, int paramSize, int index) {
        this.verifyParamSize(function, paramSize);
        String str = function.getParamList().get(index).getDatabaseSql(this.getDatabaseType());
        TimeUnitType type = TimeUnitType.getEnumByCode(str.replaceAll("'", ""));
        if (Objects.isNull((Object)type)) {
            throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301" + str + "\u65f6\u95f4\u5355\u4f4d");
        }
        return type;
    }

    protected DateFormatType getDateFormatType(Function function, int paramSize, int index) {
        this.verifyParamSize(function, paramSize);
        String str = function.getParamList().get(index).getDatabaseSql(this.getDatabaseType());
        DateFormatType type = DateFormatType.getEnumByCode(str.replaceAll("'", ""));
        if (Objects.isNull((Object)type)) {
            throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301" + str + "\u65f6\u95f4\u683c\u5f0f");
        }
        return type;
    }
}

