/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.impl.AbstractDatabaseFunctionAbstract;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;

public class ClickhouseFunction
extends AbstractDatabaseFunctionAbstract {
    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.CLICKHOUSE;
    }

    public String strToDate(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        DateFormatType dateFormatType = this.getDateFormatType(function, 2, 1);
        String model1 = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        switch (dateFormatType) {
            case YYYY_MM_DD: {
                return "toDate(" + model1 + ")";
            }
            case YYYY_MM_DD_HH24_MI_SS: {
                return "toDateTime(" + model1 + ")";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + dateFormatType.getName() + "\u683c\u5f0f");
    }

    public String addDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        switch (timeUnitType) {
            case YEAR: {
                return "addYears(" + model + "," + value + ")";
            }
            case QUARTER: {
                return "addQuarters(" + model + "," + value + ")";
            }
            case MONTH: {
                return "addMonths(" + model + "," + value + ")";
            }
            case WEEK: {
                return "addWeeks(" + model + "," + value + ")";
            }
            case DAY: {
                return "addDays(" + model + "," + value + ")";
            }
            case HOUR: {
                return "addHours(" + model + "," + value + ")";
            }
            case MINUTE: {
                return "addMinutes(" + model + "," + value + ")";
            }
            case SECOND: {
                return "addSeconds(" + model + "," + value + ")";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + timeUnitType.getName() + "\u65f6\u95f4\u5355\u4f4d");
    }

    public String subDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        switch (timeUnitType) {
            case YEAR: {
                return "subtractYears(" + model + "," + value + ")";
            }
            case QUARTER: {
                return "subtractQuarters(" + model + "," + value + ")";
            }
            case MONTH: {
                return "subtractMonths(" + model + "," + value + ")";
            }
            case WEEK: {
                return "subtractWeeks(" + model + "," + value + ")";
            }
            case DAY: {
                return "subtractDays(" + model + "," + value + ")";
            }
            case HOUR: {
                return "subtractHours(" + model + "," + value + ")";
            }
            case MINUTE: {
                return "subtractMinutes(" + model + "," + value + ")";
            }
            case SECOND: {
                return "subtractSeconds(" + model + "," + value + ")";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + timeUnitType.getName() + "\u65f6\u95f4\u5355\u4f4d");
    }

    public String dateDiff(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        String timeUnit = this.getDatabaseTimeUnit(function, 3, 0);
        String model1 = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String model2 = function.getParamList().get(2).getDatabaseSql(this.getDatabaseType());
        return "dateDiff(" + timeUnit + "," + model1 + "," + model2 + ")";
    }
}

