/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.impl.AbstractDatabaseFunctionAbstract;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.util.PropertyUtils;

public class OracleSqlFunction
extends AbstractDatabaseFunctionAbstract {
    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.ORACLE;
    }

    public String addDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        return this.addOrSubDateTime(model, value, timeUnitType);
    }

    public String subDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        value = "-1*" + value;
        return this.addOrSubDateTime(model, value, timeUnitType);
    }

    public String dateDiff(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 0);
        String model1 = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String model2 = function.getParamList().get(2).getDatabaseSql(this.getDatabaseType());
        switch (timeUnitType) {
            case YEAR: {
                return "MONTHS_BETWEEN(" + model1 + "," + model2 + ")/12";
            }
            case QUARTER: {
                return "MONTHS_BETWEEN(" + model1 + "," + model2 + ")/3";
            }
            case MONTH: {
                return "MONTHS_BETWEEN(" + model1 + "," + model2 + ")";
            }
            case WEEK: {
                return "TO_NUMBER(" + model1 + "-" + model2 + ")/7";
            }
            case DAY: {
                return "TO_NUMBER(" + model1 + "-" + model2 + ")";
            }
            case HOUR: {
                return "TO_NUMBER(" + model1 + "-" + model2 + ")*24";
            }
            case MINUTE: {
                return "TO_NUMBER(" + model1 + "-" + model2 + ")*24*60";
            }
            case SECOND: {
                return "TO_NUMBER(" + model1 + "-" + model2 + ")*24*60*60";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + timeUnitType.getName() + "\u65f6\u95f4\u5355\u4f4d");
    }

    private String addOrSubDateTime(String modelStr, String valueStr, TimeUnitType timeUnitType) {
        switch (timeUnitType) {
            case YEAR: {
                return "add_months(" + modelStr + "," + valueStr + "*12)";
            }
            case QUARTER: {
                return "add_months(" + modelStr + "," + valueStr + "*3)";
            }
            case MONTH: {
                return "add_months(" + modelStr + "," + valueStr + ")";
            }
            case WEEK: {
                return "(" + modelStr + "+numtodsinterval(" + valueStr + ",'" + PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), TimeUnitType.DAY) + "'))";
            }
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return "(" + modelStr + "+numtodsinterval(" + valueStr + ",'" + PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), timeUnitType) + "'))";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + timeUnitType.getName() + "\u65f6\u95f4\u5355\u4f4d");
    }
}

