/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.impl.AbstractDatabaseFunctionAbstract;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.util.PropertyUtils;

public class PostgresqlFunction
extends AbstractDatabaseFunctionAbstract {
    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRESQL;
    }

    public String addDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        return this.addOrSubDateTime(model, value, timeUnitType);
    }

    public String subDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        value = "-1*" + value;
        return this.addOrSubDateTime(model, value, timeUnitType);
    }

    public String dateDiff(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 0);
        String model1 = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String model2 = function.getParamList().get(2).getDatabaseSql(this.getDatabaseType());
        String str = "DATE_PART('epoch'," + model1 + "-" + model2 + ")";
        switch (timeUnitType) {
            case YEAR: {
                return "ROUND(" + str + "/(60*60*24*365))";
            }
            case QUARTER: {
                return "ROUND(" + str + "/(60*60*24*90))";
            }
            case MONTH: {
                return "ROUND(" + str + "/(60*60*24*30))";
            }
            case WEEK: {
                return "ROUND(" + str + "/(60*60*24*7))";
            }
            case DAY: {
                return "ROUND(" + str + "/(60*60*24))";
            }
            case HOUR: {
                return "ROUND(" + str + "/(60*60))";
            }
            case MINUTE: {
                return "ROUND(" + str + "/60)";
            }
            case SECOND: {
                return "ROUND(" + str + ")";
            }
        }
        throw new SQLBuildException(this.getDatabaseType().getCode() + "\u6682\u4e0d\u652f\u6301" + timeUnitType.getName() + "\u65f6\u95f4\u5355\u4f4d");
    }

    private String addOrSubDateTime(String model, String value, TimeUnitType timeUnitType) {
        if (timeUnitType == TimeUnitType.QUARTER) {
            return "(" + model + "+INTERVAL '" + value + "*3 " + PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), TimeUnitType.MONTH) + "')";
        }
        return "(" + model + "+INTERVAL '" + value + " " + PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), timeUnitType) + "')";
    }
}

