/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.impl.AbstractDatabaseFunctionAbstract;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.util.PropertyUtils;

public class SparkFunction
extends AbstractDatabaseFunctionAbstract {
    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SPARK;
    }

    public String addDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String unitStr = PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), timeUnitType);
        switch (timeUnitType) {
            case QUARTER: {
                return "(" + model + "+ INTERVAL 3*" + value + " " + unitStr + ")";
            }
            case YEAR: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return "(" + model + "+ INTERVAL " + value + " " + unitStr + ")";
            }
        }
        throw new SQLBuildException("spark\u6682\u4e0d\u652f\u6301\u8be5" + timeUnitType.getCode() + "\u65f6\u95f4\u5355\u4f4d\u52a0\u51cf");
    }

    public String subDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String unitStr = PropertyUtils.getDatabaseTimeUnit(this.getDatabaseType(), timeUnitType);
        switch (timeUnitType) {
            case QUARTER: {
                return "(" + model + "- INTERVAL 3*" + value + " " + unitStr + ")";
            }
            case YEAR: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return "(" + model + "- INTERVAL " + value + " " + unitStr + ")";
            }
        }
        throw new SQLBuildException("spark\u6682\u4e0d\u652f\u6301\u8be5" + timeUnitType.getCode() + "\u65f6\u95f4\u5355\u4f4d\u52a0\u51cf");
    }

    public String dateDiff(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        TimeUnitType timeUnitType = this.getTimeUnitType(function, 3, 0);
        String model1 = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String model2 = function.getParamList().get(2).getDatabaseSql(this.getDatabaseType());
        String day = "datediff(" + model1 + "," + model2 + ")";
        switch (timeUnitType) {
            case DAY: {
                return day;
            }
        }
        throw new SQLBuildException("spark\u6682\u4e0d\u652f\u6301" + timeUnitType.getCode() + "\u65f6\u95f4\u5355\u4f4d\u95f4\u9694");
    }
}

