/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.function.impl;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.function.impl.AbstractDatabaseFunctionAbstract;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.util.PropertyUtils;

public class SqlServerFunction
extends AbstractDatabaseFunctionAbstract {
    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.MSSQL;
    }

    public String strToDate(AbstractFunction abstractFunction) {
        String str;
        Function function = this.isFunction(abstractFunction);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        DateFormatType dateFormatType = this.getDateFormatType(function, 2, 1);
        switch (dateFormatType) {
            case YYYY_MM_DD: 
            case YYYYMMDD: {
                str = "date";
                break;
            }
            case HH24MISS: 
            case HH24_MI_SS: {
                str = "time";
                break;
            }
            default: {
                str = "datetime";
            }
        }
        return "CONVERT(" + str + "," + model + "," + PropertyUtils.getDatabaseDateFormat(this.getDatabaseType(), dateFormatType) + ")";
    }

    public String addDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        String timeUnit = this.getDatabaseTimeUnit(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        return "DATEADD(" + timeUnit + "," + value + ", " + model + ")";
    }

    public String subDateTime(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        String timeUnit = this.getDatabaseTimeUnit(function, 3, 2);
        String model = function.getParamList().get(0).getDatabaseSql(this.getDatabaseType());
        String value = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        return "DATEADD(" + timeUnit + ",-1*" + value + ", " + model + ")";
    }

    public String dateDiff(AbstractFunction abstractFunction) {
        Function function = this.isFunction(abstractFunction);
        String timeUnit = this.getDatabaseTimeUnit(function, 3, 0);
        String model1 = function.getParamList().get(1).getDatabaseSql(this.getDatabaseType());
        String model2 = function.getParamList().get(2).getDatabaseSql(this.getDatabaseType());
        return "DATEDIFF(" + timeUnit + "," + model1 + "," + model2 + ")";
    }
}

